;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Expand/assert.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  9 16:41:17 1993                          */
;*    Last change :  Tue Jul 11 15:09:36 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'expansion des formes `assert'                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_assert
   (include "Tools/location.sch")
   (import  engine_param
	    tools_error
	    tools_misc
	    tools_location
	    tools_progn)
   (export  (expand-assert x e)))

;*---------------------------------------------------------------------*/
;*    expand-assert ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-assert x e)
   (match-case x
      ((?- check (and ?vars (? pair?)) . ?body)
       ;; this is the old (1.7) style to introduce assertion
       (let ((new `(assert ,vars ,@body)))
	  (replace! x new)
	  (e x e)))
      ((?- (and ?vars (? list?)) . ?pred)
       (if (and (integer? *compiler-debug*) (>=fx *compiler-debug* 3))
	   (let ((new (make-one-assert e x vars pred)))
	      (replace! x new))
	   #unspecified))
      (else
       (error "assert" "Illegal `assert' form" x))))
 
;*---------------------------------------------------------------------*/
;*    make-one-assert ...                                              */
;*---------------------------------------------------------------------*/
(define (make-one-assert e exp vars pred)
   (let ((old-pred (duplicate pred)))
      `(if ,(e (normalize-progn pred) e)
	   #unspecified
	   (begin
	      ;; we send all vars to the interpreters
	      ,@(let loop ((vars vars)
			   (defs '()))
		   (if (null? vars)
		       defs
		       (loop (cdr vars)
			     (cons `(define-primop-ref! ',(car vars)
				       (location ,(car vars)))
				   defs))))
	      ,(let ((loc (let ((loc (find-location exp)))
			     (if (loc? loc)
				 loc
				 (find-location pred)))))
		  `(notify-assert-fail ',vars
				       ',(cons 'begin old-pred)
				       ,(if (loc? loc)
					    `',(cons (loc-full-fname loc)
						     (loc-pos loc))
					    #f)))
	      ,@(let loop ((vars vars)
			   (defs '()))
		   (if (null? vars)
		       defs
		       (loop (cdr vars)
			     (cons `(unbind-primop! ',(car vars))
				   defs))))))))

;*---------------------------------------------------------------------*/
;*    duplicate ...                                                    */
;*---------------------------------------------------------------------*/
(define (duplicate pred)
   (cond
      ((pair? pred)
       (cons (duplicate (car pred)) (duplicate (cdr pred))))
      (else
       pred)))


