;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Init/signals.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Feb 13 09:50:26 1994                          */
;*    Last change :  Tue Feb  6 18:03:16 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On recupere tous les signaux pour ne plus avoir de message       */
;*    intenpestifs.                                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module init_signals
   (import  main
	    engine_param)
   (foreign (include "signal.h"))
   (export  (init-compiler-signals!)))

;*---------------------------------------------------------------------*/
;*    init-compiler-signals! ...                                       */
;*---------------------------------------------------------------------*/
(define (init-compiler-signals!)
   (let ((kill-my-self (lambda (n)
			  (if (>fx *verbose* 0)
			      (notify-error "Illegal signal caught"
					    n
					    "aborting...")
			      (notify-error "internal error"
					    "aborting"
					    #f))
			  (exit-bigloo -1))))
      (signal sigfpe kill-my-self)
      (signal sigill kill-my-self)
      (signal sigbus kill-my-self)
      (signal sigsegv kill-my-self)))


