;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Parse/import.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 10:00:41 1994                          */
;*    Last change :  Mon Jul 17 11:16:36 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We parse importation clauses.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module parse_import
   (include "Ast/ast.sch")
   (import  engine_param
	    read_access
	    read_import
	    parse_definition
	    tools_args
	    tools_error
	    ast_global
	    ast_env)
   (export (parse-import/use <s-exp> <import/use>)
	   (parse-imported   <s-exp> <string>)))

;*---------------------------------------------------------------------*/
;*    parse-import ...                                                 */
;*    -------------------------------------------------------------    */
;*    The syntaxe of importation clause is:                            */
;*    import ::= module-name               |                           */
;*               (module-name "file-name") |                           */
;*               (variable module-name)    |                           */
;*               (variable module-name "file-name")                    */
;*---------------------------------------------------------------------*/
(define (parse-import/use imports mode)
   [assert check (mode) (or (eq? mode 'import) (eq? mode 'use))]
   (if (null? imports)
       'done
       ;; we compute the list of all required module. For each
       ;; of them, we compute the list of imported bindings.
       (let loop ((clauses  imports)
		  (modules  '()))
	  (if (null? clauses)
	      (read-imported-modules modules mode)
	      (match-case (car clauses)
		 ((?first ?second)
		  (cond
		     ((string? second)
		      ;; (module-name "file-name")
		      (begin
			 (add-access! first second)
			 (let ((b (assq first modules)))
			    (if b
				(begin
				   (set-cdr! b '())
				   (loop (cdr clauses) modules))
				(loop (cdr clauses)
				      (cons (cons first '())
					    modules))))))
		     (else
		      ;; (variable module-name)
		      (let ((b (assq second modules)))
			 (if (not b)
			     (loop (cdr clauses)
				   (cons (cons second (list first))
					 modules))
			     (if (null? (cdr b))
				 (loop (cdr clauses) modules)
				 (begin
				    (if (not (memq first (cdr b)))
					(set-cdr! b (cons first (cdr b))))
				    (loop (cdr clauses)
					  modules))))))))

		 ((?var ?module ?file)
		  ;; (variable module-name "file-name") 
		  (if (not (string? file))
		      (user-error "parse-import"
				  "Illegal import clause"
				  (car clauses))
		      (begin
			 (add-access! module file)
			 (let ((b (assq module modules)))
			    (if (not b)
				(loop (cdr clauses)
				      (cons (cons module (list var))
					    modules))
				(if (null? (cdr b))
				    (loop (cdr clauses) modules)
				    (begin
				       (if (not (memq var (cdr b)))
					   (set-cdr! b (cons var
							     (cdr b))))
				       (loop (cdr clauses)
					     modules))))))))
		 ((atom ?module)
		  ;; module-name
		  (let ((b (assq module modules)))
		     (if b
			 (begin
			    (set-cdr! b '())
			    (loop (cdr clauses) modules))
			 (loop (cdr clauses)
			       (cons (cons (car clauses) '())
				     modules)))))
		 (else
		  (user-error "parse-import"
			      "Illegal clause"
			      (car clauses))))))))
	
;*---------------------------------------------------------------------*/
;*    parse-imported ...                                               */
;*    -------------------------------------------------------------    */
;*    This function is different from `parse-import' since this        */
;*    one parse an imported export-clause of a module rather than      */
;*    the import-clause of the current-module.                         */
;*---------------------------------------------------------------------*/
(define (parse-imported provided module)
   (let ((proto (parse-definition provided)))
      (case (car proto)
	 ((inline)
	  (global-name (declare-global-procedure! 'import
						  module
						  (car proto)
						  (cdr proto))))
	 ((procedure)
	  (declare-global-procedure! 'import
				     module
				     (car proto)
				     (cdr proto))
	  #f)
	 ((variable)
	  (declare-global-variable! 'import
				    module
				    (car proto)
				    (cdr proto))
	  #f)
	 (else
	  (user-error "parse-imported" "Illegal export clause" provided)))))

   
