;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Tools/error.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 25 10:47:51 1994                          */
;*    Last change :  Tue Feb  6 18:04:58 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Error utilities                                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_error
   (include "Tools/location.sch"
	    "Tools/trace.sch")
   (import  tools_pass
	    tools_location
	    engine_param
	    main)
   (export  *error-on-pass*
	    (internal-error        <obj> <obj> <obj>)
	    (user-warning/location <loc> <obj> <obj> <obj>)
	    (user-error            <obj> <obj> <obj> . <obj>)
	    (user-error/location   <loc> <obj> <obj> <obj> . <obj>)
	    (enter-function        <symbol>)
	    (leave-function)
	    (current-function)))

;*---------------------------------------------------------------------*/
;*    *error-on-pass* ...                                              */
;*---------------------------------------------------------------------*/
(define *error-on-pass* 0)

;*---------------------------------------------------------------------*/
;*    internal-error ...                                               */
;*---------------------------------------------------------------------*/
(define (internal-error proc mes obj)
   (trace all "*** ERROR: " proc ":" mes ":" obj #\Newline)
   (fprint (current-error-port)
	   "*** INTERNAL-ERROR in pass: " *current-pass*)
   (fprint (current-error-port)
	   "(Would you, please, send this error report and the source file to"
	   #\Newline
	   *bigloo-author* " [" *bigloo-email* "], thank you.)")
   (error proc mes obj)
   (exit-bigloo -1))

;*---------------------------------------------------------------------*/
;*    user-warning/location ...                                        */
;*---------------------------------------------------------------------*/
(define (user-warning/location loc proc mes obj)
   (if (loc? loc)
       (warning/location (loc-fname loc) (loc-pos loc) proc mes " -- " obj)
       (warning proc mes " -- " obj)))
   
;*---------------------------------------------------------------------*/
;*    user-error ...                                                   */
;*---------------------------------------------------------------------*/
(define (user-error proc mes obj . continue)
   (if (pair? continue)
       (user-error/location (find-location obj) proc mes obj
			    (car continue))
       (user-error/location (find-location obj) proc mes obj)))

;*---------------------------------------------------------------------*/
;*    user-error/location ...                                          */
;*---------------------------------------------------------------------*/
(define (user-error/location loc proc mes obj . continue)
   (trace all "*** ERROR:" proc ":" mes ":" obj #\Newline)
   (set! *error-on-pass* (+fx *error-on-pass* 1))
   (let* ((proc-string (cond
			  ((string? proc)
			   proc)
			  ((symbol? proc)
			   (symbol->string proc))
			  (else
			   #f)))
	  (fun-string  (symbol->string (current-function)))
	  (proc        (if (and (string? proc-string)
				(not (string=? proc-string fun-string)))
			   (string-append fun-string ":" proc-string)
			   fun-string)))
      (let ((obj-prn  (let ((port (open-output-string)))
			 (display obj port)
			 (let ((string (close-output-port port)))
			    (if (>fx (string-length string) 45)
				(string-append (substring string 0 44) " ...")
				string))))
	    (handler  (lambda (escape proc mes obj)
			 (notify-error proc mes obj)
			 (escape (car continue)))))
	 (if (loc? loc)
	     (if (pair? continue)
		 (try (error/location proc
				      mes
				      obj-prn
				      (loc-fname loc)
				      (loc-pos   loc))
		      handler) 
		 (error/location proc
				 mes
				 obj-prn
				 (loc-fname loc)
				 (loc-pos   loc)))
	     (if (pair? continue)
		 (try (error proc mes obj)
		      handler)
		 (error proc mes obj))))))
		 
;*---------------------------------------------------------------------*/
;*    *current-function*                                               */
;*---------------------------------------------------------------------*/
(define *current-function* '(top-level))

;*---------------------------------------------------------------------*/
;*    enter-function ...                                               */
;*---------------------------------------------------------------------*/
(define (enter-function function-name)
   (if (and (not (symbol? function-name))
	    (not (pair? function-name)))
       (internal-error "enter-function"
		       "Illegal function-name type"
		       function-name)
       (set! *current-function* (cons function-name *current-function*))))

;*---------------------------------------------------------------------*/
;*    leave-function ...                                               */
;*---------------------------------------------------------------------*/
(define (leave-function)
   (if (null? (cdr *current-function*))
       'nothing
       (set! *current-function* (cdr *current-function*))))

;*---------------------------------------------------------------------*/
;*    current-function ...                                             */
;*---------------------------------------------------------------------*/
(define (current-function)
   (car *current-function*))
	 

