/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.9/Clib/init-obj.c           */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Jul 17 09:00:08 1992                          */
/*    Last change :  Fri Mar 29 09:22:20 1996 (serrano)                */
/*                                                                     */
/*    On initialise les objects vitaux                                 */
/*---------------------------------------------------------------------*/
#include <stdio.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Les objects vitaux ...                                           */
/*---------------------------------------------------------------------*/
obj_t  an_object, a_pair;

obj_t  quote;
obj_t *c_allocated_char;
obj_t  _exit_value_;

#if defined( ALLOCATE_CONSTANT )
   obj_t nil_object, undef_object, end_of_file_object, end_of_argument_object;
   obj_t true_object, false_object;
#endif

extern obj_t string_to_obj();
extern obj_t string_to_symbol();

/*---------------------------------------------------------------------*/
/*    init_objects ...                                                 */
/*---------------------------------------------------------------------*/
init_objects()
{
   long i;
   obj_t aux;
	
   /* l'initialisation des objects speciaux */
#if defined( ALLOCATE_CONSTANT )
   aux          = GC_MALLOC_ATOMIC( sizeof( ((obj_t)0)->boolean_t ) );
   aux->header  = TRUE_TYPE;
   true_object  = BREF( aux );

   aux          = GC_MALLOC_ATOMIC( sizeof( ((obj_t)0)->boolean_t ) );
   aux->header  = FALSE_TYPE;
   false_object = BREF( aux );

   aux          = GC_MALLOC_ATOMIC( sizeof( ((obj_t)0)->header ) );
   aux->header  = NIL_TYPE;
   nil_object   = BREF( aux );

   aux          = GC_MALLOC_ATOMIC( sizeof( ((obj_t)0)->header ) );
   aux->header  = UNDEF_TYPE;
   undef_object = BREF( aux );

   aux                     = GC_MALLOC_ATOMIC( sizeof( ((obj_t)0)->header ) );
   aux->header             = EOF_TYPE;
   end_of_file__object     = BREF( aux );

   aux                     = GC_MALLOC_ATOMIC( sizeof( ((obj_t)0)->header ) );
   aux->header             = EOA_TYPE;
   end_of_argument__object = BREF( aux );
#endif
  
   /* l'initialisation des ports d'entree/sortie */
   init_io();

   /* l'initialisation des symbols */
   init_symbol_table();

   /* l'initialisation du symbol QUOTE (voir apply.c) */
   quote = string_to_symbol( "QUOTE" );
}
