/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.8/Clib/inline-alloc.c       */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Sep 21 15:33:10 1994                          */
/*    Last change :  Wed Apr 10 10:24:38 1996 (serrano)                */
/*    -------------------------------------------------------------    */
/*    On fait des fonctions d'allocations specialisees pour les cons   */
/*    et les flottants.                                                */
/*=====================================================================*/
#ifndef GC_PRIVATE_H
#  include <gc_private.h>
#endif
#undef abs

#include <bigloo.h>

#if( defined( BUMPY_GC ) && defined( BUMPY_VERBOSE ) )
extern long bumpy_nb_pair;
#endif

#if( THE_GC == BOEHM_GC )

/*---------------------------------------------------------------------*/
/*    make_pair ...                                                    */
/*---------------------------------------------------------------------*/
obj_t 
make_pair( car, cdr )
obj_t car, cdr;
{
   obj_t pair;

#if( defined( BUMPY_VERBOSE ) )
   bumpy_nb_pair++;
#endif
   
#if( defined( BUMPY_GC ) )
   BUMPY_MALLOC( PAIR_SIZE, pair );
#else
   {
#  define NUMBER_OF_CONS_WORDS (long)BYTES_TO_WORDS( PAIR_SIZE )
      ptr_t op;
      ptr_t *opp;
      DCL_LOCK_STATE;

      opp = &(GC_objfreelist[ NUMBER_OF_CONS_WORDS ]);

      FASTLOCK();

      if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
      {
	 FASTUNLOCK();
	 op = GC_generic_malloc_words_small( NUMBER_OF_CONS_WORDS, NORMAL );
      }
      else
      {
	 *opp = obj_link( op );
	 GC_words_allocd += NUMBER_OF_CONS_WORDS;
	 FASTUNLOCK();
      }

      pair = (obj_t)op;
#   undef NUMBER_OF_CONS_WORDS
   }
#endif

#if( !defined( TAG_PAIR ) || defined( BUMPY_GC ) )
   pair->pair_t.header = MAKE_HEADER( PAIR_TYPE, PAIR_SIZE );
#endif
   pair->pair_t.car    = car;
   pair->pair_t.cdr    = cdr;
	
   return BPAIR( pair );
}

/*---------------------------------------------------------------------*/
/*    make_major_pair ...                                              */
/*---------------------------------------------------------------------*/
obj_t 
make_major_pair( car, cdr )
obj_t car, cdr;
{
   obj_t pair;

   {
#  define NUMBER_OF_CONS_WORDS (long)BYTES_TO_WORDS( PAIR_SIZE )
      ptr_t op;
      ptr_t *opp;
      DCL_LOCK_STATE; 

      opp = &(GC_objfreelist[ NUMBER_OF_CONS_WORDS ]);

      FASTLOCK();

      if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
      {
	 FASTUNLOCK();
	 op = GC_generic_malloc_words_small( NUMBER_OF_CONS_WORDS, NORMAL );
      }
      else
      {
	 *opp = obj_link( op );
	 GC_words_allocd += NUMBER_OF_CONS_WORDS;
	 FASTUNLOCK();
      }
      
      pair = (obj_t)op;
#   undef NUMBER_OF_CONS_WORDS
   }
   
#if( !defined( TAG_PAIR ) || defined( BUMPY_GC ) )
   pair->pair_t.header = MAKE_HEADER( PAIR_TYPE, PAIR_SIZE );
#endif
   pair->pair_t.car    = car;
   pair->pair_t.cdr    = cdr;
	
   return BPAIR( pair );
}

/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
make_real( d )
double d;
{
   obj_t real;

#if( defined( BUMPY_GC ) )
   BUMPY_MALLOC_ATOMIC( REAL_SIZE, real );
#else
   {
#   define NUMBER_OF_FLOAT_WORDS BYTES_TO_WORDS( REAL_SIZE )
      ptr_t op;
      ptr_t *opp;
      DCL_LOCK_STATE;

      opp =  &(GC_aobjfreelist[ NUMBER_OF_FLOAT_WORDS ]);
      FASTLOCK();

      if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
      {
	 FASTUNLOCK();
	 op = GC_generic_malloc_words_small( NUMBER_OF_FLOAT_WORDS, PTRFREE );
      }
      else
      {
	 *opp = obj_link(op);
	 GC_words_allocd += NUMBER_OF_FLOAT_WORDS;
	 FASTUNLOCK();
      }

      real = (obj_t)op;
#   undef NUMBER_OF_FLOAT_WORDS
}
#endif
   
#if( !defined( TAG_REAL ) || defined( BUMPY_GC ) )
   real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
   real->real_t.real   = d;

   return BREAL( real );
}

#else

/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
make_real( real )
double real;
{
   obj_t a_real, aux;

   a_real = GC_MALLOC_ATOMIC( REAL_SIZE );
	
#if( !defined( TAG_REAL ) || defined( BUMPY_GC ) )
   a_real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
   a_real->real_t.real = real;
	
   return BREAL( a_real );
}
#endif

