;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Eval/macro.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 08:59:04 1994                          */
;*    Last change :  Mon Jul 10 14:32:15 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La manipulation des macros (de l'interprete et du compilateur).  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __macro
   
   (export  (install-eval-expander     <keyword> <expander>)
	    (install-compiler-expander <keyword> <expander>)
	    (install-expander          <keyword> <expander>)
	    (get-eval-expander         <keyword>)
	    (get-compiler-expander     <keyword>))

   (import  (__error                   "Llib/error.scm")
	    (__hash                    "Llib/hash.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__unix                    "Llib/unix.scm")
	    (__reader                  "Read/reader.scm")
	    (__rgc                     "Rgc/runtime.scm")
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__evenv                   "Eval/evenv.scm")))

;*---------------------------------------------------------------------*/
;*    macro                                                            */
;*---------------------------------------------------------------------*/
(define-struct macros key eval-expander compiler-expander)

;*---------------------------------------------------------------------*/
;*    La table de hash commune aux deux espaces de macros.             */
;*---------------------------------------------------------------------*/
(define *macro-table*
   (make-hash-table 256
		    ;; la fonction de hashage utilise un petit cache.
		    (let ((old-key #f)
			  (old-num #f))
		       (lambda (x)
			  (if (eq? x old-key)
			      old-num
			      (begin
				 (set! old-key x)
				 (set! old-num
				       (string->0..255 (symbol->string x)))
				 old-num))))
		    macros-key
		    eq?))

;*---------------------------------------------------------------------*/
;*    install-eval-expander ...                                        */
;*    -------------------------------------------------------------    */
;*    On installe une macro pour l'interprete seulement.               */
;*---------------------------------------------------------------------*/
(define (install-eval-expander keyword expander)
   (cond
      ((not (symbol? keyword))
       (error "install-eval-expander" "Illegal expander keyword" keyword))
      ((not (procedure? expander))
       (error "install-eval-expander" "Illegal expander expander" expander))
      (else
       (let ((macro (get-hash keyword *macro-table*)))
	  (if (not (macros? macro))
	      (begin
		 (set! macro (macros keyword #f #f))
		 (put-hash! macro *macro-table*)))
	  ;; on warn si la macro etait deja definie sous l'interprete
	  (if (macros-eval-expander macro)
	      (warning "install-eval-expander"
		       "Redefinition of expander -- "
		       keyword))
	  (macros-eval-expander-set! macro expander)))))

;*---------------------------------------------------------------------*/
;*    install-compiler-expander ...                                    */
;*    -------------------------------------------------------------    */
;*    On installe une macro pour le compilateur seulement.             */
;*---------------------------------------------------------------------*/
(define (install-compiler-expander keyword expander)
   (cond
      ((not (symbol? keyword))
       (error "install-eval-expander" "Illegal expander keyword" keyword))
      ((not (procedure? expander))
       (error "install-eval-expander" "Illegal expander expander" expander))
      (else
       (let ((macro (get-hash keyword *macro-table*)))
	  (if (not (macros? macro))
	      (begin
		 (set! macro (macros keyword #f #f))
		 (put-hash! macro *macro-table*)))
	  ;; on warn si la macro etait deja definie sous le compilo
	  (if (macros-compiler-expander macro)
	      (warning "install-compiler-expander"
		       "Redefinition of expander -- "
		       keyword))
	  (macros-compiler-expander-set! macro expander)))))

;*---------------------------------------------------------------------*/
;*    install-expander ...                                             */
;*    -------------------------------------------------------------    */
;*    On installe une macro pour le compilateur *et* l'interprete.     */
;*---------------------------------------------------------------------*/
(define (install-expander keyword expander)
   (cond
      ((not (symbol? keyword))
       (error "install-eval-expander" "Illegal expander keyword" keyword))
      ((not (procedure? expander))
       (error "install-eval-expander" "Illegal expander expander" expander))
      (else
       (let ((macro (get-hash keyword *macro-table*)))
	  (if (not (macros? macro))
	      (begin
		 (set! macro (macros keyword #f #f))
		 (put-hash! macro *macro-table*)))
	  ;; on warn si la macro etait deja definie sous l'interprete
	  (if (macros-eval-expander macro)
	      (warning "install-eval-expander"
		       "Redefinition of expander -- "
		       keyword))
	  ;; on warn si la macro etait deja definie sous le compilo
	  (if (macros-compiler-expander macro)
	      (warning "install-compiler-expander"
		       "Redefinition of expander -- "
		       keyword))
	  ;; on affecte
	  (macros-eval-expander-set! macro expander)
	  (macros-compiler-expander-set! macro expander)))))

;*---------------------------------------------------------------------*/
;*    get-eval-expander ...                                            */
;*    -------------------------------------------------------------    */
;*    On recupere une macro pour l'interprete.                         */
;*---------------------------------------------------------------------*/
(define (get-eval-expander keyword)
   (let ((macro (get-hash keyword *macro-table*)))
      (if (not (macros? macro))
	  #f
	  (macros-eval-expander macro))))

;*---------------------------------------------------------------------*/
;*    get-compiler-expander ...                                        */
;*    -------------------------------------------------------------    */
;*    On recupere une macro pour le compilateur.                       */
;*---------------------------------------------------------------------*/
(define (get-compiler-expander keyword)
   (let ((macro (get-hash keyword *macro-table*)))
      (if (not (macros? macro))
	  #f
	  (macros-compiler-expander macro))))



