/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgCombineSeq.c                                               */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:33 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "CombineSeq"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *image;
  int done_one,seq_start,seq_incr,seq_count,finished,count;

  IFHELP
    {
      fprintf(stderr,"img%s - Combine images from seq files to make a sequence\n",
	      PRGNAME);
      fprintf(stderr,"img%s basename [start [incr [count]]]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: None\n");
      fprintf(stderr,"  stdout: Any\n");
      fprintf(stderr,"  file: Any\n");
      exit(0);
    }
  imgStart(PRGNAME);

  seq_start= -1;
  seq_incr=1;
  seq_count=999;

  if(argc<2 || argc>5)
    ERROR("illegal arguments");
  if(argc>2)
    seq_start=atoi(argv[2]);
  if(argc>3)
    seq_incr=atoi(argv[3]);
  if(argc>4)
    seq_count=atoi(argv[4]);
  
  if(seq_start<0)
    seq_count=1;

  finished=0;
  count=0;
  done_one=0;
  while(!finished)
    {
      if((image=i_load_image(argv[1],seq_start,IT_ANY,IM_FRAGMENT))!=NULL)
	{
	  i_write_image_file(stdout,image,IF_BINARY);
	  done_one=1;
	  i_destroy_image(image);
	  if(++count>=seq_count)
	    finished=1;
	  seq_start+=seq_incr;
	}
      else
	finished=1;
    }
  if(!done_one)
    ERROR("no images loaded");

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
