/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgNot.c                                                      */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:50 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Not"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *i1,*i2;
  int width,height,x,y,val;

  IFHELP
    {
      fprintf(stderr,"img%s - Perform logical NOT operation\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: pbm\n");
      fprintf(stderr,"  stdout: pbm\n");
      exit(0);
    }

  imgStart(PRGNAME);

  do {
    i1=i_read_image_file(stdin,IT_BIT,IM_FRAGMENT);
    if(i1==NULL)
      ERROR("can't import image file");
    width=i1->width;
    height=i1->height;

    i2=i_create_image(width,height,IT_BIT,IM_FRAGMENT);
    if(i2==NULL)
      ERROR("out of memory");

    for(y=0;y<height;y++)
	for(x=0;x<width;x++)
	  {
	    val=!im_get_bit_value(i1,x,y);
	    im_put_bit_value(i2,x,y,val);
	  }

    i_destroy_image(i1);
    i_write_image_file(stdout,i2,IF_BINARY);
    i_destroy_image(i2);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
