Boolean: trait
  % This trait is given for documentation only.
  % It is implicit in LSL.
  introduces
    true, false: -> Bool
    ~__: Bool -> Bool
    __/\ __, __\/__, __=>__: Bool, Bool -> Bool
  asserts
    Bool generated by true, false
    \forall b: Bool
      ~ true == false;
      ~ false == true;
      true /\ b == b;
      false /\ b == false;
      true \/ b == true;
      false \/ b == b;
      true => b == b;
      false => b == true
  implies
    AC (/\ , Bool),
    AC (\/, Bool),
    Distributive (\/ for +, /\ for *, Bool for T),
    Distributive (/\ for +, \/ for *, Bool for T),
    Involutive (~__, Bool),
    Transitive (=> for \rel, Bool for T)
    \forall b1, b2, b3: Bool
      ~(b1 /\ b2) == ~b1 \/ ~b2;
      ~(b1 \/ b2) == ~b1 /\ ~b2;
      b1 \/ (b1 /\ b2) == b1;
      b1 /\ (b1 \/ b2) == b1;
      b2 \/ ~b2;
      (b1 = b2) \/ (b1 = b3) \/ (b2 = b3);
      b1 => b2 == ~b1 \/ b2
