/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef ABSTRACT_H
# define ABSTRACT_H

/*
**  These two are needed in symtable.c
*/

/*@constant int HT_MAXINDEX; @*/
# define HT_MAXINDEX 255 

/* simply use the lower-order bits by masking out the higher order bits */

# include "ltoken.h"
# include "ltokenList.h" 

/*
** forward declarations for structures
*/

struct _lclTypeSpecNode; 
struct _opFormNode;
struct _strOrUnionNode;
struct _stmtNode;
struct _lclPredicateNode;
struct _typeExpr;
struct _declaratorNode;
struct _abstBodyNode;
struct _functionTermNode;
struct _quantifiedTermNode;
struct _sigNode;
struct _termNode;
struct _nameNode;
struct _importNode;
struct _pairNode;

extern lsymbol capBoolSymbol;
extern lsymbol boolSymbol;
extern lsymbol TRUESymbol;
extern lsymbol FALSESymbol;

typedef enum 
{
  TAG_ENUM, TAG_STRUCT, TAG_UNION, TAG_FWDSTRUCT, TAG_FWDUNION
  } tagKind;

# include "importNode.h"
# include "importNodeList.h" 

extern void checkBrackets (ltoken l, ltoken r);

# include "sortList.h"
# include "lsymbolList.h"

# include "lsymbolSet.h"
# include "sortSet.h"

/*
** added pointer indirects to all typedefs, except as noted
** evs 94-01-05
*/

# include "pairNode.h"
# include "pairNodeList.h"

# include "declaratorInvNode.h"
# include "declaratorInvNodeList.h"

# include "typeExpr.h"  /* also defines abstDeclaratorNode */

# include "declaratorNode.h"
# include "declaratorNodeList.h"

# include "arrayQualNode.h"

# include "varNode.h"
# include "varNodeList.h"

# include "quantifierNode.h"
# include "quantifierNodeList.h"

# include "storeRefNode.h"
# include "storeRefNodeList.h"

# include "modifyNode.h"

# include "letDeclNode.h"
# include "letDeclNodeList.h"

# include "programNode.h"
# include "programNodeList.h"

# include "lclPredicateNode.h"
# include "exposedNode.h"

typedef enum {
  TK_ABSTRACT, TK_EXPOSED, TK_UNION
  } typeKind ;

# include "CTypesNode.h"

# include "initDeclNode.h"
# include "initDeclNodeList.h"

# include "constDeclarationNode.h"

typedef enum {
  QLF_NONE, QLF_CONST, QLF_VOLATILE
  } qualifierKind;

# include "varDeclarationNode.h"
# include "varDeclarationNodeList.h"

# include "globalList.h"

# include "claimNode.h"

# include "fcnNode.h"
# include "fcnNodeList.h"

# include "iterNode.h"

# include "abstBodyNode.h"
# include "abstractNode.h"

# include "stDeclNode.h"
# include "stDeclNodeList.h"

# include "taggedUnionNode.h"
# include "typeNode.h"

# include "strOrUnionNode.h"
# include "enumSpecNode.h"

# include "qualList.h"

# include "lclTypeSpecNode.h"
# include "typeNamePack.h"

# include "typeNameNode.h"
# include "typeNameNodeList.h"              /* this is a list of typeNameNode's */

# include "opFormNode.h"

# include "quantifiedTermNode.h"

typedef enum {
  TRM_LITERAL, TRM_CONST, TRM_VAR, 
  TRM_ZEROARY, TRM_APPLICATION, TRM_QUANTIFIER,
  TRM_UNCHANGEDALL, TRM_UNCHANGEDOTHERS, 
  TRM_SIZEOF
  } termKIND;

# include "sigNode.h"
# include "sigNodeSet.h"

# include "signNode.h"
# include "nameNode.h"

# include "lslOp.h"
# include "lslOpSet.h"

# include "replaceNode.h"
# include "replaceNodeList.h"

# include "renamingNode.h"

# include "traitRefNode.h"
# include "traitRefNodeList.h"

# include "exportNode.h"
# include "privateNode.h"

# include "interfaceNode.h"
# include "interfaceNodeList.h" /* note: interfaceList --> interfaceNodeList */

# include "termNode.h"
# include "termNodeList.h"
# include "stmtNode.h"

/* The following are for parsing LSL signatures */

# include "sortSetList.h"
# include "lslOpList.h"

/* function prototypes for parsing LSL signatures */

extern /*@only@*/ lslOp
  makelslOpNode (/*@only@*/ /*@null@*/ nameNode name,
		 /*@dependent@*/ sigNode s);

extern /*@only@*/ cstring lslOp_unparse (lslOp x);

/*@notfunction@*/
# define MASH(x,y) \
  (/*@+enumint@*/ ((((x)+1)<<1) + (y)) & HT_MAXINDEX /*@=enumint@*/) 

extern void abstract_init (void);
extern void resetImports (cstring currentSpec);

extern interfaceNodeList 
  consInterfaceNode (/*@only@*/ interfaceNode n, /*@returned@*/ interfaceNodeList ns);

/* evs 8 Sept 1993       changed to importNodeList */
extern /*@only@*/ interfaceNode 
  makeInterfaceNodeImports (/*@only@*/ importNodeList x);

extern /*@only@*/ nameNode 
  makeNameNodeForm (/*@only@*/ /*@null@*/ opFormNode opform) /*@*/ ;
extern /*@only@*/ nameNode
  makeNameNodeId (/*@only@*/ ltoken opid) /*@*/ ;
extern /*@only@*/ interfaceNode 
  makeInterfaceNodeUses (/*@only@*/ traitRefNodeList x) /*@*/ ;
extern /*@only@*/ interfaceNode 
  interfaceNode_makeConst (/*@only@*/ constDeclarationNode x) /*@*/ ;
extern /*@only@*/ interfaceNode 
  interfaceNode_makeVar (/*@only@*/ varDeclarationNode x) /*@*/ ;
extern /*@only@*/ interfaceNode 
  interfaceNode_makeType (/*@only@*/ typeNode x) /*@*/ ;
extern /*@only@*/ interfaceNode 
  interfaceNode_makeFcn (/*@only@*/ fcnNode x) /*@*/ ;
extern /*@only@*/ interfaceNode 
  interfaceNode_makeClaim (/*@only@*/ claimNode x) /*@*/ ;
extern /*@only@*/ interfaceNode interfaceNode_makeIter (/*@only@*/ iterNode x) /*@*/ ;
extern /*@only@*/ interfaceNode interfaceNode_makePrivConst(/*@only@*/ constDeclarationNode x) /*@*/ ;
extern /*@only@*/ interfaceNode 
  interfaceNode_makePrivVar(/*@only@*/ varDeclarationNode x) /*@*/ ;
extern /*@only@*/ interfaceNode 
  interfaceNode_makePrivType(/*@only@*/ typeNode x) /*@*/ ;
extern /*@only@*/ interfaceNode 
  interfaceNode_makePrivFcn(/*@only@*/ fcnNode x) /*@*/ ;
extern /*@only@*/ typeNode makeAbstractTypeNode (/*@only@*/ abstractNode x) /*@*/ ;
extern /*@only@*/ typeNode makeExposedTypeNode (/*@only@*/ exposedNode x) /*@*/ ;

extern /*@only@*/ traitRefNode 
  makeTraitRefNode(/*@only@*/ ltokenList fl, /*@null@*/ /*@only@*/ renamingNode r) /*@*/ ;

extern /*@only@*/ cstring printLeaves2 (ltokenList f) /*@*/ ;
extern /*@only@*/ cstring printRawLeaves2 (ltokenList f) /*@*/ ;
extern /*@only@*/ cstring sigNode_unparseText (/*@null@*/ sigNode n) /*@*/ ;

extern /*@only@*/ renamingNode 
  makeRenamingNode (/*@only@*/ typeNameNodeList n, 
		    /*@only@*/ replaceNodeList r) /*@*/ ; 
extern /*@only@*/ replaceNode 
  makeReplaceNode (/*@only@*/ ltoken t, /*@only@*/ typeNameNode tn, bool is_ctype, 
		   /*@only@*/ ltoken cctype, 
		   /*@null@*/ /*@only@*/ nameNode nn, 
		   /*@null@*/ /*@only@*/ sigNode sn) /*@*/ ;

extern /*@only@*/ sigNode 
  makesigNode (/*@only@*/ ltoken t, /*@only@*/ ltokenList domain, /*@only@*/ ltoken range) /*@*/ ;

extern /*@only@*/ replaceNode 
  makeReplaceNameNode (/*@only@*/ ltoken t, /*@only@*/ typeNameNode tn, 
		       /*@only@*/ nameNode nn) /*@*/ ;

extern /*@only@*/ opFormNode 
  makeOpFormNode(/*@only@*/ ltoken t, opFormKind k, 
		 opFormUnion u, /*@only@*/ ltoken close) /*@*/ ;

extern /*@only@*/ typeNameNode 
  makeTypeNameNode (bool isObj, /*@only@*/ lclTypeSpecNode t, 
		    /*@only@*/ abstDeclaratorNode n) /*@*/ ;
extern /*@only@*/ typeNameNode 
  makeTypeNameNodeOp (/*@only@*/ opFormNode n) /*@*/ ;

extern /*@only@*/ lclTypeSpecNode 
  makeLclTypeSpecNodeConj (/*@only@*/ /*@null@*/ lclTypeSpecNode a, 
			   /*@only@*/ /*@null@*/ lclTypeSpecNode b) /*@*/ ;

extern /*@only@*/ lclTypeSpecNode
  makeLclTypeSpecNodeType(/*@only@*/ /*@null@*/ CTypesNode x) /*@*/ ;

extern /*@only@*/ lclTypeSpecNode 
  makeLclTypeSpecNodeSU(/*@only@*/ /*@null@*/ strOrUnionNode x) /*@*/ ;

extern /*@only@*/ lclTypeSpecNode 
  makeLclTypeSpecNodeEnum(/*@only@*/ /*@null@*/ enumSpecNode x) /*@*/ ;

extern /*@only@*/ lclTypeSpecNode 
  lclTypeSpecNode_addQual (/*@only@*/ lclTypeSpecNode n, qual q) 
  /*@modifies n@*/ ;

extern /*@only@*/ enumSpecNode 
  makeEnumSpecNode (/*@only@*/ ltoken t, /*@only@*/ ltoken optTagId, /*@owned@*/ ltokenList enums);

extern /*@only@*/ enumSpecNode 
  makeEnumSpecNode2 (/*@only@*/ ltoken t, /*@only@*/ ltoken tagid);

extern /*@only@*/ strOrUnionNode 
  makestrOrUnionNode (/*@only@*/ ltoken str, suKind k,
			 /*@only@*/ ltoken opttagid, /*@only@*/ stDeclNodeList x);

extern /*@only@*/ strOrUnionNode 
  makeForwardstrOrUnionNode (/*@only@*/ ltoken str, suKind k, 
				/*@only@*/ ltoken tagid);

extern /*@only@*/ stDeclNode 
  makestDeclNode (/*@only@*/ lclTypeSpecNode s, 
		  /*@only@*/ declaratorNodeList x);
extern /*@only@*/ constDeclarationNode 
  makeConstDeclarationNode (/*@only@*/ lclTypeSpecNode t,
			    /*@only@*/ initDeclNodeList x);
extern /*@only@*/ varDeclarationNode 
  makeVarDeclarationNode (/*@only@*/ lclTypeSpecNode t, 
			  /*@only@*/ initDeclNodeList x, 
			  bool isGlobal, bool isPrivate);

extern varDeclarationNode makeFileSystemNode (void);
extern varDeclarationNode makeInternalStateNode (void);

extern /*@only@*/ initDeclNode 
  makeInitDeclNode (/*@only@*/ declaratorNode d, /*@null@*/ /*@only@*/ termNode x);

extern /*@only@*/ abstractNode 
  makeAbstractNode (/*@only@*/ ltoken t, /*@only@*/ ltoken name,
		    bool isMutable, bool isRefCounted,
		    /*@only@*/ abstBodyNode a);

extern /*@unused@*/ /*@only@*/ cstring abstBodyNode_unparseExposed (abstBodyNode n);

extern /*@only@*/ exposedNode 
  makeExposedNode (/*@only@*/ ltoken t, /*@only@*/ lclTypeSpecNode s, 
		   /*@only@*/ declaratorInvNodeList d);

extern /*@only@*/ declaratorInvNode 
  makeDeclaratorInvNode (/*@only@*/ declaratorNode d, 
			 /*@only@*/ abstBodyNode b);

extern /*@only@*/ fcnNode
  fcnNode_fromDeclarator (/*@only@*/ /*@null@*/ lclTypeSpecNode t, 
			  /*@only@*/ declaratorNode d);

extern /*@only@*/ fcnNode
  makeFcnNode (qual specQual,
	       /*@only@*/ /*@null@*/ lclTypeSpecNode t, 
	       /*@only@*/ declaratorNode d,
	       /*@only@*/ /*@null@*/ globalList g, 
	       /*@only@*/ /*@null@*/ varDeclarationNodeList privateinits,
	       /*@only@*/ /*@null@*/ letDeclNodeList lets,
	       /*@only@*/ /*@null@*/ lclPredicateNode checks,
	       /*@only@*/ /*@null@*/ lclPredicateNode requires, 
	       /*@only@*/ /*@null@*/ modifyNode m,
	       /*@only@*/ /*@null@*/ lclPredicateNode ensures, 
	       /*@only@*/ /*@null@*/ lclPredicateNode claims);

extern /*@only@*/ iterNode 
  makeIterNode (/*@only@*/ ltoken id, /*@only@*/ paramNodeList p);

extern /*@only@*/ claimNode 
  makeClaimNode (/*@only@*/ ltoken id, 
		 /*@only@*/ paramNodeList p, 
		 /*@only@*/ /*@null@*/ globalList g, 
		 /*@only@*/ /*@null@*/ letDeclNodeList lets, 
		 /*@only@*/ /*@null@*/ lclPredicateNode requires, 
		 /*@only@*/ /*@null@*/ programNode b, 
		 /*@only@*/ /*@null@*/ lclPredicateNode ensures);

extern /*@only@*/ lclPredicateNode 
  makeIntraClaimNode (/*@only@*/ ltoken t, /*@only@*/ lclPredicateNode n);

extern /*@only@*/ lclPredicateNode 
  makeRequiresNode (/*@only@*/ ltoken t, /*@only@*/ lclPredicateNode n);

extern /*@only@*/ lclPredicateNode 
  makeChecksNode (/*@only@*/ ltoken t, /*@only@*/ lclPredicateNode n);

extern /*@only@*/ lclPredicateNode 
  makeEnsuresNode (/*@only@*/ ltoken t, /*@only@*/ lclPredicateNode n);

extern /*@only@*/ lclPredicateNode 
  makeLclPredicateNode (/*@only@*/ ltoken t, /*@only@*/ termNode x, 
			lclPredicateKind k);

extern /*@only@*/ stmtNode
  makeStmtNode (/*@only@*/ ltoken varId, 
		/*@only@*/ ltoken fcnId, /*@only@*/ termNodeList v);

extern /*@only@*/ programNode 
  makeProgramNodeAction (/*@only@*/ programNodeList x, actionKind k);

extern /*@only@*/ programNode 
  makeProgramNode (/*@only@*/ stmtNode x);

extern /*@only@*/ storeRefNode 
  makeStoreRefNodeTerm (/*@only@*/ termNode t);

extern /*@only@*/ storeRefNode 
  makeStoreRefNodeType (/*@only@*/ lclTypeSpecNode t, bool isObj);

extern /*@only@*/ modifyNode 
  makeModifyNodeSpecial (/*@only@*/ ltoken t, bool modifiesNothing);

extern storeRefNode makeStoreRefNodeInternal (void);
extern storeRefNode makeStoreRefNodeSystem (void);

extern /*@only@*/ modifyNode 
  makeModifyNodeRef (/*@only@*/ ltoken t, /*@only@*/ storeRefNodeList y);

extern /*@only@*/ letDeclNode 
  makeLetDeclNode(/*@only@*/ ltoken varid, /*@null@*/ /*@only@*/ lclTypeSpecNode t, 
		  /*@only@*/ termNode term);

extern /*@only@*/ abstBodyNode 
  makeAbstBodyNode (/*@only@*/ ltoken t, /*@only@*/ fcnNodeList f);

extern /*@only@*/ abstBodyNode 
  makeExposedBodyNode (/*@only@*/ ltoken t, /*@only@*/ lclPredicateNode inv);

extern /*@only@*/ abstBodyNode 
  makeAbstBodyNode2 (/*@only@*/ ltoken t, /*@only@*/ ltokenList ops); 

extern paramNode markYieldParamNode (/*@returned@*/ paramNode p);

extern /*@only@*/ arrayQualNode 
  makeArrayQualNode (/*@only@*/ ltoken t, /*@null@*/ /*@only@*/ termNode term);

extern /*@only@*/ quantifierNode 
  makeQuantifierNode (/*@only@*/ varNodeList v, /*@only@*/ ltoken quant);

extern /*@only@*/ varNode 
  makeVarNode (/*@only@*/ ltoken varid, bool isObj, /*@only@*/ lclTypeSpecNode t);

extern /*@only@*/ typeExpr makeTypeExpr (/*@only@*/ ltoken t);

extern /*@only@*/ declaratorNode 
  makeDeclaratorNode (/*@only@*/ typeExpr t);

extern /*@only@*/ typeExpr 
  makeFunctionNode (/*@null@*/ /*@only@*/ typeExpr x, /*@only@*/ paramNodeList p);

extern /*@only@*/ typeExpr
  makePointerNode (/*@only@*/ ltoken star, /*@null@*/ /*@only@*/ /*@returned@*/ typeExpr x);

extern /*@only@*/ typeExpr 
  makeArrayNode (/*@only@*/ /*@returned@*/ /*@null@*/ typeExpr x, 
		 /*@only@*/ arrayQualNode a);

extern /*@only@*/ paramNode 
  makeParamNode (/*@only@*/ lclTypeSpecNode t, /*@only@*/ typeExpr d);

extern /*@only@*/ termNode 
  makeIfTermNode (/*@only@*/ ltoken ift, /*@only@*/ termNode ifn, 
		  /*@only@*/ ltoken thent, /*@only@*/ termNode thenn, 
		  /*@only@*/ ltoken elset, /*@only@*/ termNode elsen);

extern /*@only@*/ termNode 
  makeQuantifiedTermNode (/*@only@*/ quantifierNodeList q, 
			  /*@only@*/ ltoken open, 
			  /*@only@*/ termNode t, /*@only@*/ ltoken close);

extern /*@only@*/ termNode 
  makeInfixTermNode (/*@only@*/ termNode x, /*@only@*/ ltoken op, 
		     /*@only@*/ termNode y);

extern /*@only@*/ termNode 
  makePostfixTermNode (/*@returned@*/ /*@only@*/ termNode secondary,
		       /*@only@*/ ltokenList postfixops);

extern /*@only@*/ termNode 
  makePostfixTermNode2 (/*@only@*/ /*@returned@*/ termNode secondary, 
			/*@only@*/ ltoken postfixop);

extern /*@only@*/ termNode 
  makePrefixTermNode (/*@only@*/ ltoken op, /*@only@*/ termNode arg);

extern /*@exposed@*/ termNode 
  CollapseInfixTermNode (/*@returned@*/ termNode secondary, termNodeList infix);

extern /*@only@*/ termNode 
  makeMatchedNode (/*@only@*/ ltoken open, 
		   /*@only@*/ termNodeList args, /*@only@*/ ltoken close);

extern /*@only@*/ termNode 
  makeSqBracketedNode (/*@only@*/ ltoken lbracket, 
		       /*@only@*/ termNodeList args, 
		       /*@only@*/ ltoken close);

extern /*@only@*/ termNode
  updateSqBracketedNode (/*@null@*/ /*@only@*/ termNode left,
			 /*@only@*/ /*@returned@*/ termNode t,
			 /*@null@*/ /*@only@*/ termNode right);

extern termNode 
  updateMatchedNode (/*@null@*/ /*@only@*/ termNode left, /*@returned@*/ termNode t, 
		     /*@null@*/ /*@only@*/ termNode right);

extern /*@only@*/ termNode 
  makeSimpleTermNode (/*@only@*/ ltoken varid);
extern /*@only@*/ termNode 
  makeSelectTermNode (/*@only@*/ termNode pri, /*@only@*/ ltoken select,
		      /*@dependent@*/ ltoken id);
extern /*@only@*/ termNode 
  makeMapTermNode (/*@only@*/ termNode pri, /*@only@*/ ltoken map, 
		   /*@dependent@*/ ltoken id);
extern /*@only@*/ termNode 
  makeLiteralTermNode (/*@only@*/ ltoken tok, sort s); 

extern /*@only@*/ termNode 
  makeUnchangedTermNode1 (/*@only@*/ ltoken op, /*@only@*/ ltoken all); 
extern /*@only@*/ termNode 
  makeUnchangedTermNode2 (/*@only@*/ ltoken op, /*@only@*/ storeRefNodeList x); 
extern /*@only@*/ termNode 
  makeSizeofTermNode(/*@only@*/ ltoken op, /*@only@*/ lclTypeSpecNode type);
extern /*@only@*/ termNode 
  makeOpCallTermNode (/*@only@*/ ltoken op, /*@only@*/ ltoken open, 
		      /*@only@*/ termNodeList args, /*@only@*/ ltoken close);

extern sort sigNode_rangeSort (sigNode sig);

extern /*@only@*/ sortList sigNode_domain (sigNode op);

extern bool sameNameNode (/*@null@*/ nameNode n1, /*@null@*/ nameNode n2);

extern /*@only@*/ CTypesNode 
  makeCTypesNode (/*@null@*/ /*@only@*/ CTypesNode ctypes, /*@only@*/ ltoken cctype);

extern /*@only@*/ CTypesNode 
  makeTypeSpecifier (/*@only@*/ ltoken cctype);

extern bool sigNode_equal (sigNode n1, sigNode n2);

extern sort lclTypeSpecNode2sort(lclTypeSpecNode type);

extern sort typeExpr2ptrSort(sort base, /*@null@*/ typeExpr t);

/* should be tagKind, instead of int */
extern lsymbol checkAndEnterTag(tagKind k, /*@only@*/ ltoken opttagid);
extern void enteringFcnScope(lclTypeSpecNode t, declaratorNode d, globalList g);
extern void enteringClaimScope(/*@only@*/ ltoken claimId, paramNodeList params, globalList g);

extern /*@observer@*/ ltoken nameNode_errorToken (/*@null@*/ nameNode nn);
extern /*@observer@*/ ltoken termNode_errorToken (/*@null@*/ termNode t);
extern /*@observer@*/ ltoken lclTypeSpecNode_errorToken (/*@null@*/ lclTypeSpecNode t);

extern opFormUnion opFormUnion_createAnyOp (ltoken t); 
extern opFormUnion opFormUnion_createMiddle (int middle); 
extern void LCLBuiltins (void);
extern /*@only@*/ paramNode paramNode_elipsis (void);
extern termNodeList 
  pushInfixOpPartNode (/*@returned@*/ termNodeList x, /*@only@*/ ltoken op,
		       /*@only@*/ termNode secondary);
extern /*@only@*/ cstring declaratorNode_unparseCode (declaratorNode x);

extern /*@only@*/ cstring typeExpr_name (/*@null@*/ typeExpr x);

extern void setExposedType (lclTypeSpecNode s);
extern void declareForwardType (declaratorNode declare);

extern /*@only@*/ declaratorNode declaratorNode_copy (declaratorNode x);

extern bool lslOp_equal (lslOp x, lslOp y);

# else
# error "Multiple include"
# endif
