/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef enumNameLIST_H
# define enumNameLIST_H

typedef cstring enumName ;

extern /*@only@*/ enumName enumName_create (/*@only@*/ cstring s) /*@*/ ;

# define enumName_create(s)  (s)

typedef /*@only@*/ enumName o_enumName;

abst_typedef struct _enumNameList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_enumName  *elements;
} *enumNameList ;

/*@iter enumNameList_elements (sef enumNameList x, yield exposed enumName el); @*/
# define enumNameList_elements(x, m_el) \
   { int m_ind; enumName *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { enumName m_el = *(m_elements++); 

# define end_enumNameList_elements }}

extern int enumNameList_size (enumNameList);

# define enumNameList_size(s) ((s)->nelements)   

extern /*@only@*/ enumNameList enumNameList_new(void);
extern bool enumNameList_member (enumNameList s, cstring m);
extern enumNameList enumNameList_push (/*@returned@*/ enumNameList s, /*@only@*/ enumName el);
extern void enumNameList_addh (enumNameList s, /*@keep@*/ enumName el) 
     /*@modifies s@*/;

extern /*@only@*/ cstring enumNameList_unparse (enumNameList s) /*@*/ ;
extern void enumNameList_free (/*@only@*/ enumNameList s) ;

extern bool enumNameList_match (enumNameList e1, enumNameList e2) /*@*/ ;
extern /*@only@*/ enumNameList enumNameList_single (/*@keep@*/ enumName a) /*@*/ ;
extern /*@only@*/ enumNameList enumNameList_subtract (enumNameList e1, enumNameList e2) /*@*/ ;
extern /*@only@*/ enumNameList enumNameList_copy (enumNameList al) /*@*/ ;
extern /*@only@*/ enumNameList enumNameList_undump(char **s);
extern /*@only@*/ cstring enumNameList_dump(enumNameList al);
extern /*@only@*/ cstring enumNameList_unparseBrief (enumNameList s);

/*@constant int enumNameListBASESIZE;@*/
# define enumNameListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




