/*
** guardSet.h
*/

# ifndef GUARDSET_H
# define GUARDSET_H

/*
** guardSet is usually empty, so allow NULL to represent this.
*/

/* in forwardTypes: typedef struct _guardSet *guardSet; */

/*@null@*/ struct _guardSet
{
  /*@only@*/ sRefSet tguard; /* guarded on true branch */
  /*@only@*/ sRefSet fguard; /* guarded on false branch */
} ;

/*@constant null guardSet guardSet_undefined;@*/
# define guardSet_undefined     ((guardSet)NULL)

extern /*@falsenull@*/ /*@unused@*/ bool 
  guardSet_isDefined (guardSet g) /*@*/ ;
# define guardSet_isDefined(g)  ((g) != guardSet_undefined)

extern /*@falsenull@*/ bool guardSet_isEmpty (guardSet g);

extern /*@only@*/ guardSet guardSet_new (void);
extern guardSet guardSet_addTrueGuard (/*@returned@*/ guardSet g, sRef s);
extern guardSet guardSet_addFalseGuard (/*@returned@*/ guardSet g, sRef s);
extern guardSet guardSet_or (/*@returned@*/ /*@unique@*/ guardSet s, guardSet t);
extern guardSet guardSet_and (/*@returned@*/ /*@unique@*/ guardSet s, guardSet t);
extern void guardSet_delete (guardSet g, sRef s) /*@modifies g@*/ ;
extern /*@only@*/ cstring guardSet_unparse (guardSet g);
extern void guardSet_free (/*@only@*/ /*@only@*/ guardSet g);
extern /*@dependent@*/ /*@exposed@*/ sRefSet 
  guardSet_getTrueGuards (guardSet g) /*@*/ ;
extern /*@dependent@*/ /*@exposed@*/ sRefSet
  guardSet_getFalseGuards (guardSet g) /*@*/ ;
extern guardSet guardSet_union (/*@only@*/ guardSet s, guardSet t) 
   /*@modifies s@*/ ;
extern /*@only@*/ guardSet guardSet_invert (/*@temp@*/ guardSet g) /*@*/ ;
extern /*@only@*/ guardSet guardSet_copy (/*@temp@*/ guardSet g) /*@*/ ;
extern bool guardSet_isGuarded (guardSet g, sRef s) /*@*/ ;
extern bool guardSet_isProbableNull (guardSet g, sRef s) /*@*/ ;

extern guardSet
  guardSet_levelUnion (/*@only@*/ guardSet s, 
		       guardSet t, int lexlevel)
  /*@modifies s@*/ ;
extern guardSet
  guardSet_levelUnionFree (/*@returned@*/ /*@unique@*/ guardSet s, 
			   /*@only@*/ guardSet t, int lexlevel)
  /*@modifies t, s@*/ ;

extern void guardSet_flip (guardSet g);

# else
# error "Multiple include"
# endif
