/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef idDeclLIST_H
# define idDeclLIST_H

typedef /*@only@*/ idDecl o_idDecl;

abst_typedef struct _idDeclList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_idDecl  *elements;
} *idDeclList ;

/*@iter idDeclList_elements (sef idDeclList x, yield exposed idDecl el); @*/
# define idDeclList_elements(x, m_el) \
   { int m_ind; idDecl *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { idDecl m_el = *(m_elements++); 

# define end_idDeclList_elements }}

extern /*@only@*/ idDeclList idDeclList_singleton (/*@only@*/ idDecl e) ;
extern idDeclList idDeclList_add (/*@returned@*/ idDeclList s, /*@only@*/ idDecl el) ; 

extern /*@unused@*/ /*@only@*/ cstring idDeclList_unparse (idDeclList s) ;
extern void idDeclList_free (/*@only@*/ idDeclList s) ;

/*@constant int idDeclListBASESIZE;@*/
# define idDeclListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




