/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** usymtab.h
*/

# ifndef USYMTAB_H
# define USYMTAB_H

/*@constant null usymtab GLOBAL_ENV; @*/ 
# define GLOBAL_ENV usymtab_undefined

typedef enum { 
  US_GLOBAL, 
  US_NORMAL, 
  US_TBRANCH, US_FBRANCH, 
  US_CBRANCH, US_SWITCH
} uskind;

typedef struct _refentry { int level; int index; } *refentry;
typedef /*@only@*/ refentry o_refentry;
typedef o_refentry *refTable;

struct _usymtab
{
  uskind   kind;
  int      nentries;
  int      nspace;
  int      lexlevel;
  bool     mustBreak;
  exitkind exitCode;
  /*@reldef@*/ /*@only@*/ o_uentry  *entries;
  /*@null@*/ /*@only@*/ hashTable htable;   /* for the global environment */
  /*@null@*/ /*@only@*/ refTable  reftable; /* for branched environments */
             /*@only@*/ guardSet  guards;   /* guarded references (not null) */
  aliasTable aliases;
  /*@owned@*/ usymtab env;
} ; 

/*
** rep invariant:
**
** (left as exercise to reader)  ;) 
*/

extern void usymtab_printTypes (void) 
  /*@globals internalState@*/
  /*@modifies stderr@*/ ;

extern void usymtab_setMustBreak (void) /*@modifies internalState@*/ ;

extern bool usymtab_inGlobalScope (void) /*@globals internalState@*/ ;
extern bool usymtab_inFunctionScope (void) /*@globals internalState@*/ ;
extern bool usymtab_inFileScope (void) /*@globals internalState@*/ ;
extern void usymtab_checkFinalScope (bool isReturn) 
  /*@globals internalState@*/ 
  /*@modifies *stderr@*/ ;

extern void usymtab_allUsed (void)
   /*@globals internalState@*/ 
   /*@modifies *stderr@*/ ;

extern void usymtab_allDefined (void)
   /*@globals internalState@*/
   /*@modifies *stderr@*/ ;

extern void usymtab_prepareDump (void)
   /*@modifies internalState@*/ ;

extern void usymtab_dump (FILE *fout)
   /*@globals internalState@*/
   /*@modifies *fout@*/ ;


extern void usymtab_load (FILE *f) /*@modifies f, internalState@*/ ;

extern /*@exposed@*/ /*@dependent@*/ uentry 
  usymtab_getRefQuiet (int level, usymId index)
  /*@globals internalState@*/ ;

extern void usymtab_printLocal (void) 
  /*@globals internalState@*/ 
  /*@modifies stdout@*/ ;

extern /*@exposed@*/ /*@dependent@*/ uentry usymtab_getParam (int paramno)
   /*@globals internalState@*/;
extern void usymtab_free (void) /*@modifies internalState@*/ ;
extern bool usymtab_inDeepScope (void) /*@globals internalState@*/ ;

extern /*@exposed@*/  uentry usymtab_lookupExpose (cstring k)
   /*@globals internalState@*/ ;
extern /*@observer@*/ uentry usymtab_lookup (cstring k)
   /*@globals internalState@*/ ;
# define usymtab_lookup(s) (usymtab_lookupExpose (s))

extern /*@observer@*/ uentry usymtab_lookupGlob (cstring k)
   /*@globals internalState@*/ ;
extern /*@exposed@*/ uentry usymtab_lookupExposeGlob (cstring k)
   /*@globals internalState@*/ ;
extern /*@observer@*/ uentry usymtab_lookupUnionTag (cstring k)
   /*@globals internalState@*/ ;
extern /*@observer@*/ uentry usymtab_lookupStructTag (cstring k)
   /*@globals internalState@*/ ;
extern /*@observer@*/ uentry usymtab_lookupEither (cstring k)
   /*@globals internalState@*/ ;

extern ctype usymtab_lookupType (cstring k)
   /*@globals internalState@*/ ;
extern bool usymtab_isProbableNull (sRef s)
   /*@globals internalState@*/ ;
extern bool usymtab_isProbableDeepNull (sRef s)
   /*@globals internalState@*/ ;

extern usymId usymtab_supExposedTypeEntry (/*@only@*/ uentry e, bool dodef)
   /*@modifies internalState, e@*/ ;

extern ctype usymtab_supTypeEntry (/*@only@*/ uentry e)
   /*@modifies internalState, e@*/ ;

extern /*@exposed@*/ uentry usymtab_supReturnTypeEntry (/*@only@*/ uentry e)
   /*@modifies internalState@*/ ;

extern /*@observer@*/ uentry usymtab_lookupSafe (cstring k)
   /*@globals internalState@*/ ;

extern /*@observer@*/ uentry usymtab_getGlobalEntry (usymId uid)
  /*@globals internalState@*/ ;

extern bool usymtab_exists (cstring k)
   /*@globals internalState@*/ ;

extern bool usymtab_existsVar (cstring k)
   /*@globals internalState@*/ ;

extern bool usymtab_existsGlob (cstring k)
   /*@globals internalState@*/ ;

extern bool usymtab_existsType (cstring k)
   /*@globals internalState@*/ ;

extern bool usymtab_existsEither (cstring k)
   /*@globals internalState@*/ ;

extern bool usymtab_existsTypeEither (cstring k)
   /*@globals internalState@*/ ;

extern usymId usymtab_getId (cstring k) /*@globals internalState@*/ ;
extern usymId usymtab_getTypeId (cstring k) /*@globals internalState@*/ ;

extern void usymtab_supEntry (/*@only@*/ uentry e)
  /*@modifies internalState, e@*/ ;

extern void usymtab_replaceEntry (/*@only@*/ uentry e)
  /*@modifies internalState, e@*/ ;

extern void usymtab_supEntrySref (/*@only@*/ uentry e)
  /*@modifies internalState, e@*/ ;

extern void usymtab_supGlobalEntry (/*@only@*/ uentry e)
  /*@modifies internalState@*/ ;

extern void usymtab_addGlobalEntry (/*@only@*/ uentry e) 
  /*@modifies internalState, e@*/ ;

extern /*@exposed@*/ uentry 
  usymtab_supEntryReturn (/*@only@*/ uentry e)
  /*@modifies internalState, e@*/ ;

extern usymId usymtab_addEntry (/*@only@*/ uentry e)
  /*@modifies internalState, e@*/ ;

extern ctype usymtab_lookupAbstractType (cstring k) 
  /*@globals internalState@*/ ;
extern bool usymtab_matchForwardStruct (usymId uid1, usymId uid2)
  /*@globals internalState@*/ ;

extern bool usymtab_existsEnumTag (cstring k)
  /*@globals internalState@*/ ;
extern bool usymtab_existsUnionTag (cstring k) 
  /*@globals internalState@*/ ;
extern bool usymtab_existsStructTag (cstring k) 
  /*@globals internalState@*/ ;

extern usymId usymId_fromInt (int i) /*@*/ ;
# define usymId_fromInt(i)   ((usymId)(i))

extern int usymId_toInt (usymId u) /*@*/ ;
# define usymId_toInt(u)     ((int)(u))

extern bool usymId_isInvalid (usymId u) /*@*/ ;
# define usymId_isInvalid(u) ((u) == USYMIDINVALID)

extern bool usymId_isValid (usymId u) /*@*/ ;
# define usymId_isValid(u)   ((u) != USYMIDINVALID)

extern bool typeId_isInvalid (typeId u) /*@*/ ;
# define typeId_isInvalid(u) ((u) == typeId_invalid)

extern bool typeId_isValid (typeId u) /*@*/ ;
# define typeId_isValid(u)   ((u) != typeId_invalid)

extern bool typeId_equal (typeId u1, typeId u2) /*@*/ ;
# define typeId_equal(u1,u2) ((u1) == (u2))

extern typeId typeId_fromInt (int i);
# define typeId_fromInt(i)   ((typeId)(i))

/*@iter usymtab_entries (sef usymtab u, yield exposed uentry el); @*/
# define usymtab_entries(x, m_i)   \
    { int m_ind; \
      if (usymtab_isDefined (x)) \
        for (m_ind = 0; m_ind < (x)->nentries; m_ind++) \
	   { uentry m_i = (x)->entries[m_ind]; 

# define end_usymtab_entries }}

extern /*@unused@*/ void usymtab_displayAllUses (void)
   /*@globals internalState@*/ 
   /*@modifies *stderr@*/ ;

extern /*@unused@*/ void usymtab_printOut (void)
   /*@globals internalState@*/ 
   /*@modifies *stderr@*/ ;

extern /*@unused@*/ void usymtab_printAll (void)
   /*@globals internalState@*/ 
   /*@modifies *stderr@*/ ;

extern void usymtab_enterScope (void) 
  /*@modifies internalState;@*/ ;
extern void usymtab_enterFunctionScope (uentry f) 
  /*@modifies internalState;@*/ ;
extern void usymtab_quietExitScope (fileloc loc)
  /*@modifies internalState;@*/ ;
extern void usymtab_exitScope (exprNode expr) /*@modifies internalState@*/ ;
extern void usymtab_addGuards (guardSet guards) /*@modifies internalState@*/ ;
extern void usymtab_setExitCode (exitkind ex) /*@modifies internalState@*/ ;
extern void usymtab_exitFile (void) /*@modifies internalState@*/ ;
extern void usymtab_enterFile (void) /*@modifies internalState@*/ ;

extern /*@observer@*/ uentry usymtab_lookupEnumTag (cstring k)
  /*@globals internalState@*/ ; 

extern usymId usymtab_convertId (usymId uid) /*@globals internalState@*/ ;
extern void usymtab_initMod (void) /*@modifies internalState@*/ ;
extern void usymtab_initBool (void) /*@modifies internalState@*/ ;

extern void usymtab_exportHeader (void)
   /*@modifies internalState@*/ ;

extern ctype usymtab_structFieldsType (uentryList f)
   /*@globals internalState@*/ ;

extern ctype usymtab_unionFieldsType (uentryList f)
   /*@globals internalState@*/ ;

extern ctype usymtab_enumEnumNameListType (enumNameList f)
   /*@globals internalState@*/ ;

extern /*@exposed@*/ uentry usymtab_getTypeEntrySafe (usymId uid)
   /*@globals internalState@*/ ;

extern void usymtab_popOrBranch (exprNode pred, exprNode expr)
  /*@modifies internalState@*/ ;
extern void usymtab_popAndBranch (exprNode pred, exprNode expr)
  /*@modifies internalState@*/ ;

extern void usymtab_trueBranch (/*@only@*/ guardSet guards)
  /*@modifies internalState@*/ ;
extern void usymtab_altBranch (/*@only@*/ guardSet guards)
  /*@modifies internalState@*/ ;

extern void usymtab_popTrueBranch (exprNode pred, exprNode expr, clause cl)
  /*@modifies internalState@*/ ;
extern void
  usymtab_popTrueExecBranch (exprNode pred, exprNode expr, clause cl)
  /*@modifies internalState@*/ ;

extern void 
  usymtab_popBranches (exprNode pred, exprNode tbranch, exprNode fbranch, 
		       bool isOpt, clause cl)
   /*@modifies internalState@*/ ;

extern void usymtab_unguard (sRef s) /*@modifies internalState@*/ ;
extern bool usymtab_isGuarded (sRef s) /*@globals internalState@*/ ;
extern void usymtab_printGuards (void) /*@globals internalState@*/ ;
extern void usymtab_quietPlainExitScope (void) /*@modifies internalState@*/ ;
extern void usymtab_printComplete (void) /*@globals internalState@*/ ;
extern bool usymtab_existsGlobEither (cstring k) /*@globals internalState@*/ ;
extern bool usymtab_isBoolType (usymId uid) /*@globals internalState@*/ ;
extern /*@only@*/ cstring 
  usymtab_getTypeEntryName (usymId uid)
  /*@globals internalState@*/ ;
extern /*@exposed@*/ uentry usymtab_getTypeEntry (usymId uid)
  /*@globals internalState@*/ ;

extern usymId 
  usymtab_supAbstractTypeEntry (/*@only@*/ uentry e, bool dodef)
  /*@modifies internalState, e@*/ ;
extern ctype usymtab_supForwardTypeEntry (/*@only@*/ uentry e)
  /*@modifies internalState, e@*/ ;

extern /*@exposed@*/ uentry 
  usymtab_supGlobalEntryReturn (/*@only@*/ uentry e)
  /*@modifies internalState, e@*/ ;

extern /*@exposed@*/ uentry 
  usymtab_supEntrySrefReturn (/*@only@*/ uentry e)
  /*@modifies internalState, e@*/ ;

extern int uentry_directParamNo (uentry ue)
  /*@globals internalState@*/ ;

extern bool usymtab_newCase (exprNode pred, exprNode last)
  /*@modifies internalState@*/ ;

extern void usymtab_switchBranch (exprNode s) 
  /*@modifies internalState@*/ ;

extern /*@only@*/ cstring usymtab_unparseStack (void)
  /*@globals internalState@*/ ;
extern void usymtab_exitSwitch (exprNode sw, bool allpaths)
  /*@modifies internalState@*/ ;

extern /*@observer@*/ uentry usymtab_lookupGlobSafe (cstring k)
  /*@globals internalState@*/ ;

extern /*@only@*/ sRefSet usymtab_aliasedBy (sRef s)
  /*@globals internalState@*/ ;

extern /*@only@*/ sRefSet usymtab_canAlias (sRef s)
  /*@globals internalState@*/ ;

extern void usymtab_clearAlias (sRef s)
  /*@modifies internalState, s@*/ ;

extern void usymtab_addMustAlias (sRef s, sRef al)
  /*@modifies internalState@*/ ;

extern /*@only@*/ cstring usymtab_unparseAliases (void)
  /*@globals internalState@*/ ;

extern /*@exposed@*/ uentry
  usymtab_supReturnFileEntry (/*@only@*/ uentry e)
   /*@modifies internalState@*/ ;

extern bool usymtab_isAltProbablyDeepNull (sRef s)
   /*@globals internalState@*/ ;

extern bool usymtab_existsReal (cstring k)
   /*@globals internalState@*/ ;

extern /*@only@*/ sRefSet usymtab_allAliases (sRef s)
   /*@globals internalState@*/ ;

extern void usymtab_exportLocal (void)
   /*@modifies internalState@*/ ;

/* special scopes */

/*@constant int globScope;@*/
# define globScope 0  /* global variables */

/*@constant int fileScope;@*/
# define fileScope   1  /* file-level static variables */

/*@constant int paramsScope;@*/
# define paramsScope 2  /* function parameters */

/*@constant int functionScope;@*/
# define functionScope 3

extern /*@falsenull@*/ bool usymtab_isDefined (usymtab u) /*@*/ ;

/*@constant null usymtab usymtab_undefined; @*/
# define usymtab_undefined ((usymtab)NULL)
# define usymtab_isDefined(u) ((u) != usymtab_undefined)

extern void usymtab_checkDistinctName (uentry e, int scope)
  /*@globals internalState@*/
  /*@modifies *stderr, e@*/ ;

# else
# error "Multiple include"
# endif



