/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

# include "lclintMacros.nf"
# include "basic.h"

fileloc currentloc;
symtable symtab;

cstring codeFile = cstring_undefined;
int codeLine = 0;

cstring prevCodeFile = cstring_undefined;
int prevCodeLine = 0;

/*
** These were in llmain.c.  Most should not be globals...
*/

/*@only@*/ cstring localIncludePath = cstring_undefined;
/*@only@*/ cstring includePath = cstring_undefined;
/*@observer@*/ char *localSpecPath = ".";
/*@only@*/ cstring currentSpec;
/*@only@*/ char *currentSpecName;
/*@only@*/ lsymbolSet currentImports = lsymbolSet_undefined;

void printCodePoint (void)
{
  if (cstring_isDefined (codeFile))
    {
      fprintf (stderr, "*** Last code point: %s:%d\n", 
	       cstring_toCharsSafe (codeFile), codeLine);
      
      if (cstring_isDefined (prevCodeFile))
	{
	  fprintf (stderr, "*** Previous code point: %s:%d\n", 
		   cstring_toCharsSafe (prevCodeFile), prevCodeLine);
	}
    }
}




