/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** traitRefNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ traitRefNodeList
traitRefNodeList_new ()
{
  traitRefNodeList s = (traitRefNodeList) dmalloc (sizeof (*s));

  s->nelements = 0;
  s->nspace = traitRefNodeListBASESIZE;
  s->elements = (traitRefNode *)
    dmalloc (sizeof (*s->elements) * traitRefNodeListBASESIZE);

  return (s);
}

static void
traitRefNodeList_grow (traitRefNodeList s)
{
  int i;
  traitRefNode *newelements; 

  s->nspace = traitRefNodeListBASESIZE + s->nspace;
  newelements = (traitRefNode *) dmalloc (sizeof (*newelements)
					  * (s->nelements + traitRefNodeListBASESIZE));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i]; 
    }

  sfree (s->elements);
  s->elements = newelements;
}

traitRefNodeList
traitRefNodeList_add (traitRefNodeList s, /*@only@*/ traitRefNode el)
{
  if (s->nspace <= 0)
    traitRefNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

/*@only@*/ cstring
traitRefNodeList_unparse (traitRefNodeList s)
{
  cstring st = cstring_undefined;

  traitRefNodeList_elements (s, current)
  {
    st = message ("%quses (%q)", st, printLeaves2 (current->traitid));

    if (current->rename != 0)
      {
	st = message ("%q (%q)", st, renamingNode_unparse (current->rename));
      }

    st = message ("%q\n", st);
  } end_traitRefNodeList_elements;

  return (st);
}

void
traitRefNodeList_free (traitRefNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      traitRefNode_free (s->elements[i]); 
    }

  sfree (s->elements); 
  sfree (s);
}
