(***********************************************************************)
(*                                                                     *)
(*                           Calves                                    *)
(*                                                                     *)
(*          Francois Rouaix, projet Cristal, INRIA Rocquencourt        *)
(*                                                                     *)
(*  Copyright 1996 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

open Viewers

type applet_callback = Widget.widget -> context -> unit

(* The "foreign" module fake cache *)
type t = {
  module_address : string;		(* the URL of the bytecode *)
  module_info : string list;		(* headers *)
  module_functions : (string, applet_callback) Hashtbl.t
  } 

val get : Url.t -> t option
val remove : Url.t -> unit
val iter : (Url.t -> t option -> unit) -> unit

val register : string -> applet_callback -> unit
val add_pending_applet :
  Url.t -> ((string, applet_callback) Hashtbl.t -> unit) -> bool
(* returns true if this is the first applet for this bytecode *)

val load: Document.document -> string -> Capabilities.browser_private -> unit

val load_local : string -> unit

val paranoid : bool ref
