(* Specify set of attributes of a font *)
(* family, weight, slant, pxlsz *)
(* We use a font string, and select only the relevant components *)
(* 
-fndry-fmly-wght-slant-sWdth-adstyl-pxlsz-ptSz-resx-resy-spc-avgWdth-reg-enc
   0    1    2    3     4      5     6     7    8    9   10    11     12  13
*)
open Fonts

let fontspec2attrs s =
  let tokens = Mstring.split_str (fun c -> c='-') s in
  if List.length tokens <> 14 then
    failwith ("incomplete font specification: " ^ s)
  else (* should not fail *)
    let attrs = ref [] in
      (match List.nth tokens 1 
       with "*" -> () | s -> attrs := (Family s) :: !attrs);
      (match List.nth tokens 2 
       with "*" -> () | s -> attrs := (Weight s) :: !attrs);
      (match List.nth tokens 3 
       with "*" -> () | s -> attrs := (Slant s) :: !attrs);
      (match List.nth tokens 6 with
         "*" -> () 
	| s -> try
	         attrs := (FontIndex (font_index (int_of_string s))) :: !attrs
	       with Failure "int_of_string" ->
		 failwith ("pxlsz not an integer: " ^ s));
      !attrs

let attrs2fontspec l =
  let rec family = function
     [] -> "*"
   | (Family s)::_ -> s
   | x::l -> family l
  and weight = function
     [] -> "*"
   | (Weight s)::_ -> s
   | x::l -> weight l
  and slant = function
     [] -> "*"
   | (Slant s)::_ -> s
   | x::l -> slant l
  and pxlsz = function
     [] -> "*"
   | (FontIndex s)::_ -> string_of_int (Fonts.pxlsz s)
   | x::l -> pxlsz l in

  "-*-"^family l^"-"^weight l^"-"^slant l^"-normal-*-"^ pxlsz l^
   "-*-*-*-*-*-iso8859-1"
