@echo OFF
rem $Id: build.bat,v 4.1 1996/03/15 18:01:49 mikes Exp $
rem ------------------------------------------------------------------------
rem 
rem             T H E    P I N E    M A I L   S Y S T E M
rem 
rem   Mike Seibel
rem   Networks and Distributed Computing
rem   Computing and Communications
rem   University of Washington
rem   Administration Builiding, AG-44
rem   Seattle, Washington, 98195, USA
rem   Internet: lgl@CAC.Washington.EDU
rem             mikes@CAC.Washington.EDU
rem  
rem   Please address all bugs and comments to "pine-bugs@cac.washington.edu"
rem  
rem  
rem   Pine and Pico are registered trademarks of the University of Washington.
rem   No commercial use of these trademarks may be made without prior written
rem   permission of the University of Washington.
rem  
rem   Pine, Pico, and Pilot software and its included text are Copyright
rem   1989-1996 by the University of Washington.
rem  
rem   The full text of our legal notices is contained in the file called
rem   CPYRIGHT, included with this distribution.
rem 
rem 
rem 
rem ------------------------------------------------------------------------

if "%1"=="" goto blank
if "%1"=="wnt" goto wnt
if "%1"=="win" goto win
if "%1"=="lwp" goto lwp
if "%1"=="wattcp" goto wattcp
if "%1"=="pctcp" goto pctcp
if "%1"=="pcnfs" goto pcnfs
if "%1"=="clean" goto clean
echo Unknown build command: %1 %2 %3 %4
goto usage
:blank
echo Must specify build command!
:usage
echo usage: BUILD cmd
echo   where "cmd" is one of either:
echo         LWP        -- generate Novell LWP compatible version
echo         PCTCP      -- generate FTP Inc. PC/TCP compatible version
echo         PCNFS      -- generate Sun PC-NFS compatible version
echo         WATTCP     -- generate WATTCP (packet driver) compatible version
echo         WIN        -- generate Winsock compatible version (Win16)
echo         WNT        -- generate Winsock compatible version (Win32)
echo         CLEAN      -- to remove obj, lib, and exe files from source
goto fini

:wnt
echo PC-Pine for Windows/Winsock (Win32) build sequence
set cclntos=wsk
set pineos=wnt
set cclntmake=makefile.wnt
set picomake=makefile.wnt
set pinemake=makefile.wnt
set extracflags=
goto build

:win
echo PC-Pine for Windows/Winsock (Win16) build sequence
set cclntos=wsk
set pineos=wsk
set cclntmake=makefile.dos
set picomake=makefile.win
set pinemake=makefile.win
set extracflags="-Zi -GA -Gt2 -Gy"
goto build

:lwp
echo PC-Pine for Novell LWP stack build sequence
set cclntos=dnv
set pineos=lwp
set cclntmake=makefile.dos
set picomake=makefile.msc
set pinemake=makefile.msc
set extracflags="-Zi -GA -Gt2 -Gy"
goto build

:wattcp
echo PC-Pine for WATTCP stack build sequence
set cclntos=dwa
set pineos=wattcp
set cclntmake=makefile.dos
set picomake=makefile.msc
set pinemake=makefile.msc
set extracflags="-Zi -GA -Gt2 -Gy"
goto build

:pctcp
echo PC-Pine for FTP Inc. PC/TCP stack build sequence
set cclntos=dpc
set pineos=pctcp
set cclntmake=makefile.dos
set picomake=makefile.msc
set pinemake=makefile.msc
set extracflags="-Zi -GA -Gt2 -Gy"
goto build

:pcnfs
echo PC-Pine for Sun PC-NFS stack build sequence
set cclntos=dnf
set pineos=pcnfs
set cclntmake=makefile.dos
set picomake=makefile.msc
set pinemake=makefile.msc
set extracflags="-Zi -GA -Gt2 -Gy"
goto build

:clean
echo Sure you want to delete object, library and executable files?!?!
echo If NOT, type Ctrl-C to terminate build script NOW.  Type ENTER if you do.
pause
echo Cleaning pine, pico and c-client directories
set cleandir=c-client
:blast
cd %cleandir%
echo Cleaning %cleandir%...
del *.obj
del *.lib
del *.bak
del *.map
del *.exe
del osdep.h
del osdep.c
del os.h
del os.c
cd ..
if "%cleandir%"=="c-client" goto cleanpico
if "%cleandir%"=="pico" goto cleanpine
echo Directories cleaned up.
set cleandir=
goto fini
:cleanpico
set cleandir=pico
goto blast
:cleanpine
set cleandir=pine
goto blast

:build
echo Building c-client...
cd c-client
nmake -nologo -f %cclntmake% OS=%cclntos% EXTRACFLAGS=%extracflags%
if errorlevel 1 goto bogus
echo Building pico...
cd ..\pico
nmake -nologo -f %picomake% %pineos%=1
if errorlevel 1 goto bogus
echo Building pine...
cd ..\pine
nmake -nologo -f %pinemake% %pineos%=1
if errorlevel 1 goto bogus
cd ..
echo Pine build complete.
goto fini

:bogus
echo Problems building pine!

:fini
