C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

      SUBROUTINE F4(xd,time,x,u) 
      IMPLICIT NONE
      DOUBLE PRECISION xd(12), time, x(12), u(4)


C Coefficients physiques
      DOUBLE PRECISION T, rho, Mach, rho0, g, k, R, T0, gamma, pcin

      PARAMETER(rho0=1.2247D0, g=9.81D0, k=0.0065D0, R=287.053 D0, T0=288.15D0, gamma=1.4D0)


C Coefficients geometriques et massiques
      DOUBLE PRECISION S, a, b, m,Ixx,Iyy,Izz,Ixz

      PARAMETER(S=48.91D0, a=4.89D0, b=11.7D0)
      PARAMETER(m=17870.D0, Ixx=34108.D0, Iyy=183033.D0, Izz=207586.D0, Ixz=3411.D0)


C Coefficients aerodynamiques. (cf dossier aerodynamique)
      DOUBLE PRECISION Cx0, Cz0, Cz0p, Cza, Czda, Czq, Czm, Cm0, Cma, Cmda, Cmq, Cmm,
     % Cyb, Cyr, Cyn, Cnb, Cll, Cnn, Cnl, Cyp1, Cyp2, Cyp, Clb1, Clb2, Clb,
     % Clp1, Clp2, Clp, Clr1, Clr2, Clr, Cln1, Cln2, Cln, Cnp1, Cnp2, Cnp, 
     % Cnr1, Cnr2, Cnr

      DOUBLE PRECISION Mach_sat, dM, breaks(11), alpha_deg

      INTEGER i, index(31)

      DOUBLE PRECISION tab_Cx0(4,11), tab_Cz0p(4,11), tab_Cza(4,11), tab_Czda(4,11),  
     % tab_Czq(4,11), tab_Czm(4,11), tab_Cma(4,11), tab_Cmda(4,11),  
     % tab_Cmq(4,11), tab_Cmm(4,11), tab_Cyb(4,11), tab_Cyr(4,11),  
     % tab_Cyn(4,11), tab_Cnb(4,11), tab_Cll(4,11), tab_Cnn(4,11),  
     % tab_Cnl(4,11), tab_Cyp1(4,11), tab_Cyp2(4,11), tab_Clb1(4,11), 
     % tab_Clb2(4,11), tab_Clp1(4,11), tab_Clp2(4,11), tab_Clr1(4,11), 
     % tab_Clr2(4,11), tab_Cln1(4,11), tab_Cln2(4,11), tab_Cnp1(4,11), 
     % tab_Cnp2(4,11), tab_Cnr1(4,11), tab_Cnr2(4,11)

C Variables forces et moments
      DOUBLE PRECISION Cx, Cy, Czstar, Cz, Cl, Cm, Cn, fX, fY, fZ, fZstar,mL,mM,mN
      DOUBLE PRECISION C5, S5, C6, S6, T6, C7, S7, T7, C8, S8, C9, S9
      DOUBLE PRECISION corL, corM, corN, det

      DATA breaks /0. D0, 0.2 D0, 0.4 D0, 0.6 D0, 0.8 D0, 0.9 D0, 1. D0, 1.2 D0, 1.4 D0, 1.6 D0, 2./

      DATA index /1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 10, 
     % 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11/

      DATA tab_Cx0 / 
     % -0.02727785481696 D0,  0.01286671289018 D0, -0.00008222838536 D0,  0.01735000000000 D0,
     % -0.02727785481696 D0, -0.00350000000000 D0,  0.00179111419268 D0,  0.01763000000000 D0,
     %  0.17138927408480 D0, -0.01986671289018 D0, -0.00288222838536 D0,  0.01763000000000 D0,
     % -0.53702924152225 D0,  0.08296685156071 D0,  0.00973779934875 D0,  0.01763000000000 D0,
     %  6.64440383449039 D0, -0.23925069335265 D0, -0.02151896900964 D0,  0.01860000000000 D0,
     %-10.33700530539903 D0,  1.75407045699447 D0,  0.12996300735454 D0,  0.02070000000000 D0,
     %  2.69348218333952 D0, -1.34703113462524 D0,  0.17066693959147 D0,  0.04090000000000 D0,
     % -0.49709957044522 D0,  0.26905817537847 D0, -0.04492765225789 D0,  0.04270000000000 D0,
     %  0.05741609844136 D0, -0.02920156688866 D0,  0.00304366944008 D0,  0.04050000000000 D0,
     % -0.00220132105025 D0,  0.00524809217616 D0, -0.00174702550242 D0,  0.04040000000000 D0,
     % -0.00220132105025 D0,  0.00260650691586 D0,  0.00139481413438 D0,  0.04040000000000 D0/

      DATA tab_Cz0p / 
     % -0.11100595601041 D0,  0.05285357360624 D0, -0.00063047648083 D0, -0.10110000000000 D0,
     % -0.11100595601041 D0, -0.01375000000000 D0,  0.00719023824042 D0, -0.10000000000000 D0,
     %  0.69252978005203 D0, -0.08035357360624 D0, -0.01163047648083 D0, -0.10000000000000 D0,
     % -0.15911316419772 D0,  0.33516429442498 D0,  0.03933166768291 D0, -0.10000000000000 D0,
     %  2.17265546601886 D0,  0.23969639590634 D0,  0.15430380574918 D0, -0.08000000000000 D0,
     % -5.65720524822116 D0,  0.89149303571200 D0,  0.26742274891101 D0, -0.06000000000000 D0,
     %  0.87821272860231 D0, -0.80566853875435 D0,  0.27600519860678 D0, -0.03000000000000 D0,
     % -0.08437825546809 D0, -0.27874090159296 D0,  0.05912331053732 D0,                 0 D0,
     %  0.70930029327005 D0, -0.32936785487381 D0, -0.06249844075604 D0,                 0 D0,
     % -0.02722113076329 D0,  0.09621232108821 D0, -0.10912954751316 D0, -0.02000000000000 D0,
     % -0.02722113076329 D0,  0.06354696417226 D0, -0.04522583340897 D0, -0.05000000000000 D0/
  
C Pas de tableau pour Cz0, qui est constant

      DATA tab_Cza / 
     % -2.18506997638370 D0,  1.82979198583023 D0, -0.00005559811070 D0,  3.03300000000000 D0,
     % -2.18506997638370 D0,  0.51875000000001 D0,  0.46965279905535 D0,  3.08870000000000 D0,
     %  9.71284988191838 D0, -0.79229198583021 D0,  0.41494440188931 D0,  3.18590000000000 D0,
     %-13.55382955128981 D0,  5.03541794332082 D0,  1.26356959338743 D0,  3.31490000000000 D0,
     % 32.84107541843301 D0, -3.09687978745308 D0,  1.65127722456098 D0,  3.66060000000000 D0,   
     %-97.06778134310333 D0,  6.75544283807684 D0,  2.01713352962335 D0,  3.82760000000000 D0,
     % 44.36974140063025 D0,-22.36489156485415 D0,  0.45618865694562 D0,  3.99980000000000 D0,
     % -3.71229135460975 D0,  4.25695327552400 D0, -3.16539900092041 D0,  3.55140000000000 D0,
     % -1.95807598219124 D0,  2.02957846275816 D0, -1.90809265326398 D0,  3.05890000000000 D0,
     % -0.18070477096063 D0,  0.85473287344342 D0, -1.33123038602367 D0,  2.74280000000000 D0,
     % -0.18070477096063 D0,  0.63788714829066 D0, -0.73418237733003 D0,  2.33550000000000 D0/

      DATA tab_Czda / 
     % -5.53869030816962 D0,  2.70196418490177 D0,  0.02565477534643 D0,  3.05990000000000 D0,
     % -5.53869030816962 D0, -0.62125000000000 D0,  0.44179761232679 D0,  3.12880000000000 D0,
     % 27.99345154084805 D0, -3.94446418490177 D0, -0.47134522465357 D0,  3.14800000000000 D0,
     %-115.0101158552224 D0, 12.85160673960705 D0,  1.31008328628749 D0,  3.11990000000000 D0,
     % 1183.193419784902 D0,-56.15446277352638 D0, -7.35048792049638 D0,  2.97590000000000 D0,
     %-1881.077843453979 D0, 298.8035631619440 D0, 16.91442211834539 D0,  2.86250000000000 D0,
     %  533.166463193376 D0, -265.519789874249 D0, 20.24279944711485 D0,  5.66090000000000 D0,
     %-39.87191722438440 D0, 54.38008804177602 D0,-21.98514091937983 D0,  3.35400000000000 D0,
     %-48.56629429583811 D0, 30.45693770714536 D0, -5.01773576959555 D0,  0.81320000000000 D0,
     % -0.85749031011883 D0,  1.31716112964248 D0,  1.33708399776202 D0,  0.63940000000000 D0,
     % -0.85749031011884 D0,  0.28817275749988 D0,  1.97921755261897 D0,  1.33010000000000 D0/

      DATA tab_Czq / 
     %  4.33217307628270 D0, -0.90055384576962 D0,  0.02082384610261 D0,  4.29120000000000 D0,
     %  4.33217307628270 D0,  1.69875000000000 D0,  0.18046307694869 D0,  4.29400000000000 D0,
     %-31.47336538141352 D0,  4.29805384576963 D0,  1.37982384610262 D0,  4.43270000000000 D0,
     % 78.42378844937123 D0,-14.58596538307848 D0, -0.67775846135915 D0,  4.62880000000000 D0,
     % -135.454076798844 D0, 32.46830768654429 D0,  2.89870999933401 D0,  4.53720000000000 D0,
     %-93.39576973666736 D0, -8.16791535310881 D0,  5.32874923267756 D0,  5.01630000000000 D0, 
     %  100.638404621651 D0,-36.18664627410899 D0,  0.89329306995578 D0,  5.37410000000000 D0,
     %-92.56306036716268 D0, 24.19639649888133 D0, -1.50475688508976 D0,  4.91040000000000 D0, 
     % 77.47633684700013 D0,-31.34143972141626 D0, -2.93376552959675 D0,  4.83680000000000 D0,
     % -6.15039973868944 D0, 15.14436238678386 D0, -6.17318099652323 D0,  3.61620000000000 D0,
     % -6.15039973868945 D0,  7.76388270035653 D0,  2.99011703833292 D0,  3.17640000000000 D0/

      DATA tab_Czm / 
     % -0.64746793440708 D0,  0.47473076064425 D0, -0.00554743475257 D0,  0.40300000000000 D0,
     % -0.64746793440708 D0,  0.08625000000000 D0,  0.10664871737628 D0,  0.41570000000000 D0, 
     %  2.78733967203542 D0, -0.30223076064425 D0,  0.06345256524743 D0,  0.43530000000000 D0,
     % -6.38939075373459 D0,  1.37017304257700 D0,  0.27704102163398 D0,  0.45820000000000 D0, 
     % 10.99627927497420 D0, -2.46346140966375 D0,  0.05838334821663 D0,  0.51730000000000 D0,
     % -5.81216818159583 D0,  0.83542237282851 D0, -0.10442055546689 D0,  0.50950000000000 D0,
     %  0.34616856697782 D0, -0.90822808165024 D0, -0.11170112634906 D0,  0.50160000000000 D0,
     %  2.97643798161333 D0, -0.70052694146355 D0, -0.43345213097182 D0,  0.44570000000000 D0,
     % -1.88942049343115 D0,  1.08533584750445 D0, -0.35649034976364 D0,  0.35480000000000 D0,
     %  0.04789405872061 D0, -0.04831644855424 D0, -0.14908646997360 D0,  0.31180000000000 D0,
     %  0.04789405872061 D0,  0.00915642191049 D0, -0.16475048063110 D0,  0.24750000000000 D0/

C Pas de tableau pour Cm0 D0, qui est constant

      DATA tab_Cma / 
     %  2.08729390715664 D0, -1.65487634429398 D0, -0.00701648742747 D0, -0.11850000000000 D0,
     %  2.08729390715664 D0, -0.40250000000000 D0, -0.41849175628627 D0, -0.16940000000000 D0,
     % -0.52396953578317 D0,  0.84987634429398 D0, -0.32901648742747 D0, -0.25250000000000 D0,
     % -8.70391576402395 D0,  0.53549462282408 D0, -0.05194229400386 D0, -0.28850000000000 D0,
     % 15.58998201161304 D0, -4.68685483559030 D0, -0.88221433655710 D0, -0.34710000000000 D0,
     % 15.78718665374069 D0, -0.00986023210637 D0, -1.35188584332677 D0, -0.46660000000000 D0,
     % -7.00042156668357 D0,  4.72629576401583 D0, -0.88024229013582 D0, -0.58610000000000 D0,
     % -3.43584980674045 D0,  0.52604282400569 D0,  0.17022542746848 D0, -0.62910000000000 D0,
     %  3.95632079364537 D0, -1.53546706003858 D0, -0.03165941973810 D0, -0.60150000000000 D0,
     % -0.37182761214607 D0,  0.83832541614864 D0, -0.17108774851609 D0, -0.63760000000000 D0,
     % -0.37182761214607 D0,  0.39213228157336 D0,  0.32109533057271 D0, -0.59570000000000 D0/

      DATA tab_Cmda / 
     % -0.79012671312772 D0, -0.20467397212338 D0, -0.00096013705022 D0, -2.32530000000000 D0,
     % -0.79012671312771 D0, -0.67875000000001 D0, -0.17764493147489 D0, -2.34000000000000 D0,
     %  9.11313356563872 D0, -1.15282602787664 D0, -0.54396013705022 D0, -2.40900000000000 D0,
     %-43.28740754942714 D0,  4.31505411150659 D0,  0.08848547967577 D0, -2.49100000000000 D0,
     % 45.57208234678181 D0,-21.65739041814969 D0, -3.37998178165285 D0, -2.64700000000000 D0,
     % 204.2873966290849 D0, -7.98576571411514 D0, -6.34429739487934 D0, -3.15600000000000 D0,
     %-107.3065504023061 D0, 53.30045327461034 D0, -1.81282863882982 D0, -3.66600000000000 D0,
     % 19.65321926542694 D0,-11.08347696677331 D0,  6.63056662273758 D0, -2.75500000000000 D0,
     %-14.75632665940160 D0,  0.70845459248284 D0,  4.55556214787949 D0, -1.71500000000000 D0,
     %  3.35751109699261 D0, -8.14534140315813 D0,  3.06818478574443 D0, -0.89360000000000 D0,
     %  3.35751109699261 D0, -4.11632808676700 D0, -1.83648301022562 D0, -0.75470000000000 D0/

      DATA tab_Cmq / 
     %  4.62331637997542 D0, -3.31148982798528 D0,  0.01236531039804 D0, -4.29600000000000 D0,
     %  4.62331637997542 D0, -0.53750000000002 D0, -0.75743265519902 D0, -4.38900000000000 D0,
     %-24.24158189987671 D0,  2.23648982798523 D0, -0.41763468960198 D0, -4.52500000000000 D0,
     % 47.46801121953128 D0,-12.30845931194081 D0, -2.43202858639309 D0, -4.71300000000000 D0,
     %-78.79837771521306 D0, 16.17234741977796 D0, -1.65925096482566 D0, -5.31200000000000 D0,
     % 69.54494018050480 D0, -7.46716589478596 D0, -0.78873281232646 D0, -5.39500000000000 D0,
     %-26.83613615011472 D0, 13.39631615936547 D0, -0.19581778586851 D0, -5.47900000000000 D0,
     % 14.21751915691887 D0, -2.70536553070336 D0,  1.94237233986392 D0, -5.19700000000000 D0,
     %-16.65894047756097 D0,  5.82514596344797 D0,  2.56632842641284 D0, -4.80300000000000 D0,
     %  1.48920859219209 D0, -4.17021832308861 D0,  2.89731395448471 D0, -4.19000000000000 D0,
     %  1.48920859219208 D0, -2.38316801245811 D0,  0.27595942026602 D0, -3.60300000000000 D0/

      DATA tab_Cmm / 
     %  0.80189437151356 D0, -0.57738662290813 D0, -0.00759845027892 D0, -0.61550000000000 D0,
     %  0.80189437151356 D0, -0.09625000000000 D0, -0.14232577486054 D0, -0.63370000000000 D0,
     % -4.10947185756782 D0,  0.38488662290813 D0, -0.08459845027891 D0, -0.65960000000000 D0,
     %  9.22349305875775 D0, -2.08079649163255 D0, -0.42378042402380 D0, -0.69400000000000 D0,
     %-15.80500807363191 D0,  3.45329934362210 D0, -0.14927985362589 D0, -0.78820000000000 D0,
     %  9.85905349571762 D0, -1.28820307846748 D0,  0.06722977288957 D0, -0.78440000000000 D0,
     % -0.91908390292919 D0,  1.66951297024781 D0,  0.10536076206761 D0, -0.78070000000000 D0,
     % -4.72471018783214 D0,  1.11806262849030 D0,  0.66287588181523 D0, -0.70020000000000 D0,
     %  3.04292465425770 D0, -1.71676348420899 D0,  0.54313571067149 D0, -0.56070000000000 D0,
     % -0.09017374273170 D0,  0.10899130834563 D0,  0.22158127549882 D0, -0.49640000000000 D0,
     % -0.09017374273170 D0,  0.00078281706759 D0,  0.26549092566411 D0, -0.39610000000000 D0/

      DATA tab_Cyb / 
     %  0.32090534703370 D0, -0.18379320822022 D0, -0.00157757223730 D0, -0.57700000000000 D0,
     %  0.32090534703370 D0,  0.00875000000000 D0, -0.03658621388135 D0, -0.58210000000000 D0,
     % -1.72952673516844 D0,  0.20129320822022 D0,  0.00542242776269 D0, -0.58650000000000 D0,
     %  2.28470159364004 D0, -0.83642283288085 D0, -0.12160349716943 D0, -0.59120000000000 D0,
     % -6.84313732453499 D0,  0.53439812330318 D0, -0.18200843908497 D0, -0.63070000000000 D0,
     % 23.42772415661137 D0, -1.51854307405732 D0, -0.28042293416038 D0, -0.65040000000000 D0,
     %-25.22887525779279 D0,  5.50977417292609 D0,  0.11870017572649 D0, -0.67020000000000 D0,
     % 30.67163455970305 D0, -9.62755098174958 D0, -0.70485518603821 D0, -0.62790000000000 D0,
     %-16.72016298101941 D0,  8.77542975407225 D0, -0.87527943157367 D0, -0.90860000000000 D0,
     %  0.49183938426793 D0, -1.25666803453941 D0,  0.62847291233290 D0, -0.86640000000000 D0,
     %  0.49183938426793 D0, -0.66646077341790 D0, -0.14077861085003 D0, -0.78460000000000 D0/

      DATA tab_Cyr / 
     % -0.34006963653478 D0,  0.19904178192087 D0, -0.00120557092278 D0,  0.32200000000000 D0,
     % -0.34006963653478 D0, -0.00500000000000 D0,  0.03760278546139 D0,  0.32700000000000 D0,
     %  1.86284818267393 D0, -0.20904178192087 D0, -0.00520557092278 D0,  0.33160000000000 D0,
     % -3.86132309416093 D0,  0.90866712768349 D0,  0.13471949822974 D0,  0.33710000000000 D0,
     % 14.99850948774847 D0, -1.40812672881307 D0,  0.03482757800382 D0,  0.36950000000000 D0,
     %-31.03001286248097 D0,  3.09142611751147 D0,  0.20315751687366 D0,  0.37390000000000 D0,
     % 28.98682984362587 D0, -6.21757774123281 D0, -0.10945764549847 D0,  0.39410000000000 D0,
     %-35.85837180580116 D0, 11.17452016494270 D0,  0.88193083924351 D0,  0.35540000000000 D0,
     % 19.69665737957876 D0,-10.34050291853799 D0,  1.04873428852445 D0,  0.69190000000000 D0,
     % -0.58049131464007 D0,  1.47749150920927 D0, -0.72386799334130 D0,  0.64560000000000 D0,
     % -0.58049131464007 D0,  0.78090193164119 D0,  0.17948938299889 D0,  0.55530000000000 D0/

      DATA tab_Cyn / 
     % -0.05860036514339 D0,  0.04141021908604 D0,  0.00006197078853 D0,  0.13170000000000 D0,
     % -0.05860036514339 D0,  0.00625000000000 D0,  0.00959401460574 D0,  0.13290000000000 D0,
     %  0.24300182571696 D0, -0.02891021908604 D0,  0.00506197078853 D0,  0.13460000000000 D0,
     % -0.30090693772445 D0,  0.11689087634414 D0,  0.02265810224015 D0,  0.13640000000000 D0,
     %  0.80597083781813 D0, -0.06365328629053 D0,  0.03330562025087 D0,  0.14320000000000 D0,
     % -2.85678846327998 D0,  0.17813796505491 D0,  0.04475408812731 D0,  0.14670000000000 D0,
     %  0.45254218864817 D0, -0.67889857392909 D0, -0.00532197276011 D0,  0.15010000000000 D0,
     %  2.15502479605006 D0, -0.40737326074019 D0, -0.22257633969396 D0,  0.12550000000000 D0,
     % -1.68389137284839 D0,  0.88564161688985 D0, -0.12692266846403 D0,  0.08193000000000 D0,
     %  0.05522043235987 D0, -0.12469320681919 D0,  0.02526701355010 D0,  0.07850000000000 D0,
     %  0.05522043235987 D0, -0.05842868798735 D0, -0.04798174437252 D0,  0.07219000000000 D0/

      DATA tab_Cnb / 
     %  0.02987585769332 D0, -0.03817551461599 D0,  0.00004006861547 D0,  0.10958000000000 D0,
     %  0.02987585769332 D0, -0.02025000000000 D0, -0.01164503430773 D0,  0.10830000000000 D0,
     %  0.36562071153342 D0, -0.00232448538401 D0, -0.01615993138453 D0,  0.10540000000000 D0,
     % -0.62985870382700 D0,  0.21704794153604 D0,  0.02678475984587 D0,  0.10500000000000 D0,
     %  4.10658360749672 D0, -0.16086728076016 D0,  0.03802089200105 D0,  0.11400000000000 D0,
     %-14.21557242228046 D0,  1.07110780148886 D0,  0.12904494407392 D0,  0.12030000000000 D0,
     % 15.44783633339446 D0, -3.19356392519528 D0, -0.08320066829672 D0,  0.12970000000000 D0,
     %-19.59104241501951 D0,  6.07513787484140 D0,  0.49311412163250 D0,  0.10890000000000 D0,
     % 10.84133332668355 D0, -5.67948757417031 D0,  0.57224418176672 D0,  0.29380000000000 D0,
     % -0.32521325022848 D0,  0.82531242183983 D0, -0.39859084869938 D0,  0.26780000000000 D0,
     % -0.32521325022848 D0,  0.43505652156566 D0,  0.10555672866282 D0,  0.21960000000000 D0/

      DATA tab_Cll / 
     %  0.02004410086289 D0, -0.02377646051773 D0,  0.00005352806903 D0, -0.06454000000000 D0,
     %  0.02004410086289 D0, -0.01175000000000 D0, -0.00705176403452 D0, -0.06532000000000 D0,
     % -0.19647050431443 D0,  0.00027646051773 D0, -0.00934647193097 D0, -0.06704000000000 D0,
     %  0.33333791639484 D0, -0.11760584207093 D0, -0.03281234824161 D0, -0.07047000000000 D0,
     % -0.84855556739993 D0,  0.08239690776598 D0, -0.03985413510260 D0, -0.07907000000000 D0,
     %  2.59483968168012 D0, -0.17216976245400 D0, -0.04883142057140 D0, -0.08308000000000 D0,
     % -0.74715614495522 D0,  0.60628214205003 D0, -0.00542018261180 D0, -0.08709000000000 D0,
     % -0.96704069572423 D0,  0.15798845507690 D0,  0.14743393681359 D0, -0.06990000000000 D0,
     %  0.75031892785214 D0, -0.42223596235764 D0,  0.09458443535744 D0, -0.04183000000000 D0,
     % -0.01600299686314 D0,  0.02795539435365 D0,  0.01572832175664 D0, -0.03380000000000 D0,
     % -0.01600299686314 D0,  0.00875179811788 D0,  0.03041119874525 D0, -0.02406000000000 D0/

      DATA tab_Cnn / 
     %  0.13323512406033 D0, -0.09969107443620 D0, -0.00044119007517 D0, -0.05944000000000 D0,
     %  0.13323512406033 D0, -0.01975000000000 D0, -0.02432940496241 D0, -0.06245000000000 D0,
     % -0.32367562030163 D0,  0.06019107443620 D0, -0.01624119007517 D0, -0.06704000000000 D0,
     %  0.37021735714621 D0, -0.13401429774478 D0, -0.03100583473689 D0, -0.07047000000000 D0,
     % -0.87261406770338 D0,  0.08811611654294 D0, -0.04018547097726 D0, -0.07907000000000 D0,
     %  2.60074800765810 D0, -0.17366810376807 D0, -0.04874066969977 D0, -0.08308000000000 D0,
     % -0.74773523705564 D0,  0.60655629852936 D0, -0.00545185022365 D0, -0.08709000000000 D0,
     % -0.96688680001535 D0,  0.15791515629597 D0,  0.14744244074142 D0, -0.06990000000000 D0,
     %  0.75028243711704 D0, -0.42221692371324 D0,  0.09458208725797 D0, -0.04183000000000 D0,
     % -0.01600141030944 D0,  0.02795253855699 D0,  0.01572921022672 D0, -0.03380000000000 D0,
     % -0.01600141030944 D0,  0.00875084618566 D0,  0.03041056412377 D0, -0.02406000000000 D0/

      DATA tab_Cnl / 
     % -0.16266723413055 D0,  0.09960034047833 D0,  0.00008662126956 D0, -0.07260000000000 D0,
     % -0.16266723413055 D0,  0.00200000000000 D0,  0.02040668936522 D0, -0.06990000000000 D0, 
     %  0.00708617065277 D0, -0.09560034047833 D0,  0.00168662126956 D0, -0.06704000000000 D0,
     %  0.27432255151947 D0, -0.09134863808667 D0, -0.03570317444344 D0, -0.07047000000000 D0,
     % -0.81005657867245 D0,  0.07324489282501 D0, -0.03932392349578 D0, -0.07907000000000 D0,
     %  2.58538503686206 D0, -0.16977208077673 D0, -0.04897664229095 D0, -0.08308000000000 D0,
     % -0.74622946789867 D0,  0.60584343028189 D0, -0.00536950734043 D0, -0.08709000000000 D0,
     % -0.96728696332556 D0,  0.15810574954269 D0,  0.14742032862448 D0, -0.06990000000000 D0,
     %  0.75037732120091 D0, -0.42226642845265 D0,  0.09458819284249 D0, -0.04183000000000 D0,
     % -0.01600553570439 D0,  0.02795996426790 D0,  0.01572690000554 D0, -0.03380000000000 D0,
     %- 0.01600553570439 D0,  0.00875332142263 D0,  0.03041221428175 D0, -0.02406000000000 D0/

      DATA tab_Cyp1 / 
     % -0.29835560193812 D0,  0.25276336116287 D0, -0.00061844815505 D0,  0.35540000000000 D0,
     % -0.29835560193812 D0,  0.07375000000000 D0,  0.06468422407752 D0,  0.36300000000000 D0,
     %  1.37927800969059 D0, -0.10526336116287 D0,  0.05838155184495 D0,  0.37650000000000 D0,
     % -1.23125643682425 D0,  0.72230344465148 D0,  0.18178956854267 D0,  0.39500000000000 D0,
     % -5.33151322400504 D0, -0.01645041744307 D0,  0.32296017398436 D0,  0.45040000000000 D0,
     % 25.88657446888648 D0, -1.61590438464457 D0,  0.15972469377559 D0,  0.47720000000000 D0,
     %-54.16636605293867 D0,  6.15006795602137 D0,  0.61314105091327 D0,  0.50290000000000 D0,
     % 96.58115070447961 D0,-26.34975167574183 D0, -3.42679569303082 D0,  0.43820000000000 D0,
     %-64.78323676497962 D0, 31.59893874694591 D0, -2.37695827879000 D0, -0.52850000000000 D0,
     %  3.03764072891216 D0, -7.27100331204189 D0,  2.48862880819081 D0, -0.25820000000000 D0, 
     %  3.03764072891216 D0, -3.62583443734730 D0, -1.87010629156486 D0, -0.23170000000000 D0/

      DATA tab_Cyp2 / 
     %  0.72025646839796 D0, -0.58590388103878 D0,  0.00137051747184 D0, -0.90700000000000 D0,
     %  0.72025646839796 D0, -0.15375000000000 D0, -0.14656025873592 D0, -0.92440000000000 D0,
     % -3.25128234198981 D0,  0.27840388103878 D0, -0.12162948252816 D0, -0.95410000000000 D0,
     %  3.22237289956128 D0, -1.67236552415511 D0, -0.40042181115143 D0, -0.99330000000000 D0,
     %  7.05774513079538 D0,  0.26105821558166 D0, -0.68268327286612 D0, -1.11450000000000 D0,
     %-38.50988996561004 D0,  2.37838175482027 D0, -0.41873927582593 D0, -1.17310000000000 D0,
     % 94.05691677006807 D0, -9.17458523486274 D0, -1.09835962383017 D0, -1.22970000000000 D0,
     %-176.1137315017129 D0, 47.25956482717810 D0,  6.51863629463289 D0, -1.06390000000000 D0,
     % 120.4105092367830 D0,-58.40867407384958 D0,  4.28881444529860 D0,  0.72130000000000 D0,
     % -5.80255319663032 D0, 13.83763146822029 D0, -4.62539407582727 D0,  0.20600000000000 D0,
     % -5.80255319663032 D0,  6.87456763226391 D0,  3.65948556436641 D0,  0.19850000000000 D0/

      DATA tab_Clb1 / 
     % -6.25312895394765 D0,  4.23812737236859 D0, -0.00150031631581 D0, -0.19650000000000 D0,
     % -6.25312895394766 D0,  0.48625000000000 D0,  0.94337515815791 D0, -0.07730000000000 D0,
     %  7.31564476973829 D0, -3.26562737236859 D0,  0.38749968368419 D0,  0.08080000000000 D0,
     % -2.50945012500551 D0,  1.12375948947438 D0, -0.04087389289466 D0,  0.08620000000000 D0,
     %  1.46951706584572 D0, -0.38191058552893 D0,  0.10749588789444 D0,  0.10290000000000 D0,
     % -0.70937361865006 D0,  0.05894453422479 D0,  0.07519928276402 D0,  0.11130000000000 D0,
     % -3.24833676938580 D0, -0.15386755137023 D0,  0.06570698104948 D0,  0.11870000000000 D0,
     %  7.10535936063130 D0, -2.10286961300171 D0, -0.38564045182491 D0,  0.09970000000000 D0,
     % -3.83560067313938 D0,  2.16034600337707 D0, -0.37414517374984 D0, -0.00470000000000 D0,
     %  0.06209133361476 D0, -0.14101440050656 D0,  0.02972114682426 D0, -0.02380000000000 D0, 
     %  0.06209133361476 D0, -0.06650480016885 D0, -0.05328653344590 D0, -0.03050000000000 D0/

      DATA tab_Clb2 / 
     % 20.54043062864379 D0,-13.90175837718627 D0, -0.00526554970850 D0,  0.64800000000000 D0,
     % 20.54043062864377 D0, -1.57749999999999 D0, -3.10111722514575 D0,  0.25520000000000 D0,
     %-23.73965314321898 D0, 10.74675837718628 D0, -1.26726554970850 D0, -0.26380000000000 D0,
     %  7.91818194423210 D0, -3.49703350874511 D0,  0.18267942397974 D0, -0.27730000000000 D0,
     % -5.94354195689613 D0,  1.25387565779415 D0, -0.26595214621045 D0, -0.31730000000000 D0,
     %  6.24019662859753 D0, -0.52918692927469 D0, -0.19348327335851 D0, -0.33730000000000 D0,
     %  2.51350871236510 D0,  1.34287205930457 D0, -0.11211476035552 D0, -0.35570000000000 D0,
     % -9.72126415487120 D0,  2.85097728672363 D0,  0.72665510885012 D0, -0.30430000000000 D0,
     %  4.93404790711968 D0, -2.98178120619909 D0,  0.70049432495503 D0, -0.12270000000000 D0,
     % -0.00672879099278 D0, -0.02135246192728 D0,  0.09986759132976 D0, -0.06240000000000 D0,
     % -0.00672879099278 D0, -0.02942701111862 D0,  0.07955580211140 D0, -0.02630000000000 D0/

      DATA tab_Clp1 / 
     % -0.08275683388146 D0,  0.06715410032887 D0, -0.00012054671052 D0, -0.23390000000000 D0,
     % -0.08275683388146 D0,  0.01750000000000 D0,  0.01681027335526 D0, -0.23190000000000 D0,
     %  0.08878416940728 D0, -0.03215410032887 D0,  0.01387945328948 D0, -0.22850000000000 D0,
     %  0.05262015625232 D0,  0.02111640131550 D0,  0.01167191348681 D0, -0.22630000000000 D0,
     % -1.47017422699734 D0,  0.05268849506689 D0,  0.02643289276328 D0, -0.22270000000000 D0,
     %  4.59710123364893 D0, -0.38836377303231 D0, -0.00713463503326 D0, -0.22100000000000 D0,
     % -6.36897416955551 D0,  0.99076659706236 D0,  0.05310564736975 D0, -0.22100000000000 D0,
     % 11.02470487715389 D0, -2.83061790467094 D0, -0.31486461415197 D0, -0.22170000000000 D0,
     % -8.06734533906004 D0,  3.78420502162139 D0, -0.12414719076188 D0, -0.30970000000000 D0,
     %  0.43142184703988 D0, -1.05620218181464 D0,  0.42145337719947 D0, -0.24770000000000 D0,
     %  0.43142184703988 D0, -0.53849596536678 D0, -0.21642588167309 D0, -0.22050000000000 D0/

      DATA tab_Clp2 / 
     %  0.02750909546287 D0, -0.01625545727772 D0,  0.00005072763703 D0, -0.28388000000000 D0,
     %  0.02750909546287 D0,  0.00025000000000 D0, -0.00315036381851 D0, -0.28430000000000 D0, 
     % -0.45254547731434 D0,  0.01675545727772 D0,  0.00025072763703 D0, -0.28470000000000 D0, 
     %  0.67017281379448 D0, -0.25477182911088 D0, -0.04735254672960 D0, -0.28760000000000 D0,
     % -2.68926451979631 D0,  0.14733185916581 D0, -0.06884054071862 D0, -0.30190000000000 D0, 
     %  7.49968541566539 D0, -0.65944749677309 D0, -0.12005210447935 D0, -0.31000000000000 D0,
     % -4.72851460553264 D0,  1.59045812792653 D0, -0.02695104136400 D0, -0.32110000000000 D0,
     %  4.88799174839790 D0, -1.24665063539305 D0,  0.04181045714269 D0, -0.30070000000000 D0, 
     % -4.06095238805899 D0,  1.68614441364569 D0,  0.12970921279322 D0, -0.30310000000000 D0,
     %  0.30355072494666 D0, -0.75042701918971 D0,  0.31685269168442 D0, -0.24220000000000 D0,
     %  0.30355072494666 D0, -0.38616614925371 D0, -0.13778457569295 D0, -0.21610000000000 D0/

      DATA tab_Clr1 / 
     %  0.03850784675297 D0, -0.03472970805178 D0,  0.00005562774024 D0, -0.03133000000000 D0,
     %  0.03850784675297 D0, -0.01162500000000 D0, -0.00921531387012 D0, -0.03240000000000 D0,
     % -0.20128923376487 D0,  0.01147970805178 D0, -0.00924437225976 D0, -0.03440000000000 D0,
     %  0.27914908830650 D0, -0.10929383220714 D0, -0.02880719709083 D0, -0.03740000000000 D0,
     %  0.42072772992313 D0,  0.05819562077676 D0, -0.03902683937691 D0, -0.04530000000000 D0,
     % -1.76755106515089 D0,  0.18441393975370 D0, -0.01476588332386 D0, -0.04820000000000 D0,
     %  3.95199758214902 D0, -0.34585137979156 D0, -0.03090962732765 D0, -0.04960000000000 D0,
     % -6.91397411282943 D0,  2.02534716949784 D0,  0.30498953061361 D0, -0.03800000000000 D0,
     %  3.94139886916868 D0, -2.12303729819981 D0,  0.28545150487321 D0,  0.04870000000000 D0,
     % -0.09953287008808 D0,  0.24180202330140 D0, -0.09079555010647 D0,  0.05240000000000 D0,
     % -0.09953287008808 D0,  0.12236257919570 D0,  0.05487029089237 D0,  0.04840000000000 D0/

      DATA tab_Clr2 / 
     % -0.13736217749381 D0,  0.10991730649629 D0,  0.00001102580050 D0,  0.16890000000000 D0,
     % -0.13736217749381 D0,  0.02750000000000 D0,  0.02749448709975 D0,  0.17220000000000 D0,
     %  0.64931088746905 D0, -0.05491730649629 D0,  0.02201102580050 D0,  0.17770000000000 D0,
     % -0.87238137238240 D0,  0.33466922598515 D0,  0.07796140969827 D0,  0.18510000000000 D0, 
     %  1.27326243379927 D0, -0.18875959744430 D0,  0.10714333540644 D0,  0.20710000000000 D0,
     % -4.09112022011041 D0,  0.19321913269548 D0,  0.10758928893156 D0,  0.21720000000000 D0,
     %  0.28309694500468 D0, -1.03411693333764 D0,  0.02349950886734 D0,  0.22580000000000 D0, 
     %  3.58818460835296 D0, -0.86425876633483 D0, -0.35617563106715 D0,  0.19140000000000 D0,
     % -2.24833537841653 D0,  1.28865199867695 D0, -0.27129698459873 D0,  0.11430000000000 D0,
     %  0.03297576179451 D0, -0.06034922837297 D0, -0.02563643053793 D0,  0.09360000000000 D0,
     %  0.03297576179451 D0, -0.02077831421956 D0, -0.05808744757495 D0,  0.07580000000000 D0/

      DATA tab_Cln1 / 
     %  0.02921999037865 D0, -0.01378199422719 D0,  0.00008759923029 D0,  0.02379000000000 D0,
     %  0.02921999037865 D0,  0.00375000000000 D0, -0.00191879961515 D0,  0.02349000000000 D0,
     % -0.03984995189324 D0,  0.02128199422719 D0,  0.00308759923029 D0,  0.02349000000000 D0,
     % -0.01482018280571 D0, -0.00262797690875 D0,  0.00681840269398 D0,  0.02464000000000 D0,
     %  0.29632186654248 D0, -0.01152008659218 D0,  0.00398878999379 D0,  0.02578000000000 D0,
     % -0.69120760086888 D0,  0.07737647337057 D0,  0.01057442867163 D0,  0.02636000000000 D0,
     %  0.08709165145849 D0, -0.12998580689009 D0,  0.00531349531968 D0,  0.02750000000000 D0,
     %  0.36439981160849 D0, -0.07773081601500 D0, -0.03622982926134 D0,  0.02406000000000 D0,
     % -0.25844089789244 D0,  0.14090907095009 D0, -0.02359417827432 D0,  0.01662000000000 D0, 
     %  0.00644152972203 D0, -0.01415546778537 D0,  0.00175654235862 D0,  0.01547000000000 D0,
     %  0.00644152972203 D0, -0.00642563211893 D0, -0.00647589760310 D0,  0.01432000000000 D0/

      DATA tab_Cln2 / 
     %  0.00927201325365 D0, -0.00432570795219 D0, -0.00000073893971 D0, -0.00964100000000 D0,
     %  0.00927201325365 D0,  0.00123750000000 D0, -0.00061838053015 D0, -0.00974000000000 D0,
     % -0.05873506626825 D0,  0.00680070795219 D0,  0.00098926106029 D0, -0.00974000000000 D0,
     %  0.08191825181935 D0, -0.02844033180876 D0, -0.00333866371102 D0, -0.00974000000000 D0,
     % -0.28864557120806 D0,  0.02071061928285 D0, -0.00488460621620 D0, -0.01089000000000 D0,
     %  0.44901547038335 D0, -0.06588305207957 D0, -0.00940184949588 D0, -0.01146000000000 D0,
     % -0.04390805016992 D0,  0.06882158903543 D0, -0.00910799580029 D0, -0.01261000000000 D0,
     % -0.18330063950475 D0,  0.04247675893348 D0,  0.01315167379349 D0, -0.01203000000000 D0,
     %  0.13386060818890 D0, -0.06750362476936 D0,  0.00814630062632 D0, -0.00916700000000 D0,
     % -0.00562949849269 D0,  0.01281274014398 D0, -0.00279187629876 D0, -0.00916700000000 D0,
     % -0.00562949849269 D0,  0.00605734195275 D0,  0.00475615653993 D0, -0.00859400000000 D0/

      DATA tab_Cnp1 / 
     % -0.15609979364396 D0,  0.11865987618637 D0,  0.00001201650848 D0,  0.17460000000000 D0,
     % -0.15609979364396 D0,  0.02500000000000 D0,  0.02874399174576 D0,  0.17810000000000 D0,
     %  0.73049896821979 D0, -0.06865987618637 D0,  0.02001201650848 D0,  0.18360000000000 D0,
     % -0.65339607923519 D0,  0.36963950474550 D0,  0.08020794222031 D0,  0.19070000000000 D0,
     %  3.25835996692778 D0, -0.02239814279562 D0,  0.14965621461028 D0,  0.21630000000000 D0,
     %-11.34383697872660 D0,  0.95510984728272 D0,  0.24292738505899 D0,  0.23430000000000 D0,
     %  6.46185010283283 D0, -2.44804124633526 D0,  0.09363424515374 D0,  0.25680000000000 D0,
     % -6.27883805081154 D0,  1.42906881536444 D0, -0.11016024104043 D0,  0.22930000000000 D0,
     %  6.12850210041333 D0, -2.33823401512249 D0, -0.29199328099204 D0,  0.21420000000000 D0, 
     % -0.55425164411735 D0,  1.33886724512551 D0, -0.49186663499143 D0,  0.11130000000000 D0, 
     % -0.55425164411735 D0,  0.67376527218470 D0,  0.31318637193265 D0,  0.09330000000000 D0/

      DATA tab_Cnp2 / 
     %  0.24240004102552 D0, -0.19044002461531 D0, -0.00010799671796 D0, -0.25740000000000 D0,
     %  0.24240004102552 D0, -0.04500000000000 D0, -0.04719600164102 D0, -0.26310000000000 D0,
     % -1.19950020512761 D0,  0.10044002461531 D0, -0.03610799671796 D0, -0.27240000000000 D0,
     %  0.98060077948492 D0, -0.61926009846125 D0, -0.13987201148715 D0, -0.28520000000000 D0,
     % -4.50060795895132 D0, -0.03089963077030 D0, -0.26990395733346 D0, -0.33010000000000 D0,
     % 15.52103241016263 D0, -1.38108201845570 D0, -0.41110212225606 D0, -0.36190000000000 D0,
     % -5.33394968190753 D0,  3.27522770459309 D0, -0.22168755364232 D0, -0.40130000000000 D0,
     %  3.34247136360673 D0,  0.07485789544858 D0,  0.44832956636602 D0, -0.35730000000000 D0,
     % -7.43593577251940 D0,  2.08034071361261 D0,  0.87936928817825 D0, -0.23790000000000 D0,
     %  0.99403136899153 D0, -2.38122074989903 D0,  0.81919328092097 D0, -0.03830000000000 D0,
     %  0.99403136899153 D0, -1.18838310710920 D0, -0.60864826188232 D0, -0.02800000000000 D0/

      DATA tab_Cnr1 / 
     %  0.24801351217862 D0, -0.18755810730717 D0,  0.00009108097429 D0, -0.18050000000000 D0,
     %  0.24801351217862 D0, -0.03875000000000 D0, -0.04517054048714 D0, -0.18600000000000 D0, 
     % -0.57756756089310 D0,  0.11005810730717 D0, -0.03090891902571 D0, -0.19460000000000 D0,
     %  0.73725673139379 D0, -0.23648242922869 D0, -0.05619378341001 D0, -0.20100000000000 D0,
     % -6.62712136265242 D0,  0.20587160960759 D0, -0.06231594733423 D0, -0.21580000000000 D0,
     % 16.51817462111039 D0, -1.78226479918814 D0, -0.21995526629229 D0, -0.22660000000000 D0,
     %-13.86936324830970 D0,  3.17318758714497 D0, -0.08086298749661 D0, -0.24990000000000 D0,
     % 16.88994037009875 D0, -5.14843036184085 D0, -0.47591154243578 D0, -0.25010000000000 D0,
     % -9.44039823208527 D0,  4.98553386021840 D0, -0.50849084276027 D0, -0.41610000000000 D0,
     %  0.26316948835153 D0, -0.67870507903276 D0,  0.35287491347686 D0, -0.39390000000000 D0,
     %  0.26316948835153 D0, -0.36290169301092 D0, -0.06376779534061 D0, -0.34450000000000 D0/

      DATA tab_Cnr2 / 
     %  0.29958434881907 D0, -0.22975060929144 D0,  0.00046674790553 D0, -0.21390000000000 D0,
     %  0.29958434881907 D0, -0.05000000000000 D0, -0.05548337395276 D0, -0.22060000000000 D0,
     % -0.86042174409536 D0,  0.12975060929144 D0, -0.03953325209447 D0, -0.23130000000000 D0,
     %  1.10460262756237 D0, -0.38650243716577 D0, -0.09088361766934 D0, -0.24090000000000 D0,
     % -7.66936367090000 D0,  0.27625913937165 D0, -0.11293227722816 D0, -0.26570000000000 D0,
     % 19.92163556706695 D0, -2.02454996189835 D0, -0.28776135948083 D0, -0.28190000000000 D0,
     %-15.54664641989628 D0,  3.95194070822174 D0, -0.09502228484850 D0, -0.31100000000000 D0,
     % 17.23882501726403 D0, -5.37604714371603 D0, -0.37984357194735 D0, -0.29630000000000 D0,
     % -9.48365364915980 D0,  4.96724786664238 D0, -0.46160342736208 D0, -0.44940000000000 D0,
     %  0.27762779841067 D0, -0.72294432285350 D0,  0.38725728139569 D0, -0.41890000000000 D0,
     %  0.27762779841068 D0, -0.38979096476069 D0, -0.05783683364998 D0, -0.36190000000000 D0/


C Environnement physique (l'altitude est egale a -x(3))
      T = T0 + k*x(3)
      rho = rho0*(T/T0)**(g/(k*R) - 1.D0)
      Mach = x(4)/sqrt(gamma*R*T)
      pcin = rho*S*x(4)**2/2.D0


C Coefficients aerodynamiques caclules par interpolation par splines cubiques
      Mach_sat = MIN(3.D0,Mach)
      Mach_sat = MAX(0.D0,Mach_sat)
      i = 10*Mach_sat+1
      i = index(i)
      dM = Mach_sat-breaks(i)

      Cx0 = ((tab_Cx0(1,i)*dM+tab_Cx0(2,i))*dM + tab_Cx0(3,i))*dM + tab_Cx0(4,i)
      Cz0 = -0.1D0
      Cz0p = ((tab_Cz0p(1,i)*dM+tab_Cz0p(2,i))*dM + tab_Cz0p(3,i))*dM + tab_Cz0p(4,i)
      Cza = ((tab_Cza(1,i)*dM+tab_Cza(2,i))*dM + tab_Cza(3,i))*dM + tab_Cza(4,i)
      Czda = ((tab_Czda(1,i)*dM+tab_Czda(2,i))*dM + tab_Czda(3,i))*dM + tab_Czda(4,i)
      Czq = ((tab_Czq(1,i)*dM+tab_Czq(2,i))*dM + tab_Czq(3,i))*dM + tab_Czq(4,i)
      Czm = ((tab_Czm(1,i)*dM+tab_Czm(2,i))*dM + tab_Czm(3,i))*dM + tab_Czm(4,i)
      Cm0 = 0.0D0
      Cma = ((tab_Cma(1,i)*dM+tab_Cma(2,i))*dM + tab_Cma(3,i))*dM + tab_Cma(4,i)
      Cmda = ((tab_Cmda(1,i)*dM+tab_Cmda(2,i))*dM + tab_Cmda(3,i))*dM + tab_Cmda(4,i)
      Cmq = ((tab_Cmq(1,i)*dM+tab_Cmq(2,i))*dM + tab_Cmq(3,i))*dM + tab_Cmq(4,i)
      Cmm = ((tab_Cmm(1,i)*dM+tab_Cmm(2,i))*dM + tab_Cmm(3,i))*dM + tab_Cmm(4,i)
      Cyb = ((tab_Cyb(1,i)*dM+tab_Cyb(2,i))*dM + tab_Cyb(3,i))*dM + tab_Cyb(4,i)
      Cyr = ((tab_Cyr(1,i)*dM+tab_Cyr(2,i))*dM + tab_Cyr(3,i))*dM + tab_Cyr(4,i)
      Cyn = ((tab_Cyn(1,i)*dM+tab_Cyn(2,i))*dM + tab_Cyn(3,i))*dM + tab_Cyn(4,i)
      Cnb = ((tab_Cnb(1,i)*dM+tab_Cnb(2,i))*dM + tab_Cnb(3,i))*dM + tab_Cnb(4,i)
      Cll = ((tab_Cll(1,i)*dM+tab_Cll(2,i))*dM + tab_Cll(3,i))*dM + tab_Cll(4,i)
      Cnn = ((tab_Cnn(1,i)*dM+tab_Cnn(2,i))*dM + tab_Cnn(3,i))*dM + tab_Cnn(4,i)
      Cnl = ((tab_Cnl(1,i)*dM+tab_Cnl(2,i))*dM + tab_Cnl(3,i))*dM + tab_Cnl(4,i)
      Cyp1 = ((tab_Cyp1(1,i)*dM+tab_Cyp1(2,i))*dM + tab_Cyp1(3,i))*dM + tab_Cyp1(4,i)
      Cyp2 = ((tab_Cyp2(1,i)*dM+tab_Cyp2(2,i))*dM + tab_Cyp2(3,i))*dM + tab_Cyp2(4,i)
      Clb1 = ((tab_Clb1(1,i)*dM+tab_Clb1(2,i))*dM + tab_Clb1(3,i))*dM + tab_Clb1(4,i)
      Clb2 = ((tab_Clb2(1,i)*dM+tab_Clb2(2,i))*dM + tab_Clb2(3,i))*dM + tab_Clb2(4,i)
      Clp1 = ((tab_Clp1(1,i)*dM+tab_Clp1(2,i))*dM + tab_Clp1(3,i))*dM + tab_Clp1(4,i)
      Clp2 = ((tab_Clp2(1,i)*dM+tab_Clp2(2,i))*dM + tab_Clp2(3,i))*dM + tab_Clp2(4,i)
      Clr1 = ((tab_Clr1(1,i)*dM+tab_Clr1(2,i))*dM + tab_Clr1(3,i))*dM + tab_Clr1(4,i)
      Clr2 = ((tab_Clr2(1,i)*dM+tab_Clr2(2,i))*dM + tab_Clr2(3,i))*dM + tab_Clr2(4,i)
      Cln1 = ((tab_Cln1(1,i)*dM+tab_Cln1(2,i))*dM + tab_Cln1(3,i))*dM + tab_Cln1(4,i)
      Cln2 = ((tab_Cln2(1,i)*dM+tab_Cln2(2,i))*dM + tab_Cln2(3,i))*dM + tab_Cln2(4,i)
      Cnp1 = ((tab_Cnp1(1,i)*dM+tab_Cnp1(2,i))*dM + tab_Cnp1(3,i))*dM + tab_Cnp1(4,i)
      Cnp2 = ((tab_Cnp2(1,i)*dM+tab_Cnp2(2,i))*dM + tab_Cnp2(3,i))*dM + tab_Cnp2(4,i)
      Cnr1 = ((tab_Cnr1(1,i)*dM+tab_Cnr1(2,i))*dM + tab_Cnr1(3,i))*dM + tab_Cnr1(4,i)
      Cnr2 = ((tab_Cnr2(1,i)*dM+tab_Cnr2(2,i))*dM + tab_Cnr2(3,i))*dM + tab_Cnr2(4,i)

      alpha_deg =x(5)*57.29577951308232 D0
      Cyp = ( Cyp1*(20.D0-alpha_deg) + Cyp2*(10.D0+alpha_deg) )/30.D0
      Clb = ( Clb1*(20.D0-alpha_deg) + Clb2*(10.D0+alpha_deg) )/30.D0
      Clp = ( Clp1*(20.D0-alpha_deg) + Clp2*(10.D0+alpha_deg) )/30.D0
      Clr = ( Clr1*(20.D0-alpha_deg) + Clr2*(10.D0+alpha_deg) )/30.D0
      Cln = ( Cln1*(20.D0-alpha_deg) + Cln2*(10.D0+alpha_deg) )/30.D0
      Cnp = ( Cnp1*(20.D0-alpha_deg) + Cnp2*(10.D0+alpha_deg) )/30.D0
      Cnr = ( Cnr1*(20.D0-alpha_deg) + Cnr2*(10.D0+alpha_deg) )/30.D0


C Equations du mouvement (mises sous forme explicite)
      C5=cos(x(5))
      C6=cos(x(6))
      C7=cos(x(7))
      C8=cos(x(8))
      C9=cos(x(9))
      S5=sin(x(5))
      S6=sin(x(6))
      S7=sin(x(7))
      S8=sin(x(8))
      S9=sin(x(9))
      T6=sin(x(6))/cos(x(6))
      T7=sin(x(7))/cos(x(7))

      Cx = Cx0 + (Cz0 - Cz0p + Cza*x(5))**2
      Cy = Cyn*u(3) + Cyb*x(6) + b*(Cyp*x(10) + Cyr*x(12))/(2.D0*x(4))

      Czstar = Cz0 + Czm*u(2) + Cza*x(5) + a*Czq*x(11)/(2.D0*x(4))
      fZstar = -pcin*Czstar - g*m*S5*u(4)

      xd(5) = (C7*C9*g + fZstar/m)/(C6*x(4)) - C5*T6*x(10) + x(11) - 
     % S5*T6*x(12)
      xd(5) = xd(5)/( 1.D0 + a*Czda*rho*S/(4.D0 *C6*m) )

      Cz = Czstar + a*Czda*xd(5)/(2.D0*x(4))

      Cl = Clb*x(6) + b*( Clp*x(10)+Clr*x(12) )/(2.D0*x(4)) + Cll*u(1) + 
     % Cln*u(3)
      Cm = Cm0 + Cma*x(5) + a*( Cmda*xd(5) + Cmq*x(11) )/(2.D0*x(4)) + 
     % Cmm*u(2)
      Cn = Cnb*x(6) + b*( Cnp*x(10) + Cnr*x(12) )/(2.D0*x(4)) + 
     % Cnl*u(1) + Cnn*u(3)

      fX = -pcin*Cx + C6*g*m*C5*u(4)
      fY = pcin*Cy + g*m*S6*C5*u(4)
      fZ = -pcin*Cz - g*m*S5*u(4)
      mL = b*pcin*Cl
      mM = a*pcin*Cm
      mN = b*pcin*Cn

      xd(1) = C7*C8*x(4)
      xd(2) = C7*S8*x(4)
      xd(3) = -S7*x(4)
      xd(4) = fX/m - g*S7
      xd(6) = fY/(m*x(4)) + C7*g*S9/x(4) + S5*x(10) - C5*x(12)
      xd(7) = -C7*g/x(4) - (C9*fZ + fY*S9)/(m*x(4))
      xd(8) = (C9*fY - fZ*S9)/(C7*m*x(4))
      xd(9) = -C7*C9*g*T6/x(4) + (C9*fY*T7 - fZ*(T6 + S9*T7))/(m*x(4)) +
     % (C5*x(10) + S5*x(12))/C6

      corL = (Izz - Iyy)*x(11)*x(12) - Ixz*x(10)*x(11)    
      corM = (Ixx - Izz)*x(10)*x(12) + Ixz*(x(10)**2 - x(12)**2)
      corN = (Iyy - Ixx)*x(10)*x(11) + Ixz*x(11)*x(12)
      det = Ixx*Izz - Ixz**2

      xd(10) = ( Izz*(mL - corL) + Ixz*(mN - corN) )/det
      xd(11) = (mM - corM)/Iyy
      xd(12) = ( Ixz*(mL - corL) + Ixx*(mN - corN) )/det

      RETURN
      END      
   
