/*
 *
 *  (c) COPYRIGHT MIT and INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/*
 * Amaya browser functions called form Thot and declared in HTML.A
 * These functions concern Image elements.
 *
 * Author: I. Vatton
 *
 */

/* Included headerfiles */
#define THOT_EXPORT extern
#include "amaya.h"


#include "init_f.h"
#include "query_f.h"
#include "AHTURLTools_f.h"
#include "EDITimage_f.h"
#include "HTMLactions_f.h"
#include "HTMLedit_f.h"


/*----------------------------------------------------------------------
   AddLoadedImage adds a new image into image descriptor table.	
   Local images are not stored into this table and the function    
   returns no descriptor and the value FALSE.                      
   If the remote image is new, adds a descriptor for this image    
   notes its local name and returns TRUE.                          
   For already loaded remote images the function returns the      
   descriptor entry and the value FALSE.                           
  ----------------------------------------------------------------------*/
#ifdef __STDC__
boolean             AddLoadedImage (char *name, char *pathname, Document doc, LoadedImageDesc ** desc)
#else  /* __STDC__ */
boolean             AddLoadedImage (name, pathname, doc, desc)
char               *name;
char               *pathname;
Document            doc;
LoadedImageDesc   **desc;

#endif /* __STDC__ */
{
   LoadedImageDesc    *pImage, *previous, *sameImage;
   char                localname[MAX_LENGTH];

   *desc = NULL;
   sameImage = NULL;
   if (pathname == NULL || name == NULL)
      return (FALSE);
   else if (IsHTTPPath (pathname))
     {
	/* It is an image loaded from the Web */
	sprintf (localname, "%s%s%d%s", TempFileDirectory, DIR_STR, doc, DIR_STR);
	strcat (localname, name);
     }
   else
      /* it is a local image */
      return (FALSE);		/* nothing to do */

   pImage = ImageURLs;
   previous = NULL;
   while (pImage != NULL)
     {
	if (strcmp (pathname, pImage->originalName) == 0)
	  {
	     /* image already loaded */
	     sameImage = pImage;
	     if (pImage->document == doc)
	       {
		  *desc = pImage;
		  return (FALSE);
	       }
	     else
	       {
		  /* see the next descriptor */
		  previous = pImage;
		  pImage = pImage->nextImage;
	       }
	  }
	else
	  {
	     /* see the next descriptor */
	     previous = pImage;
	     pImage = pImage->nextImage;
	  }
     }

   /* It is a new loaded image */
   pImage = (LoadedImageDesc *) TtaGetMemory (sizeof (LoadedImageDesc));
   pImage->originalName = TtaGetMemory (strlen (pathname) + 1);
   strcpy (pImage->originalName, pathname);
   pImage->localName = TtaGetMemory (strlen (localname) + 1);
   strcpy (pImage->localName, localname);
   pImage->prevImage = previous;
   if (previous != NULL)
      previous->nextImage = pImage;
   else
      ImageURLs = pImage;
   pImage->nextImage = NULL;
   pImage->document = doc;
   pImage->elImage = NULL;
   *desc = pImage;
   if (sameImage != NULL)
     {
	/* the image file exist for a different document */
	pImage->status = IMAGE_LOADED;
	TtaFileCopy (sameImage->localName, pImage->localName);
	return (FALSE);
     }
   else
     {
	pImage->status = IMAGE_NOT_LOADED;
	return (TRUE);
     }
}


/*----------------------------------------------------------------------
   SearchLoadedImage searches the image descriptor of a loaded image using
   its local name.
   The function returns the descriptor entry or NULL.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
LoadedImageDesc    *SearchLoadedImage (char *localpath, Document doc)
#else  /* __STDC__ */
LoadedImageDesc    *SearchLoadedImage (localpath, doc)
char               *localpath;
Document            doc;
#endif /* __STDC__ */
{
  LoadedImageDesc    *pImage;
  
  if (localpath == NULL)
    return (NULL);
  else
    {
      pImage = ImageURLs;
      while (pImage != NULL)
	{
	  if (strcmp (localpath, pImage->localName) == 0 && pImage->document == doc)
	    /* image found */
	    return (pImage);
	  else
	    /* see the next descriptor */
	    pImage = pImage->nextImage;
	}
    }
  return (NULL);
}


/*----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                DisplayImage (Document doc, Element el, char *imageName)
#else  /* __STDC__ */
void                DisplayImage (doc, el, imageName)
Document            doc;
Element             el;
char               *imageName;

#endif /* __STDC__ */
{
   ElementType         elType;
   Element             elPicture;
   int                 modified;

   modified = TtaIsDocumentModified (doc);
   elType = TtaGetElementType (el);
   elPicture = NULL;
   if (elType.ElTypeNum == HTML_EL_PICTURE_UNIT)
      elPicture = el;
   if (elPicture != NULL)
      TtaSetTextContent (elPicture, imageName, SPACE, doc);

   UpdateImageMap (elPicture, doc);
   /* if the document was not modified before this update reset it unmodified */
   if (!modified)
      TtaSetDocumentUnmodified (doc);
}


/*----------------------------------------------------------------------
   ImageLoaded is the callback procedure when the image is loaded	
   		from the web.						
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                ImageLoaded (AHTReqContext * context, int status)
#else  /* __STDC__ */
void                ImageLoaded (context, status)
AHTReqContext      *context;
int                 status;

#endif /* __STDC__ */
{
   char               *pathname;
   char                tempfile[MAX_LENGTH];
   LoadedImageDesc    *desc;
   Document            doc;
   ElemImage          *ctxEl, *ctxPrev;

   doc = context->docid;
   if (DocumentURLs[doc] != NULL)
     {
	/* an image of the document is now loaded */

	/* update the stop button status */
	FilesLoading[doc]--;
	if (FilesLoading[doc] == 1)
	   ResetStop (doc);

	/* the image could not be loaded */
	if (status != HT_LOADED)
	   return;

	/* rename the local file of the image */
	desc = (LoadedImageDesc *) context->context_tcbf;
	strcpy (tempfile, desc->localName);
	TtaFileUnlink (tempfile);
	rename (context->outputfile, tempfile);

	/* save pathname */
	TtaFreeMemory (desc->originalName);
	pathname = context->urlName;
	desc->originalName = TtaGetMemory (strlen (pathname) + 1);
	desc->status = IMAGE_LOADED;
	strcpy (desc->originalName, pathname);
	/* display for each elements in the list */
	ctxEl = desc->elImage;
	desc->elImage = NULL;
	while (ctxEl != NULL)
	  {
	     DisplayImage (context->docid, ctxEl->currentElement, tempfile);
	     ctxPrev = ctxEl;
	     ctxEl = ctxEl->nextElement;
	     TtaFreeMemory ((char *) ctxPrev);
	  }
     }
}


/*----------------------------------------------------------------------
   FetchImage loads an IMG from local file or from the web.		
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                FetchImage (Document doc, Element el)
#else  /* __STDC__ */
void                FetchImage (doc, el)
Document            doc;
Element             el;

#endif /* __STDC__ */
{
   int                 length, i;
   char               *imageName;
   AttributeType       attrType;
   Attribute           attr;
   LoadedImageDesc    *desc;
   char                pathname[MAX_LENGTH];
   char                tempfile[MAX_LENGTH];
   boolean             update;
   boolean             newImage;
   ElemImage          *ctxEl;

   if (el != NULL && DocumentURLs[doc] != NULL)
     {
	/* prepare the attribute to be searched */
	attrType.AttrSSchema = TtaGetDocumentSSchema (doc);
	attrType.AttrTypeNum = HTML_ATTR_SRC;
	attr = TtaGetAttribute (el, attrType);
	if (attr != NULL)
	   /* an element with an attribute SRC has been found */
	  {
	     /* get the attribute value */
	     length = TtaGetTextAttributeLength (attr);
	     if (length > 0)
	       {
		  update = TRUE;
		  /* allocate some memory: length of name + 6 cars for noname */
		  imageName = TtaGetMemory (length + 7);
		  TtaGiveTextAttributeValue (attr, imageName, &length);
		  /* add BASE to image name, if necessary */
		  NormalizeURL (imageName, doc, pathname, imageName);
		  /* is the image already loaded ? */
		  newImage = AddLoadedImage (imageName, pathname, doc, &desc);
		  if (newImage)
		    {
		       /* the current element has to be updated when the image 
		          will be loaded */
		       ctxEl = (ElemImage *) TtaGetMemory (sizeof (ElemImage));
		       desc->elImage = ctxEl;
		       ctxEl->currentElement = el;
		       ctxEl->nextElement = NULL;
		       update = FALSE;	/* the image is not loaded yet */
		       FilesLoading[doc]++;
		       i = GetObjectWWW (doc, pathname, NULL, tempfile, AMAYA_ASYNC, NULL, NULL, (TTcbf *) ImageLoaded, (void *) desc, NO);
		       if (i != HT_ERROR) 
			 desc->status = IMAGE_LOADED;
		       else {
			 update = TRUE;
			 desc->status = IMAGE_NOT_LOADED;
		       }
		    }
		  /* display the image within the document */
		  if (update)
		    {
		       if (desc == NULL)
			  /* it is a local image */
			  DisplayImage (doc, el, pathname);
		       else if (TtaFileExist (desc->localName))
			  DisplayImage (doc, el, desc->localName);
		       else
			 {
			    /* chain this new element as waiting for this image */
			    ctxEl = desc->elImage;
			    if (ctxEl != NULL)
			      {
				 while (ctxEl->nextElement != NULL)
				    ctxEl = ctxEl->nextElement;
				 ctxEl->nextElement = (ElemImage *) TtaGetMemory (sizeof (ElemImage));
				 ctxEl = ctxEl->nextElement;
				 ctxEl->currentElement = el;
				 ctxEl->nextElement = NULL;
			      }
			 }
		    }
		  TtaFreeMemory (imageName);
	       }
	  }
     }
   TtaHandlePendingEvents ();
}

/*----------------------------------------------------------------------
   FetchAndDisplayImages   fetch and display all images referred   
   by document doc.                                        
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                FetchAndDisplayImages (Document doc)
#else  /* __STDC__ */
void                FetchAndDisplayImages (doc)
Document            doc;

#endif /* __STDC__ */
{
   AttributeType       attrType;
   Attribute           attr;
   Element             el, elFound;
   ElementType         elType;

   /* JK: verify if StopTransfer was previously called */
   if (FilesLoading[doc] == 0)
     {
	/* transfer interrupted */
	TtaSetStatus (doc, 1, TtaGetMessage (AMAYA, AM_LOAD_ABORT), NULL);
	return;
     }

   /* get the root element */
   el = TtaGetMainRoot (doc);
   /* prepare the type of element to be searched */
   elType = TtaGetElementType (el);
   /* prepare the attribute to be searched */
   attrType.AttrSSchema = elType.ElSSchema;
   attrType.AttrTypeNum = HTML_ATTR_SRC;
   /* We are currently fetching images for this document */
   /* during this time LoadImage has not to stop transfer */
   FilesLoading[doc]++;
   /* search all elements having an attribute SRC */
   do
     {
	TtaHandlePendingEvents ();
	/* verify if StopTransfer is called */
	if (FilesLoading[doc] == 0)
	   return;
	/* search the next element having an attribute SRC */
	TtaSearchAttribute (attrType, SearchForward, el, &elFound, &attr);
	el = elFound;
	/* FetchImage increments FilesLoading[doc] for each new get request */
	FetchImage (doc, el);
     }
   while (el != NULL);

   /* Images fetching is now finished */
   FilesLoading[doc]--;
   if (FilesLoading[doc] < 2)
      /* all images are loaded in the current document */
      ResetStop (doc);
}
