/*
 *
 *  (c) COPYRIGHT INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/* Module indcree.c */
/* gestion des commandes et creation des marques */

#include "thot_gui.h"
#include "thot_sys.h"
#include "constmedia.h"
#include "typemedia.h"
#include "libmsg.h"
#include "indmsg.h"
#include "message.h"
#include "language.h"
#include "constind.h"
#include "typeind.h"

#undef THOT_EXPORT
#define THOT_EXPORT extern
#include "index_tv.h"

/* VARIABLES */
/* les variables du correcteur */
#undef THOT_EXPORT
#define THOT_EXPORT extern

/* ------------------* PROCEDURES EXTERNES *----------------------------- */
/* procedures importees de l'editeur */
#include "tree_f.h"
#include "attributes_f.h"
#include "search_f.h"
#include "config_f.h"
#include "structcreation_f.h"
#include "views_f.h"
#include "exceptions_f.h"
#include "indcree_f.h"
#include "indmenu_f.h"
#include "indpres_f.h"
#include "indtable_f.h"
#include "indtri_f.h"
#include "structmodif_f.h"
#include "changeabsbox_f.h"
#include "word_f.h"
#include "memory_f.h"
#include "boxparams_f.h"
#include "references_f.h"
#include "schemas_f.h"
#include "structselect_f.h"
#include "structschema_f.h"
#include "content_f.h"
#include "applicationapi_f.h"

/*----------------------------------------------------------------------
   alloue les tableaux necessaires pour le tri (num x pTabTri)          
   et retourne le pointeur sur TabTri                                   
  ----------------------------------------------------------------------*/
PtrTabTri           Ind_InitTabTri ()
{
   PtrTabTri           pEntree;
   int                 j;

   pEntree = (PtrTabTri) TtaGetMemory (sizeof (Tab_tri));
   /* initialisation d'une entree dans tab_tri */
   if (pEntree != NULL)
     {
	for (j = 0; j <= MaxNiveau; j++)
	   pEntree->cle[j][0] = '\0';
	pEntree->pres = 0;
	pEntree->page = -1;
	pEntree->pagefin = -1;
	pEntree->note = 0;
	pEntree->homo = 0;
	pEntree->refdesc = NULL;
	pEntree->doc = NULL;
	pEntree->refmarque = NULL;
     }
   return (pEntree);

}				/* end of proc Ind_InitTabTri */


/*----------------------------------------------------------------------
   Act_TestLoadExtension                                          
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 Act_TestLoadExtension (PtrDocument pDoc, Name NameS, Name NameP)
#else  /* __STDC__ */
int                 Act_TestLoadExtension (pDoc, NameS, NameP)
PtrDocument         pDoc;
Name                NameS;
Name                NameP;

#endif /* __STDC__ */
{
   PtrSSchema          Extension;

   /* verifier si le schema des extensions est deja charge */
   if (TtaGetSchemaExtension (IdentDocument (pDoc), NameS) == NULL)
     {
	Extension = LoadExtension (NameS, NameP, pDoc);
	if (Extension == NULL)
	  {
	     /* message signalant que cette action est inchargeable */
	     TtaDisplaySimpleMessage (INFO, INDEX, INDEX_NO_EXTENSION);
	     return (-1);	/* impossible de charger ces extensions */
	  }
	else
	  {
	     /* message signalant que cette action est "chargee" */
	     TtaDisplaySimpleMessage (INFO, INDEX, INDEX_EXTENSION);
	     return (1);
	  }
     }
   else
      return (0);
}				/* end of Act_TestLoadExtension */


/*----------------------------------------------------------------------
   Ind_RemplirDesc                                                
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         Ind_RemplirDesc (PtrElement pEl,
				     PtrDocument pDoc, char *valcle)
#else  /* __STDC__ */
static void         Ind_RemplirDesc (pEl, pDoc, valcle)
PtrElement          pEl;
PtrDocument         pDoc;
char               *valcle;

#endif /* __STDC__ */
{

   PtrSSchema          pSS;
   PtrElement          pC, pElCle, pE1, pEN;
   PtrTextBuffer       pBu1;
   char                motcle[MAX_WORD_LEN];
   char                mottemp[MAX_CHAR];
   int                 lgmot;
   int                 icar1, icarN;
   boolean             ok;

   pSS = pEl->ElStructSchema;	/* schema de structure de l'element associe */
   /* trouver le champ Cle (premiere Cle de la liste Cles) */
   pC = pEl->ElFirstChild->ElFirstChild->ElFirstChild;
   ok = GetCurrentSelection (&pDoc, &pE1, &pEN, &icar1, &icarN);
   if (valcle == NULL && TypeHasException (1214, pE1->ElTypeNumber, pSS))
      /* un descripteur est selectionne' => ne pas initialiser la cle */
     {
	;
     }
   else
     {
	/* pElCle pointeur sur un element FillContent a initialiser par un texte */
	pElCle = NewSubtree (ord (CharString) + 1, pSS, pDoc, pEl->ElAssocNum,
			     TRUE, TRUE, TRUE, TRUE);
	InsertOption (pC, &pElCle, pDoc);	/* inserer la feuille de texte */
	if (TypeHasException (1221, pC->ElParent->ElTypeNumber, pSS))
	  {
	     pElCle->ElTerminal = TRUE;
	     pElCle->ElVolume = 0;
	     CreateTextBuffer (pElCle);		/* creation d'un buffer pour element texte */
	     if (valcle == NULL)
	       {
		  /* le premier mot de la selection courante devient la cle */
		  if (icar1 > 0)
		     icar1--;
		  SearchNextWord (&pE1, &icar1, mottemp, NULL);
		  strcpy (motcle, mottemp);
		  if (pE1 != NULL)
		     /* recopier la langue de cette cle dans la feuille texte */
		     pElCle->ElLanguage = pE1->ElLanguage;
	       }
	     else
		strcpy (motcle, valcle);
	     /* on laisse la langue heritee */
	     if (motcle[0] != '\0')
	       {
		  /* copie la valeur de la cle */
		  pBu1 = pElCle->ElText;
		  lgmot = strlen (motcle);
		  strncpy (pBu1->BuContent, motcle, lgmot);
		  pBu1->BuContent[lgmot] = '\0';
		  pElCle->ElTextLength = lgmot;
		  pElCle->ElVolume = pElCle->ElTextLength;
		  pElCle->ElText->BuLength = lgmot;
		  /* ajoute le volume de l'element a celui de ses ascendants */
		  if (pElCle->ElVolume != 0)
		    {
		       pE1 = pElCle->ElParent;
		       while (pE1 != NULL)
			 {
			    pE1->ElVolume = pE1->ElVolume + pElCle->ElVolume;
			    pE1 = pE1->ElParent;
			 }
		    }
	       }		/* end   if motcle[0] != '\0'  */
	  }			/* end of if ExceptType 1221 */

	/* Initialiser les autres champs par defaut */
	pC = pEl->ElFirstChild->ElFirstChild->ElNext;	/* champ Sujet */
	/* ce champ est facultatif !! => (NULL) */
	if (pC != NULL)
	  {
	     if (TypeHasException (1222, pC->ElTypeNumber, pSS))
	       {
		  pC = pC->ElFirstChild;	/* la feuille TEXT */
		  pC->ElTerminal = TRUE;
		  pC->ElVolume = 0;
		  CreateTextBuffer (pC);	/* creation d'un buffer pour element texte */
		  /* initialiser Valeur = */
		  lgmot = 1;
		  pBu1 = pC->ElText;
		  pBu1->BuContent[0] = '=';	/* initialisation par defaut ??? */
		  pBu1->BuContent[1] = '\0';
		  pC->ElTextLength = lgmot;
		  pC->ElVolume = pC->ElTextLength;
		  pC->ElText->BuLength = lgmot;
		  /* ajoute le volume de l'element a celui de ses ascendants */
		  if (pC->ElVolume != 0)
		    {
		       pE1 = pC->ElParent;
		       while (pE1 != NULL)
			 {
			    pE1->ElVolume = pE1->ElVolume + pC->ElVolume;
			    pE1 = pE1->ElParent;
			 }	/* end of while */
		    }		/* end of if */
	       }		/* end of if */
	  }			/* end of if */
     }				/* end of if */
   /* creer les paves et les afficher */
   CreateAllAbsBoxesOfEl (pEl, pDoc);
   AbstractImageUpdated (pDoc);
   RedisplayDocViews (pDoc);

}				/* end of Ind_RemplirDesc */


/*----------------------------------------------------------------------
   Ind_NumMarque                                                  
   la marque vient d'etre creee on ajoute l'attribut NumeroMarque    
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                Ind_NumMarque (PtrElement pEl, PtrDocument pDoc)
#else  /* __STDC__ */
void                Ind_NumMarque (pEl, pDoc)
PtrElement          pEl;
PtrDocument         pDoc;

#endif /* __STDC__ */
{

   PtrAttribute        pAt1;

   /* mettre  l'attribut NumeroMarque sur Marque_Index */
   pDoc->DocMaxPairIdent++;
   pAt1 = AttachAttrByExceptNum (1206, pEl, NULL, pDoc);
   pAt1->AeAttrValue = pDoc->DocMaxPairIdent;

}				/*Ind_NumMarque */


/*----------------------------------------------------------------------
   Ind_LieDesc                                                     
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         Ind_LieDesc (PtrElement pEl, PtrDocument pDoc)
#else  /* __STDC__ */
static void         Ind_LieDesc (pEl, pDoc)
PtrElement          pEl;
PtrDocument         pDoc;

#endif /* __STDC__ */
{

   PtrSSchema          pSS;
   PtrElement          pDesc;
   int                 TypeDesc;
   PtrAttribute        pAt1;
   TtAttribute        *pRegleAttr;
   boolean             attrok;
   int                 X, Y, W, H, vue, attr;

   pSS = pEl->ElStructSchema;
   /* verifier s'il existe deja des elements associes Descripteur */
   TypeDesc = GetElemWithException (1214, pSS);
   pDesc = FirstAssociatedElement (pDoc, TypeDesc, pSS);
   /* ouvrir la vue Descripteur si elle est non vide et encore fermee */
   if (pDesc != NULL && pDoc->DocAssocFrame[pDesc->ElAssocNum - 1] == 0)
     {
	ConfigGetViewGeometry (pDoc, "Descripteurs", &X, &Y, &W, &H);
	vue = CreateAbstractImage (pDoc, 0,
				   pDesc->ElParent->ElTypeNumber,
				   pSS, 1, TRUE, NULL);
	OpenCreatedView (pDoc, vue, TRUE, X, Y, W, H);
     }				/* end of if */
   /* creer un attribut reference A_vers_descripteur = NULL */
   pAt1 = AttachAttrByExceptNum (1205, pEl, NULL, pDoc);
   /* remplir cet attribut en designant ou creant un descripteur */
   do
     {
	attr = GetAttrWithException (1205, pSS);
	pRegleAttr = &pSS->SsAttribute[attr - 1];
	TtaDisplayMessage (INFO, TtaGetMessage (LIB, TMSG_VAL_FOR_ATTR_REQUESTED),
			   pRegleAttr->AttrName);
	/* demande a l'utilisateur l'element reference' */
	attrok = LinkReference (pEl, pAt1, pDoc, &pDesc);
     }
   while (!attrok);
   /* creer un attribut reference Vers_marque1 du descripteur vers la marque */
   if (pDesc != NULL)
     {
	pAt1 = AttachAttrByExceptNum (1229, pDesc, NULL, pDoc);
	if (pAt1 != NULL)
	   /* on ne considere pas le cas ou le descripteur et la marque */
	   /* sont dans deux documents differents */
	   if (!SetReference (NULL, pAt1, pEl, pDoc, pDoc, FALSE, TRUE))
	      TtaDisplaySimpleMessage (INFO, LIB,
				       TMSG_DEBUG_LINK_NEW_EL);
	   else if (pDoc->DocAssocFrame[pDesc->ElAssocNum - 1] != 0)
	      /* on met a jour la vue si elle existe deja */
	     {
		ApplyAttrPRulesToElem (pDesc, pDoc, pAt1, FALSE);
		AbstractImageUpdated (pDoc);
		RedisplayDocViews (pDoc);
	     }
     }
   if (pDesc != NULL && pDoc->DocAssocFrame[pDesc->ElAssocNum - 1] == 0)
      /* on peut ouvrir la fenetre Descripteurs maintenant */
     {
	ConfigGetViewGeometry (pDoc, "Descripteurs", &X, &Y, &W, &H);
	vue = CreateAbstractImage (pDoc, 0,
				   pDesc->ElParent->ElTypeNumber,
				   pSS, 1, TRUE, NULL);
	OpenCreatedView (pDoc, vue, TRUE, X, Y, W, H);
     }				/* end of if */

}				/* end of Ind_LieDesc */


/*----------------------------------------------------------------------
   Ind_delmark (pEl, pDoc)                                     
   supprime la paire de marques dont pEL est le premier element       
   retourne TRUE si la suppression est effectuee                      
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static boolean      Ind_delmark (PtrElement pEl, PtrDocument pDoc)
#else  /* __STDC__ */
static boolean      Ind_delmark (pEl, pDoc)
PtrElement          pEl;
PtrDocument         pDoc;

#endif /* __STDC__ */
{

   PtrElement          pMarqueFin;
   boolean             ok = FALSE;

   pMarqueFin = GetOtherPairedElement (pEl);
   if (pMarqueFin != NULL)
     {
	/* supprimer la marque fin */
	DestroyAbsBoxes (pMarqueFin, pDoc, FALSE);
	AbstractImageUpdated (pDoc);
	DeleteElement (&pMarqueFin);
	/* supprimer la marque debut */
	DestroyAbsBoxes (pEl, pDoc, FALSE);
	AbstractImageUpdated (pDoc);
	DeleteElement (&pEl);
	ok = TRUE;
     }
   return (ok);

}				/* end of Ind_delmark */


/*----------------------------------------------------------------------
   Ind_LibMarque supprime toutes les marques d'index du sous-arbre pEl
   si verif = TRUE : ne supprime que les marques sans descripteur     
   retourne un pointeur sur l'element restant (sans marques)          
  ----------------------------------------------------------------------*/
#ifdef __STDC__
PtrElement          Ind_LibMarque (PtrElement pEl, PtrDocument pDoc,
				   boolean verif, int *nbmarque)
#else  /* __STDC__ */
PtrElement          Ind_LibMarque (pEl, pDoc, verif, nbmarque)
PtrElement          pEl;
PtrDocument         pDoc;
boolean             verif;
int                *nbmarque;

#endif /* __STDC__ */
{

   PtrElement          pEl1, pSuiv, pDetr;
   int                 TypeMarque;
   PtrSSchema          pSS;
   int                 nbmk = 0;

   pEl1 = pEl;
   *nbmarque = 0;
   /* chercher le schema des extensions ExtIndex de pDoc */
   pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDoc), "ExtIndex");
   if (pSS == NULL)
      return (pEl);
   TypeMarque = GetElemWithException (1203, pSS);
   if (TypeMarque == 0)
      return (pEl);
   while (pEl1 != NULL)
     {
	/* attention: les marques peuvent etre ds un autre document */
	if (pEl1->ElTypeNumber == TypeMarque
	    && pEl1->ElStructSchema->SsCode == pSS->SsCode)
	  {
	     /* c'est une marque */
	     pDetr = pEl1;
	     pSuiv = pEl1->ElNext;
	     if (pDetr == pEl)
		/* positionner la variable de retour */
		pEl = pDetr->ElNext;
	     if (!verif || Ind_TrouveDesc (pDetr) == NULL)
	       {
		  if (Ind_delmark (pDetr, pDoc))
		     nbmk += 1;
	       }
	     pEl1 = pSuiv;
	  }			/* end of if */
	else
	   /* cherche les marques */
	   /* contenues dans l'element */
	  {
	     pSuiv = pEl1;
	     pDetr = FwdSearchTypedElem (pSuiv, TypeMarque, pSS);
	     if (pDetr != NULL)
		/* on trouve' une marque */
		/* cherche l'element a traiter ensuite */
	       {
		  pSuiv = pDetr->ElNext;
		  if (pSuiv == NULL)
		     /* pas de frere suivant, on prend l'englobant */
		     pSuiv = pDetr->ElParent;
		  /* supprime la marque */
		  if (!verif || Ind_TrouveDesc (pDetr) == NULL)
		    {
		       if (Ind_delmark (pDetr, pDoc))
			  nbmk += 1;
		    }
	       }		/* end if if */
	     else
		pSuiv = NULL;
	     pEl1 = pSuiv;
	  }			/* end of else */
     }				/* end of while */
   *nbmarque = nbmk;
   return (pEl);

}				/* end of Ind_LibMarque */


/*----------------------------------------------------------------------
   Ind_deldesc                                                     
   retourne TRUE si cet element est un descripteur supprime'     
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static boolean      Ind_deldesc (PtrElement pEl, PtrDocument pDoc)
#else  /* __STDC__ */
static boolean      Ind_deldesc (pEl, pDoc)
PtrElement          pEl;
PtrDocument         pDoc;

#endif /* __STDC__ */
{

   PtrElement          pDescSuiv;
   boolean             ok = FALSE;

   if (TypeHasException (1214, pEl->ElTypeNumber, pEl->ElStructSchema))
     {
	/* verifier si ce descripteur est lie a une paire de marques */
	if (Ind_marquesuivante (pEl, NULL) == NULL)
	  {
	     /* supprimer le descripteur */
	     pDescSuiv = NextElement (pEl);
	     DestroyAbsBoxes (pEl, pDoc, FALSE);
	     AbstractImageUpdated (pDoc);
	     DeleteElement (&pEl);
	     if (pDescSuiv != NULL)
		/* renumeroterer les Descripteurs qui suivent */
		UpdateNumbers (pDescSuiv, pDescSuiv->ElParent, pDoc, TRUE);
	     AbstractImageUpdated (pDoc);
	     RedisplayDocViews (pDoc);
	     ok = TRUE;
	  }			/* end of if */
     }				/* end of if */
   return (ok);

}				/* end of proc Ind_deldesc */


/*----------------------------------------------------------------------
   Ind_SupDesc                                                     
   retourne le nombre de Descripteurs supprimes                  
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 Ind_SupDesc (PtrDocument pDoc)
#else  /* __STDC__ */
int                 Ind_SupDesc (pDoc)
PtrDocument         pDoc;

#endif /* __STDC__ */
{
   PtrElement          pDesc, pSuiv;
   PtrSSchema          pSS;
   int                 TypeDesc;
   int                 nbdesc = 0;

   /* chercher le schema des extensions ExtIndex */
   pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDoc), "ExtIndex");
   /* verifier s'il existe deja des elements associes Descripteur */
   TypeDesc = GetElemWithException (1214, pSS);
   pDesc = FirstAssociatedElement (pDoc, TypeDesc, pSS);
   /* rechercher tous les descripteurs du document */
   while (pDesc != NULL)
     {
	pSuiv = pDesc->ElNext;
	/* ne supprimer que les descripteurs inutilises */
	if (Ind_deldesc (pDesc, pDoc))
	   nbdesc++;
	pDesc = pSuiv;
     }				/* end of while */
   return (nbdesc);

}				/* end of proc Ind_SupDesc */


/*----------------------------------------------------------------------
   Ind_SupMarque                                                   
   retourne le nombre de Paires de Marques supprimees            
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 Ind_SupMarque (PtrDocument pDoc)
#else  /* __STDC__ */
int                 Ind_SupMarque (pDoc)
PtrDocument         pDoc;

#endif /* __STDC__ */
{

   PtrElement          pEl, pEl1;
   int                 i, j, nbmk;

   nbmk = 0;
   i = 0;
   /* commencer par la racine du document */
   pEl = pDoc->DocRootElement;
   while (pEl != NULL)
     {
	pEl1 = Ind_LibMarque (pEl, pDoc, TRUE, &j);
	nbmk += j;
	i++;
	/* chercher des marques dans l'arbre associe suivant */
	pEl = pDoc->DocAssocRoot[i];
     }				/* end of while */
   return (nbmk);

}				/* end of proc Ind_SupMarque */


/*----------------------------------------------------------------------
   Ind_dansdoc                                                       
   verifie si lelement pEl est dans le document pDoc              
   (racine ou arbre associe)                                      
   retourne 1 si pEl est dans pDoc et 0 sinon                      
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 Ind_dansdoc (PtrElement pEl, PtrDocument pDoc)
#else  /* __STDC__ */
int                 Ind_dansdoc (pEl, pDoc)
PtrElement          pEl;
PtrDocument         pDoc;

#endif /* __STDC__ */

{
   PtrElement          pAsc, pEl1;
   int                 assoc;
   int                 ret;

   ret = 0;
   if (IsASavedElement (pEl) == 0)
     {				/* pEl n'est pas dans le tampon */
	/* est-il dans le document courant pDoc ? */
	/* pAsc = la racine de l'arbre principal */
	pAsc = pDoc->DocRootElement;
	/* pEl1 = la racine de l'element pEl */
	pEl1 = pEl;
	while (pEl1->ElParent != NULL)
	   pEl1 = pEl1->ElParent;
	if (pEl1 == pAsc)
	   ret = 1;
	else
	  {
	     for (assoc = 0; (assoc < MAX_ASSOC_DOC) && (ret == 0); assoc++)
		if (pDoc->DocAssocRoot[assoc] == pEl1)
		   ret = 1;
	  }
     }
   return (ret);
}				/* end proc Ind_dansdoc */


/*----------------------------------------------------------------------
   Ind_TrouveRef                                                  
   trouve la ref A_vers_descripteur portee par la marque             
  ----------------------------------------------------------------------*/
#ifdef __STDC__
PtrAttribute        Ind_TrouveRef (PtrElement pEl)
#else  /* __STDC__ */
PtrAttribute        Ind_TrouveRef (pEl)
PtrElement          pEl;

#endif /* __STDC__ */
{
   PtrSSchema          pSS;
   PtrAttribute        pAt1;
   int                 attr;
   boolean             attr1trouve;

   pSS = pEl->ElStructSchema;
   /* retrouver l'attribut Vers_descripteur */
   attr = GetAttrWithException (1205, pSS);
   pAt1 = pEl->ElFirstAttr;
   attr1trouve = FALSE;
   while (!attr1trouve && pAt1 != NULL)
     {
	if (pAt1->AeAttrNum == attr)
	   attr1trouve = TRUE;
	else
	   pAt1 = pAt1->AeNext;
     }
   return (pAt1);

}				/* end proc Ind_TrouveRef */


/*----------------------------------------------------------------------
   Ind_TrouveDesc                                                 
   trouve le descripteur associe a la marque debut                   
  ----------------------------------------------------------------------*/
#ifdef __STDC__
PtrElement          Ind_TrouveDesc (PtrElement pEl)
#else  /* __STDC__ */
PtrElement          Ind_TrouveDesc (pEl)
PtrElement          pEl;

#endif /* __STDC__ */
{

   PtrDocument         docsel;
   PtrAttribute        pAt1;
   DocumentIdentifier  NomDoc;
   PtrElement          pDesc = NULL;

   pAt1 = Ind_TrouveRef (pEl);
   if (pAt1 != NULL)
      pDesc = ReferredElement (pAt1->AeAttrReference, &NomDoc, &docsel);
   return (pDesc);

}				/* end proc Ind_TrouveDesc */


/*----------------------------------------------------------------------
   Ind_VerifMarque  verifie si les marques contenues dans le ss-arbre 
   proviennent du document dans lequel a lieu le collage          
   si ce n'est pas le cas, supprime toutes les marques d'index    
   du sous-arbre                                                  
   si c'est le cas, attribue un nouveau numero aux marques        
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                Ind_VerifMarque (PtrElement * pEl, PtrDocument pDoc)
#else  /* __STDC__ */
void                Ind_VerifMarque (pEl, pDoc)
PtrElement          pEl;
PtrDocument         pDoc;

#endif /* __STDC__ */

{
   PtrElement          pSousArbre, pMarq, pDesc, pEl1, pSuiv;
   int                 TypeMarque;
   PtrSSchema          pSS;
   PtrAttribute        pAttr;
   boolean             attrtrouve;
   int                 i, attr;

   /* chercher le schema des extensions ExtIndex */
   pEl1 = *pEl;
   pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDoc), "ExtIndex");
   if (pSS == NULL)
      return;
   TypeMarque = GetElemWithException (1203, pSS);
   if (TypeMarque != 0)
     {
	if (pEl1->ElTypeNumber == TypeMarque
	    && pEl1->ElStructSchema->SsCode == pSS->SsCode)
	   /* c'est une marque */
	   pMarq = pEl1;
	else
	   pMarq = FwdSearchTypedElem (pEl1, TypeMarque, pSS);
	if (pMarq != NULL)
	  {
	     /* on a trouve' une marque dans ce sous-arbre */
	     /* appartenait-elle a ce document ? */
	     pDesc = Ind_TrouveDesc (pMarq);
	     if ((pDesc != NULL && Ind_dansdoc (pDesc, pDoc) == 0)
		 || (pDesc == NULL))
	       {
		  /* supprimer les marques contenues dans le sous-arbre */
		  pSousArbre = Ind_LibMarque (pEl1, pDoc, FALSE, &i);
		  /* retourner la racine du sous-arbre restant */
		  pEl = &pSousArbre;
		  return;
	       }
	     else
	       {
		  /* RENUMEROTER toutes les marques contenues ds pEl1 */
		  while (pEl1 != NULL)
		    {
		       if (pEl1->ElTypeNumber == TypeMarque
			   && pEl1->ElStructSchema->SsCode == pSS->SsCode)
			 {
			    /* c'est une marque => modifier son numero */
			    attr = (int) GetAttrWithException (1206, pSS);
			    pAttr = pEl1->ElFirstAttr;
			    /* parcours les atributs de l'element */
			    attrtrouve = FALSE;
			    while (!attrtrouve && pAttr != NULL)
			       if (pAttr->AeAttrNum == attr
				   && pAttr->AeAttrSSchema == pSS)
				  attrtrouve = TRUE;
			       else
				  pAttr = pAttr->AeNext;
			    if (attrtrouve)
			      {
				 /* modifier l'attribut */
				 pDoc->DocMaxPairIdent++;
				 pAttr->AeAttrValue = pDoc->DocMaxPairIdent;
			      }
			 }	/* end of if */
		       else
			 {
			    /* cherche les marques contenues dans l'element */
			    pEl1 = FwdSearchTypedElem (pEl1, TypeMarque, pSS);
			    if (pEl1 != NULL)
			      {
				 /* c'est une marque => modifier son numero */
				 attr = (int) GetAttrWithException (1206, pSS);
				 pAttr = pEl1->ElFirstAttr;
				 attrtrouve = FALSE;
				 while (!attrtrouve && pAttr != NULL)
				    if (pAttr->AeAttrNum == attr
					&& pAttr->AeAttrSSchema == pSS)
				       attrtrouve = TRUE;
				    else
				       pAttr = pAttr->AeNext;
				 if (attrtrouve)
				   {
				      /* modifier l'attribut */
				      pDoc->DocMaxPairIdent++;
				      pAttr->AeAttrValue = pDoc->DocMaxPairIdent;
				   }
			      }	/* end of if */
			 }	/* end of else */
		       if (pEl1 != NULL)
			 {
			    /* passer au suivant */
			    pSuiv = pEl1->ElNext;
			    if (pSuiv == NULL)
			       /* pas de frere suivant, on prend l'englobant */
			       pSuiv = pEl1->ElParent;
			 }	/* end of if */
		       else
			  pSuiv = NULL;
		       pEl1 = pSuiv;
		    }		/* end of while */
	       }		/* end of else */
	  }			/*end of if */
     }				/*end of if */
   return;
}				/* end of Ind_VerifMarque */


/*----------------------------------------------------------------------
   Ind_AjouterDesc (pDesc, pPrec, pDoc)                           
   replacer le descripteur pDesc apres le descripteur pPrec         
   retourne la nouvelle valeur du pointeur de descripteur           
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         Ind_AjouterDesc (PtrElement pDesc,
				     PtrElement pPrec,
				     PtrDocument pDoc)
#else  /* __STDC__ */
static void         Ind_AjouterDesc (pDesc, pPrec, pDoc)
PtrElement          pDesc;
PtrElement          pPrec;
PtrDocument         pDoc;

#endif /* __STDC__ */
{

   PtrSSchema          pSS;
   PtrElement          pElFirst;
   int                 C_PIV_TYPE;

   /* effacer les paves de l'ancien descripteur */
   DestroyAbsBoxes (pDesc, pDoc, FALSE);
   AbstractImageUpdated (pDoc);
   /* recopier le contenu du descripteur */
   RemoveElement (pDesc);
   if (pPrec == NULL)
     {
	/* chercher le schema des extensions ExtIndex */
	pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDoc), "ExtIndex");
	/* retrouver le premier element associe descripteur */
	C_PIV_TYPE = GetElemWithException (1214, pSS);
	pElFirst = FirstAssociatedElement (pDoc, C_PIV_TYPE, pSS);
	if (pElFirst == NULL)
	  {
	     /* creer un element associe Descripteur */
	     pElFirst = CreateFirstAssocElement (pDoc, C_PIV_TYPE, pSS);
	     InsertFirstChild (pElFirst->ElParent, pDesc);
	     DeleteElement (&pElFirst);
	  }
	else
	   /* placer ce descripteur en premier */
	   InsertFirstChild (pElFirst->ElParent, pDesc);
     }
   else
      InsertElementAfter (pPrec, pDesc);

   /* creer et afficher les nouveaux paves de ce descripteur */
   CreateAllAbsBoxesOfEl (pDesc, pDoc);
   AbstractImageUpdated (pDoc);
   RedisplayDocViews (pDoc);

}				/* end of Ind_AjouterDesc */


/*----------------------------------------------------------------------
   Ind_PlacerDesc (pMarque, pDesc, pSel, pDoc)                    
   replacer le descripteur pDesc associe a la marque pMarque        
   au bon endroit dans la liste des descripteurs                    
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static PtrElement   Ind_PlacerDesc (PtrElement pDesc, PtrElement pMarque, PtrElement pSel, PtrDocument pDoc)
#else  /* __STDC__ */
static PtrElement   Ind_PlacerDesc (pDesc, pMarque, pSel, pDoc)
PtrElement          pDesc;
PtrElement          pMarque;
PtrElement          pSel;
PtrDocument         pDoc;

#endif /* __STDC__ */

{
   PtrDocument         docsel;
   PtrSSchema          pSS;
   PtrAttribute        pAt1;
   PtrElement          pElem;
   int                 C_PIV_TYPE;
   int                 attr;
   boolean             attr1trouve;
   DocumentIdentifier  NomDoc;

   /* chercher le schema des extensions ExtIndex */
   pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDoc), "ExtIndex");
   /* rechercher en arriere la marque debut index la plus proche */
   C_PIV_TYPE = GetElemWithException (1203, pSS);
   /* a partir du point d'insertion du collage ??? */
   pElem = BackSearchTypedElem (pSel, C_PIV_TYPE, pSS);
   if (pElem != NULL)
     {
	/* retrouver l'attribut Vers_descripteur */
	attr = GetAttrWithException (1205, pSS);
	pAt1 = pElem->ElFirstAttr;
	attr1trouve = FALSE;
	while (!attr1trouve && pAt1 != NULL)
	  {
	     if (pAt1->AeAttrNum == attr
		 && pAt1->AeAttrSSchema == pSS)
		attr1trouve = TRUE;
	     else
		pAt1 = pAt1->AeNext;
	  }
	/* retrouver le descripteur associe */
	if (attr1trouve)
	  {
	     pElem = ReferredElement (pAt1->AeAttrReference, &NomDoc, &docsel);
	     /* inserer le nouveau desc apres le descripteur trouve' */
	     return (pElem);
	  }
	else			/* normalement n'a jamais lieu !!! */
	   return (NULL);
     }
   else
      return (NULL);
}				/* end of Ind_PlacerDesc */


/*----------------------------------------------------------------------
   Ind_OrdDesc (pEl, pDoc)                                        
   rechercher les descripteurs correspondants aux marques contenues 
   dans la suite des elements pEl qui viennent d'etre colles        
   afin de les replacer dans le bon ordre                            
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                Ind_OrdDesc (PtrElement pEl, PtrElement pSel, PtrDocument pDoc)
#else  /* __STDC__ */
void                Ind_OrdDesc (pEl, pSel, pDoc)
PtrElement          pEl;
PtrElement          pSel;
PtrDocument         pDoc;

#endif /* __STDC__ */

{
   PtrElement          pEl1, pMarq, pMarq2, pSuiv, pDesc, pDescPlace;
   int                 TypeMarque;
   PtrSSchema          pSS;

   pDescPlace = NULL;
   /* chercher le schema des extensions ExtIndex */
   pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDoc), "ExtIndex");
   if (pSS != NULL)
     {
	TypeMarque = GetElemWithException (1203, pSS);
	if (TypeMarque != 0)	/* sinon : ne rien faire */
	  {
	     pEl1 = pEl;
	     while (pEl1 != NULL)
	       {
		  if (pEl1->ElTypeNumber == TypeMarque
		      && pEl1->ElStructSchema == pSS)	/* c'est une marque-debut */
		    {		/* supprimer le descripteur associe */
		       pDesc = Ind_TrouveDesc (pEl1);
		       if (pDesc != NULL)
			 {
			    if (pDescPlace == NULL)
			       /* trouver la place de ce descripteur */
			       pDescPlace = Ind_PlacerDesc (pDesc, pEl, pSel, pDoc);
			    if (pDescPlace == pDesc)
			       pDescPlace = NULL;	/* replace le descripteur en premier */
			    /* placer ce descripteur apres le precedent place' */
			    Ind_AjouterDesc (pDesc, pDescPlace, pDoc);
			    pDescPlace = pDesc;
			    pEl1 = pEl1->ElNext;
			 }
		    }
		  else
		     /* cherche les marques contenues dans l'element */
		    {
		       pMarq = FwdSearchTypedElem (pEl1, TypeMarque, pSS);
		       if (pMarq != NULL)
			  /* on a trouve' une marque */
			 {
			    pSuiv = pMarq->ElNext;
			    if (pSuiv == NULL)
			       /* pas de frere suivant, on prend l'englobant */
			       pSuiv = pMarq->ElParent;
			    pDesc = Ind_TrouveDesc (pMarq);
			    if (pDesc != NULL)
			      {
				 if (pDescPlace == NULL)
				    /* trouver la place de ce descripteur */
				    pDescPlace = Ind_PlacerDesc (pDesc, pEl, pSel, pDoc);
				 /* placer ce descripteur apres le precedent place' */
				 Ind_AjouterDesc (pDesc, pDescPlace, pDoc);
			      }
			    else
			      {	/* ne devrait pas se produire !!! */
				 /* supprimer la paire de marques sans descripteur */
				 pMarq2 = GetOtherPairedElement (pMarq);
				 DeleteElement (&pMarq2);
				 DeleteElement (&pMarq);
			      }
			    pDescPlace = pDesc;
			 }	/* end of if */
		       else
			  pSuiv = NULL;
		       pEl1 = pSuiv;
		    }		/* end of else */
	       }		/* end of while */
	     if (pDescPlace != NULL)
		/* renumeroterer tous les Descripteurs ???? (a ameliorer) */
/**IV-IXA*/ if (pDescPlace->ElParent != NULL)
		   UpdateNumbers (pDescPlace->ElParent->ElFirstChild, pDescPlace->ElParent, pDoc, TRUE);
	  }
     }				/* end of if */
}				/* end of Ind_OrdDesc */


/*----------------------------------------------------------------------
   Ind_TitreDansMenu                                                
  ----------------------------------------------------------------------*/
#ifdef __STDC__
char               *Ind_TitreDansMenu (PtrElement pEl)
#else  /* __STDC__ */
char               *Ind_TitreDansMenu (pEl)
PtrElement          pEl;

#endif /* __STDC__ */
{
   PtrTextBuffer       pBuf;
   PtrElement          pElSuiv, pFeuille, pLast;
   int                 nbcar, lgtitre;

   pLast = NULL;
   if (pEl == NULL || pEl->ElVolume == 0)
      strcpy (TitreMenu, TtaGetMessage (INDEX, ID_Titre));
   else
     {
	/* recopier toutes les feuilles du titre dans TitreMenu */
	pElSuiv = pEl;
	lgtitre = 0;
	do
	  {
	     pFeuille = FirstLeaf (pElSuiv);
	     while (pFeuille != NULL && lgtitre < 80)
	       {
		  pBuf = pFeuille->ElText;
		  pLast = pFeuille;
		  nbcar = ((pFeuille->ElTextLength + lgtitre) <= 80) ?
		     pFeuille->ElTextLength : 80 - lgtitre;
		  if (nbcar != 0)
		    {
		       strncpy ((TitreMenu) + lgtitre, pBuf->BuContent, nbcar);
		       lgtitre += nbcar;
		    }
		  pFeuille = pFeuille->ElNext;
	       }		/* end of while pFeuille */
	     pElSuiv = NextElement (pLast);
	  }
	while (pElSuiv != NULL && ElemIsAnAncestor (pEl, pElSuiv) && lgtitre < 80);
	TitreMenu[lgtitre] = '\0';
     }
   return (TitreMenu);

}				/* end of Ind_TitreDansMenu */


/*----------------------------------------------------------------------
   Ind_Creation                                                    
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                Ind_Creation (PtrElement pEl, PtrDocument pDoc)
#else  /* __STDC__ */
void                Ind_Creation (pEl, pDoc)
PtrElement          pEl;
PtrDocument         pDoc;

#endif /* __STDC__ */
{
   int                 visib, zoom;

   /* Creation d'une marque d'index */
   if (TypeHasException (1203, pEl->ElTypeNumber, pEl->ElStructSchema))
     {
	/* changer la visibilite de la fenetre de la racine */
	GetFrameParams (pDoc->DocViewFrame[0], &visib, &zoom);
	if (visib > 4)
	   SetFrameParams (pDoc->DocViewFrame[0], 1, zoom);
	/* numeroter cette nouvelle marque */
	Ind_NumMarque (pEl, pDoc);
	/* lui associer un descripteur (cree ou existant) */
	Ind_LieDesc (pEl, pDoc);
     }				/* end of if */
   else
     {
	/* Creation d'un nouveau descripteur */
	if (TypeHasException (1214, pEl->ElTypeNumber, pEl->ElStructSchema))
	  {
	     /* remplir ce descripteur (cle = copie de la selection) */
	     Ind_RemplirDesc (pEl, pDoc, NULL);
	  }			/* end of if */

	/* Creation ou modification d'attribut A_Vers_descripteur */
	/* verifier si marque et desc sont ds mme document */
	/* A FAIRE */
/*      
   else
   if (AttrHasException(1205, GetAttributeOfElement, pAttr->ElStructSchema ???))
   .....
 */
     }				/* end of else */

}				/* end of proc Ind_Creation */


/*----------------------------------------------------------------------
   Ind_creerindex      dans pDocu                                    
   retourne nbref si une nouvelle table Index est cree                
   0 si la table est vide                                    
   -1 en cas d'erreur grave                                   
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 Ind_creerindex (int numtable, boolean avec_raz, boolean avec_fusion)
#else  /* __STDC__ */
int                 Ind_creerindex (numtable, avec_raz, avec_fusion)
int                 numtable;
boolean             avec_raz;
boolean             avec_fusion;

#endif /* __STDC__ */
{

   int                 num, nbref, i;

   nbref = 0;
   num = numtable;
   /* initialiser les options de creation de cette table */
   Ind_inittable (num);
   /* c'est parti  */
   TtaDisplayMessage (INFO, TtaGetMessage (INDEX, INDEX_DEBUT_OK), num);
   /* selectionner les bons descripteurs */
   if ((Ind_tousdesc () >= 0) && (Ind_touscroise () >= 0))
     {
	/* Trier la table de numero num */
	nbref = Ind_tri (num);
	if (nbref > 0)		/* ca marche ! */
	  {			/* creer la table d'index */
	     if (Ind_creertable (num, avec_raz) >= 0)	/* initialise pTable */
	       {
		  Ind_remplirtable (avec_fusion);
		  Ind_remplirCR ();	/* ajouter les ref croiseees */
	       }
	     else
	       {		/* creation de table numtable impossible */
		  TtaDisplayMessage (INFO, TtaGetMessage (INDEX, INDEX_NOTABLE), num);
		  return (-1);
	       }
	  }			/* end of if */
     }				/* end of if */
   if (nbref == 0)
     {
	/* cette table est vide */
	TtaDisplayMessage (INFO, TtaGetMessage (INDEX, INDEX_VIDE), num);
     }
   else
     {
	/* liberation des tables allouees pour le TRI */
	for (i = 0; i < nbref; i++)
	  {
	     if (pTri[i] != NULL)
		TtaFreeMemory ((char *) pTri[i]);
	  }
	TtaFreeMemory ((char *) tab_ind);
     }
   return (nbref);

}				/* end proc Ind_creerindex */


/*----------------------------------------------------------------------
   Ind_NbTable()                                                     
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 Ind_NbTable ()
#else  /* __STDC__ */
int                 Ind_NbTable ()
#endif				/* __STDC__ */
{

   PtrElement          pEl;
   int                 nbtable = 0;

   pEl = Ind_table (1);
   while (pEl != NULL)
     {
	nbtable++;
	pEl = Ind_table (nbtable + 1);
     }				/* end of while */
   return (nbtable);
}				/* end of proc Ind_NbTable */


/*----------------------------------------------------------------------
   Ind_creertoutindex()  dans pDocu                                  
   retourne le nb de tables crees                             
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 Ind_creertoutindex (boolean avec_fusion)
#else  /* __STDC__ */
int                 Ind_creertoutindex (avec_fusion)
boolean             avec_fusion;

#endif /* __STDC__ */
{

   int                 nbtable, i, iret;

   /* compter les tables a construire */
   nbtable = Ind_NbTable ();
   iret = Ind_creerindex (1, TRUE, avec_fusion);
   if (iret > 0)
      i = 1;			/* creation de la premiere table */
   for (i = 2; (i <= nbtable && iret != -1); i++)
      iret = Ind_creerindex (i, FALSE, avec_fusion);
   return (i);

}				/* end of Ind_creertoutindex */


/*----------------------------------------------------------------------
   ActionIndexer                                                   
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                ActionIndexer (int frame)
#else  /* __STDC__ */
void                ActionIndexer (frame)
int                 frame;

#endif /* __STDC__ */
{

   int                 Vue;
   boolean             Assoc;
   Name                extension;
   PtrDocument         pDoc;

   GetDocAndView (frame, &pDoc, &Vue, &Assoc);
   /* initialiser pDocu */
   pDocu = pDoc;
   if (pDoc != NULL)
     {
	/* verifier si ce document possede les extensions Index */
	/* s'il ne la possede pas, alors on essaye de la charger */
#ifdef IV
	strcpy (extension, "ExtIndexP");
	langue = TtaGetDefaultLanguage ();
	/*il faut en fait prendre la langue du document */
	i = (int) langue;
	if (i == 2)
	   strcat (extension, "E");
#endif
	extension[0] = '\0';
	if (Act_TestLoadExtension (pDoc, "ExtIndex", extension) >= 0)
	   Indexer (pDoc);
     }
}				/* end proc ActionIndexer */
