/*
 * m-query.c : Query menu routines
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 */

#include <X11/Intrinsic.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/StringDefs.h>
#include "xarchie.h"
#include "menu.h"

/*
 * Functions defined here:
 */
void initQueryMenu();
static void queryMenuCallback();

/*
 * Data defined here:
 */
static Widget queryMenu;

/*	-	-	-	-	-	-	-	-	*/

void
initQueryMenu()
{
    queryMenu = createMenu("queryMenu","queryMenuItem",3,NULL,
			   queryMenuCallback);
}

/* Callback procedure */

/*ARGSUSED*/
static void
queryMenuCallback(w,client_data,call_data)
Widget w;
XtPointer client_data;	/* item */
XtPointer call_data;	/* ignored */
{
    int item = (int)client_data;

    switch (item) {
	case 0: /* Query term */
	    XtCallActionProc(toplevel,"query",NULL,NULL,0);
	    break;
	case 1: /* Query host */
	    XtCallActionProc(toplevel,"query-host",NULL,NULL,0);
	    break;
	case 2: /* Query location */
	    XtCallActionProc(toplevel,"query-location",NULL,NULL,0);
	    break;
    }
}
