// -*- C++ -*-
/* This file is part of*
* ======================================================
*
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 Matthias Ettrich
*
*======================================================*/
#ifndef _INSET_H
#define _INSET_H

#include "lyxinset.h"
#include "lyxfont.h"
#include "xdefinitions.h"

/* Quotes. Used for the various quotes. German, English, French, all either
 * double or single */ 

class InsetQuotes: public Inset {
private:
  char* contents;
  char* kind;
   
  void ParseString(char* string);
   
public:
  ~InsetQuotes();
   
  /* the construktor works like this:
   * 
   * fls <- french single quote left 
   * grd <- german double quote right 
   * 
   * etc. */ 
   
  InsetQuotes(char* string);
  InsetQuotes();
  int Ascent(LyXFont font);
  int Descent(LyXFont font);
  int Width(LyXFont font);
  void Draw(LyXFont font, unsigned long  pm, int baseline, float &x);
  LyXFont ConvertFont(LyXFont font);
  void Write(FILE *file);
  void Read(FILE *file);
  int Latex(FILE *file, char fragile);
  Inset* Clone();
  char LyxCode();
};




/* Latex. Used to insert LaTeX-Code automatically */

class InsetLatex: public Inset {
private:
  char* contents;
public:
  ~InsetLatex();
   
  InsetLatex(char* string);
  InsetLatex();
  int Ascent(LyXFont font);
  int Descent(LyXFont font);
  int Width(LyXFont font);
  void Draw(LyXFont font, unsigned long  pm, int baseline, float &x);
  void Write(FILE *file);
  void Read(FILE *file);
  int Latex(FILE *file, char fragile);
  char Deletable();
  Inset* Clone();
  char LyxCode();
};



/* FormulaLatex. Used to insert FormulaLatex-Code automatically */

class InsetFormulaLatex: public Inset {
private:
  char* contents;
   
public:
  ~InsetFormulaLatex();
  
  InsetFormulaLatex(char* string);
  InsetFormulaLatex();
  int Ascent(LyXFont font);
  int Descent(LyXFont font);
  int Width(LyXFont font);
  void Draw(LyXFont font, unsigned long  pm, int baseline, float &x);
  LyXFont ConvertFont(LyXFont font);
  void Write(FILE *file);
  void Read(FILE *file);
  int Latex(FILE *file, char fragile);
  char  Deletable();
  Inset* Clone(); 
};

/* FormulaLatexDel. Used to insert deletable FormulaLatex-Code automatically */

class InsetFormulaLatexDel: public Inset {
private:
  char* contents;
   
public:
  ~InsetFormulaLatexDel();
   
  InsetFormulaLatexDel(char* string);
  InsetFormulaLatexDel();
  int Ascent(LyXFont font);
  int Descent(LyXFont font);
  int Width(LyXFont font);
  void Draw(LyXFont font, unsigned long  pm, int baseline, float &x);
  LyXFont ConvertFont(LyXFont font);
  void Write(FILE *file);
  void Read(FILE *file);
  int Latex(FILE *file, char fragile);
  char  Deletable();
  Inset* Clone();
};

class InsetLatexDel: public Inset {
private:
  char* contents;
public:
  ~InsetLatexDel();
   
  InsetLatexDel(const char* string);
  InsetLatexDel();
  int Ascent(LyXFont font);
  int Descent(LyXFont font);
  int Width(LyXFont font);
  void Draw(LyXFont font, unsigned long  pm, int baseline, float &x);
  void Write(FILE *file);
  void Read(FILE *file);
  int Latex(FILE *file, char fragile);
  char Deletable();
  Inset* Clone();
  char LyxCode();
};


// used for insertion of accents

class InsetLatexAccent: public Inset {
private:
  char* contents;
  char  candisp;        // can display as proper char
  char  modtype;        // modifier type
  char  remdot;         // remove dot from 'i' and 'j'
  char  plusasc;        // add something to ascent - accent at the top
  char  plusdesc;       // add something to descent - underlined char
  char  ic;             // international char
public:
  ~InsetLatexAccent();
   
  InsetLatexAccent(char* string);
  InsetLatexAccent();
  int Ascent(LyXFont font);
  int Descent(LyXFont font);
  int Width(LyXFont font);
  void Draw(LyXFont font, unsigned long  pm, int baseline, float &x);
  void Write(FILE *file);
  void Read(FILE *file);
  int Latex(FILE *file, char fragile);
  char Deletable();
  char DirectWrite();
  Inset* Clone();
  char LyxCode();
  Bool IsEqual(Inset* other);

private:
  void CheckContents(); // check, whether we can display it good
};



class InsetError: public Inset {
private:
  char* contents;
  static   FL_FORM *form;
  static    FL_OBJECT *strobj;

public:
  ~InsetError();
   
  InsetError(const char* string);
  InsetError();
  int Ascent(LyXFont font);
  int Descent(LyXFont font);
  int Width(LyXFont font);
  void Draw(LyXFont font, unsigned long  pm, int baseline, float &x);
  void Write(FILE *file);
  void Read(FILE *file);
  int Latex(FILE *file, char fragile);
  char AutoDelete();
  void Edit(int, int);
  char Editable();
  Inset* Clone();
};


class InsetInfo: public Inset {
private:
   
public:
  char* contents;
  FL_FORM *form;
  FL_OBJECT *strobj;

  ~InsetInfo();
  void Set(char* string);
  InsetInfo();
  int Ascent(LyXFont font);
  int Descent(LyXFont font);
  int Width(LyXFont font);
  void Draw(LyXFont font, unsigned long  pm, int baseline, float &x);
  void Write(FILE *file);
  void Read(FILE *file);
  int Latex(FILE *file, char fragile);
  void Edit(int, int);
  char Editable();
  char LyxCode();
  Inset* Clone();
};


class InsetLabel: public Inset {
private:
  char* contents;
  char* label;
public:
  ~InsetLabel();
   
  InsetLabel(char* string);
  InsetLabel();
  int Ascent(LyXFont font);
  int Descent(LyXFont font);
  int Width(LyXFont font);
  void Draw(LyXFont font, unsigned long  pm, int baseline, float &x);
  void Write(FILE *file);
  void Read(FILE *file);
  int Latex(FILE *file, char fragile);
  char Deletable();
  Inset* Clone();
  char LyxCode();
  int GetNumberOfLabels();
  const char* GetLabel(int);
};

#endif
