/* ap_match.cc
 *$Header: /al/acs/src/RCS/ap_match.cc,v 9.4 95/05/27 01:17:31 al Exp $
 * string compare
 * compares characters until end of first string
 * any non-alpha character is a terminator
 * returns offset into string to legal start of next token
 * (skips trailing spaces and comma, if any)
 *     if they match so far, and enough matched,   else NO (0)
 * Characters in reference string in UPPER case must match.
 * Always requires at least one character to match.
 */
#include "ap.h"
#ifndef YES
#define YES (1)
#endif
#ifndef NO
#define NO (0)
#endif
/*--------------------------------------------------------------------------*/
//	int	CS::pmatch(const char*);
	int	pmatch(const char*,const char*);
	int	wmatch(const char*,const char*);
/*--------------------------------------------------------------------------*/
static inline char to_lower(char c){return ((isupper(c))?tolower(c):c);}
static inline int is_alpha(int c){return isalpha(toascii(c));}
/*--------------------------------------------------------------------------*/
int CS::pmatch(const char *str2)
{
  int ind;
  cnt += ind = ::pmatch(&cmd[cnt],str2);
  return ind;
}
/*--------------------------------------------------------------------------*/
/* pmatch: match str1 (under test) against str2 (reference)
 * if no match, returns 0
 * if match, returns the number of characters that match,
 *	---including whitespace---
 * return value is usually interpreted as a truth value:
 *	true if match exists.
 * str1 (being tested) is considered to be case-insensitive
 *	is terminated by a non-alpha character
 * str2 (reference) has special considerations:
 *	upper case characters must match, and must be present
 *	lower case characters must match if present, but may be omitted
 * strings are alpha only.
 */
int pmatch (const char *str1, const char *str2)
{
  CS cmd(str1);

  cmd.skipbl();
  while (to_lower(cmd.peek()) == to_lower(*str2)){
    str2++;
    if (!is_alpha(cmd.ctoc()) || (!is_alpha(cmd.peek()) && !isupper(*str2))){
      cmd.skipcom();
      return cmd.index();
    }
  }
  return 0;
}
/*--------------------------------------------------------------------------*/
/* wmatch: string match with wild cards
 * s1 may have wild cards: ? any character matches; * any repeated 0 or more
 * returns YES or NO
 * normally not case sensitive,
 *	but \ before any letter in s1 forces exact match
 * recursive
 */
int wmatch(const char *s2, const char *s1)
{
  for (   ;  (*s1 && *s2) || (*s1=='*');  s1++, s2++){
    if (*s1 == '?'){		    /* '?' matches anything		    */
      ;
    }else if (*s1 == '*'){	    /* '*' matches 0 or more of anything    */
      if (wmatch(s2,s1+1)){	    /* try '*' matches nothing		    */
	return YES;
      }else{			    /* '*' matches at least one character   */
	s1--;			    /* match it, try for more		    */
	if (*s2 == '\0')	    /* there is more in s1.  If this were   */
	  return NO;		    /* all, the recursive call above would  */
      }				    /* have matched.			    */
    }else if (*s1 == '\\'){	    /* '\' requires an exact match	    */
      s1++;			    /* including case			    */
      if (*s1 != *s2)
	return NO;
    }else if (to_lower(*s1) != to_lower(*s2)){
      return NO;		    /* try to match, ignoring case	    */
    }
  }
  return *s1 == *s2;		    /* one of the strings ended		    */
}				    /* if match, both will be '\0'	    */
				    /*	    and return YES, otherwise NO    */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
