#include <stdio.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>
#include <string.h>
#include <signal.h>
#include <limits.h>

#include "suck.h"
#include "config.h"
#include "both.h"
#include "suckutils.h"

/*------------------------------------------------------------------------*/
/* check if directory exists, if not, try to create it.			  */
/* return TRUE if made/exists and can write to it			  */
/* -----------------------------------------------------------------------*/
int checkdir(char *dirname) {
	
	struct stat buf;
	int retval = TRUE;

	if(stat(dirname, &buf)== 0) {
		/* it exists */
		if(!S_ISDIR(buf.st_mode)) {
			error_log(ERRLOG_REPORT, "%s: Not a directory\n", dirname);
			retval = FALSE;
		}
		else if(access(dirname, W_OK) != 0) {
			error_log(ERRLOG_REPORT, "%s: Write permission denied\n", dirname);
			retval = FALSE;
		}
	}
	else if(errno == ENOENT) {
		/* doesn't exist, make it */
		if(mkdir(dirname, (S_IRUSR | S_IWUSR | S_IXUSR)) != 0) {
			MyPerror(dirname);
			retval = FALSE;
		}
	}
	else {
		/* huh? */
		MyPerror(dirname);
		retval = FALSE;
	} 
	return retval;	
}
/*--------------------------------------------------------------*/
/* if which = FP_SET, store directory in array 			*/
/* 	    = FP_GET, retrieve directory and add file name 	*/
/* retval     FP_SET, if valid dir, the dir, else NULL		*/
/*	      FP_GET, full path					*/
/*--------------------------------------------------------------*/
char *full_path(int which, int dir, char *fname) {

	static char dirs[FP_NR_DIRS][_POSIX_PATH_MAX+1] = { N_TMPDIR, N_DATADIR, N_MSGDIR };
	static char path[_POSIX_PATH_MAX+1];	/* static so area valid after return */
	static char postfix[_POSIX_PATH_MAX+1] = { "\0" };

	char *retptr;
	int ok, i;

	retptr = NULL;

	switch(which) { 
	  case FP_GET:
	  case FP_GET_NOPOSTFIX:
		/* put the right directory as the first part of the path */
		strcpy(path, dirs[dir]);
		/* if it contains a dit, then change to full path */
		if(path[0] == '.') {
			path[0] = '\0';
			if(getcwd(path, _POSIX_PATH_MAX) == NULL) {
					MyPerror(path);
					/* restore current path and pray */
					/* it will work later */
					strcpy(path, dirs[dir]);
			}
			else {
				/* tack on remainder of path */
				/* the 1 so skip . */
				strcat(path, &dirs[dir][1]);
			}		
		}
		if(fname != NULL && fname[0] != '\0') {
			i = strlen(path);
			/* if nothing to put on don't do any of this */
			/* put on trailing slant bar if needed */
			if(path[i-1] != '/') {
				path[i++] = '/';
				path[i] = '\0';	/* null terminate it */
			}
			/* finally, put on filename */
			strcpy(&path[i], fname);

			if(which != FP_GET_NOPOSTFIX && postfix[0] != '\0') {
				strcat(path, postfix);
			}
		}
		retptr = path;
		break;
	  case FP_SET_POSTFIX:
		ok = TRUE;
		strncpy(postfix, fname, sizeof(postfix));
		break;
	  case FP_SET:
		ok = TRUE;
		switch(dir) {
		  case FP_TMPDIR:
			if(access(fname, W_OK) == -1) {
				MyPerror(fname);
				ok = FALSE;
			}
			break;
		  case FP_DATADIR:
			if(access(fname, R_OK) == -1) {
				MyPerror(fname);
				ok = FALSE;
			}
			break;
		  case FP_MSGDIR: /* do_nothing, this is checked elsewhere */
			break;
		}
		if(ok == FALSE) {
			retptr = NULL;
		}
		else {
			strncpy(dirs[dir], fname, sizeof(dirs[0]));
			retptr = dirs[dir];
		}
		break;
	}
	return retptr;
}
#ifdef LOCKFILE
/*--------------------------------------------------------------*/
int do_lockfile(void) {

	int retval;
	FILE *f_lock;
	char *lockfile;
	pid_t pid;

	retval = RETVAL_OK;

	lockfile = full_path(FP_GET, FP_TMPDIR, N_LOCKFILE);
	if((f_lock = fopen(lockfile, "r")) != NULL) {
		/* okay, let's try and see if this sucker is truly alive */
		fscanf(f_lock, "%d", &pid);
		fclose(f_lock);
		if(pid <= 0) {
			error_log(ERRLOG_REPORT, "Lock File %s , Invalid PID, aborting.\n", lockfile);
			retval = RETVAL_ERROR;
		}
		/* this next technique borrowed from pppd, sys-linux.c (ppp2.2.0c) */
		/* if the pid doesn't exist (can't send any signal to it), then try */
		/* to remove the stale PID file so can recreate it. */
		else if(kill(pid, 0) == -1 && errno == ESRCH) {
			/* no pid found */
			if(unlink(lockfile) == 0) {
				error_log(ERRLOG_REPORT, "Lock File %s , stale PID %d removed.\n", lockfile, pid);
			}
			else {
				error_log(ERRLOG_REPORT, "Unable to remove Lock File %s , stale PID %d, Aborting.\n", lockfile, pid);
				retval = RETVAL_ERROR;
			}
		}
		else {
			error_log(ERRLOG_REPORT, "Lock File %s , PID %d exists, aborting.\n", lockfile, pid);
			retval = RETVAL_ERROR;
		}
	}
	if(retval == RETVAL_OK) {
		if((f_lock = fopen(lockfile, "w")) != NULL) { 
			fprintf(f_lock, "%d", getpid());
			fclose(f_lock);
		}
		else {
			error_log(ERRLOG_REPORT, "Unable to create lock file %s\n", lockfile);
			retval = RETVAL_ERROR;
		}
	}
	return retval;
}
#endif
