/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 1996 Matthias Ettrich
*           and the LyX Team.
*
*======================================================*/

#include <string.h>
#include <stdlib.h>
#include <forms.h>

#ifndef FL_VERSION
#error LyX will not compile. With this version of XForms. \
       Get at least version 0.80.
#endif
#if FL_VERSION < 0 && FL_REVISION < 80
#error LyX will not compile with this version of XForms. \
       please upgrade to at least 0.80.
#endif
       
#include "config.h"
#include "lyxserver.h"
#include "lyx.h"
#include "form1.h"
#include "layout_forms.h"
#include "print_form.h"
#include "tex-defs.h"
#include "toolbar.h"
#include "latex.h"
#include "definitions.h"
#include "up.xpm"
#include "down.xpm"
#include "lyx.xpm"
#include "minibuffer.h"

debug_levels lyx_debug_level;

FD_form_main *fd_form_main;
FD_form_title *fd_form_title;
FD_form_paragraph *fd_form_paragraph;
FD_form_search *fd_form_search;
FD_form_character *fd_form_character;
FD_form_document *fd_form_document;
FD_form_quotes *fd_form_quotes;
FD_form_preamble *fd_form_preamble;
FD_form_table *fd_form_table;
FD_form_print *fd_form_print;
FD_form_figure *fd_form_figure;
FD_form_screen *fd_form_screen;
FD_form_toc *fd_form_toc;
FD_form_ref *fd_form_ref;
FD_LaTeXOptions *fd_latex_options; // from latex.h

extern void init(int argc, char **argv);  // shoudn't init really be done here
extern void InitKeyMapper();
extern int AtCloseMainFormCB(FL_FORM*, void*);
extern int work_area_handler(FL_OBJECT * ob, int event, FL_Coord mx, FL_Coord my,
 			     int key, void *xev);
extern char work_area_active;

static
void set_xforms_defaults()
	// this is everything that is done to forms, before
	// fl_iniatialize is called
{
	FL_IOPT cntl;
	cntl.buttonFontSize = FL_MEDIUM_SIZE;
	cntl.browserFontSize = FL_MEDIUM_SIZE;
	cntl.labelFontSize = FL_MEDIUM_SIZE;
	cntl.choiceFontSize = FL_MEDIUM_SIZE;
	cntl.inputFontSize = FL_MEDIUM_SIZE;
	cntl.borderWidth = -2;
	// this is a temprary hack to make the depth
	// unimportant
	cntl.depth = 8;
	fl_set_defaults(FL_PDDepth, &cntl);
	
	fl_set_defaults(FL_PDButtonFontSize, &cntl);  
	fl_set_defaults(FL_PDBrowserFontSize, &cntl);  
	fl_set_defaults(FL_PDLabelFontSize, &cntl);  
	fl_set_defaults(FL_PDChoiceFontSize, &cntl);  
	fl_set_defaults(FL_PDInputFontSize, &cntl);  
	fl_set_defaults(FL_PDBorderWidth, &cntl);
}


static
FD_form_main *create_form_form_main(int width, int height)
	/* to make this work as it should, .lyxrc should have been
	 * read first; OR maybe this one should be made dynamic.
	 * Hmmmm. Lgb. */
{
	FL_OBJECT *obj;
	
	FD_form_main *fdui = (FD_form_main *)
		fl_calloc(1, sizeof(FD_form_main));

	// the main form
	fdui->form_main = fl_bgn_form(FL_NO_BOX, width, height);
	obj = fl_add_box(FL_FLAT_BOX,0,0,width,height,"");
	fl_set_object_color(obj,FL_MCOL,FL_MCOL);
	
	//
	// THE MENUBAR
	//

	// Here I'd really like to see code like:
	// addMenuBar();
	fdui->menubar_grp = fl_bgn_group();
	
	// menubar frame
	int old_bw = fl_get_border_width();
	fl_set_border_width(2);	
	obj = fl_add_frame(FL_UP_FRAME,10,10,width-20,25,"");
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthWestGravity, NorthEastGravity);
	fl_set_border_width(old_bw);	
	
	// File menu button
	fdui->menu_file = obj = fl_add_button(FL_INOUT_BUTTON,
					      10,10,60,25,"File");
	fl_set_object_boxtype(obj,FL_FLAT_BOX);
	fl_set_object_color(obj,FL_MCOL, FL_MCOL);
	fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthWestGravity, NorthWestGravity);
	fl_set_object_shortcut(obj, "#F", 2);
	fl_set_object_callback(obj,ShowFileMenu,0);
	
	// Edit menu button
	fdui->menu_edit = obj = fl_add_button(FL_INOUT_BUTTON,
					      70,10,60,25,"Edit");
	fl_set_object_boxtype(obj,FL_FLAT_BOX);
	fl_set_object_color(obj,FL_MCOL, FL_MCOL);
	fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthWestGravity, NorthWestGravity);
	fl_set_object_shortcut(obj, "#E",1);
	fl_set_object_callback(obj,ShowEditMenu,0);
	
	// Layout menu button
	fdui->menu_layout = obj = fl_add_button(FL_INOUT_BUTTON,
						130,10,70,25,"Layout");
	fl_set_object_boxtype(obj,FL_FLAT_BOX);
	fl_set_object_color(obj,FL_MCOL, FL_MCOL);
	fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthWestGravity, NorthWestGravity);
	fl_set_object_shortcut(obj, "#L", 1);
	fl_set_object_callback(obj,ShowLayoutMenu,0);
	
	// Insert menu button button
	fdui->menu_insert = obj = fl_add_button(FL_INOUT_BUTTON,
						 200,10,80,25,"Insert");
	fl_set_object_boxtype(obj,FL_FLAT_BOX);
	fl_set_object_color(obj,FL_MCOL, FL_MCOL);
	fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthWestGravity, NorthWestGravity);
	fl_set_object_shortcut(obj, "#I", 1);
	fl_set_object_callback(obj,ShowInsertMenu,0);
	
	// Math menu button
	fdui->menu_math = obj = fl_add_button(FL_INOUT_BUTTON,
					      280,10,60,25,"Math");
	fl_set_object_boxtype(obj,FL_FLAT_BOX);
	fl_set_object_color(obj,FL_MCOL, FL_MCOL);
	fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthWestGravity, NorthWestGravity);
	fl_set_object_shortcut(obj, "#M", 1);
	fl_set_object_callback(obj,ShowMathMenu,0);
	
	// Options menu button
	fdui->menu_options = obj = fl_add_button(FL_INOUT_BUTTON,
						 340,10,80,25,"Options");
	fl_set_object_boxtype(obj,FL_FLAT_BOX);
	fl_set_object_color(obj,FL_MCOL, FL_MCOL);
	fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthWestGravity, NorthWestGravity);
	fl_set_object_shortcut(obj, "#O", 1);
	fl_set_object_callback(obj,ShowOptionsMenu,0);
	
	// Windows menu button
	fdui->menu_buffer = obj = fl_add_button(FL_INOUT_BUTTON,
						420,10,90,25,"Documents");
	fl_set_object_boxtype(obj,FL_FLAT_BOX);
	fl_set_object_color(obj,FL_MCOL, FL_MCOL);
	fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthWestGravity, NorthWestGravity);
	fl_set_object_shortcut(obj, "#D", 1);
	fl_set_object_callback(obj,ShowBufferMenu,0);
	
	// Help menu button
	fdui->menu_help = obj = fl_add_button(FL_INOUT_BUTTON,
					      630,10,70,25,"Help");
	fl_set_object_boxtype(obj,FL_FLAT_BOX);
	fl_set_object_color(obj,FL_MCOL, FL_MCOL);
	fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthEastGravity, NorthEastGravity);
	fl_set_object_shortcut(obj, "#H", 1);
	fl_set_object_callback(obj,ShowHelpMenu,0);

	fl_end_group();
	
	//
	// TOOLBAR
	//

	// The toolbar is not inserted here, that is done later.
	// It would be nice to be able to insert it here:
	fdui->toolbar_grp = toolbar.toolobj;

	//
	// MINIBUFFER
	//
	
	minibuffer.add(FL_NORMAL_INPUT, 10, height-30, width-51, 25, "");

	//
	// WORKAREA
	//

	obj = fl_add_box(FL_DOWN_BOX,10,81,width-47,height-119,"");
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthWestGravity, SouthEastGravity);
	fdui->work_area = obj = fl_add_free(FL_INPUT_FREE,12,83,
					    width-51,height-123,"",
					    work_area_handler);
	obj->wantkey = FL_KEY_TAB;
	fl_set_object_boxtype(obj,FL_DOWN_BOX);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthWestGravity, SouthEastGravity);
	fl_set_object_callback(obj,WorkAreaCB,0);

	// a hack for the figinsets (Matthias)
	fdui->figinset_canvas = obj = fl_add_canvas(FL_NORMAL_CANVAS,
						    width-2,height-2,1,1,"");
	fl_set_object_boxtype(obj,FL_NO_BOX);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, SouthEastGravity, SouthEastGravity);

	//
	// THESCROLLBAR
	//
	
	// down - srollbar button
	fdui->button_down = obj = fl_add_pixmapbutton(FL_TOUCH_BUTTON,
						      width-30,height-30,20,20,
						      "");
	fl_set_object_boxtype(obj,FL_UP_BOX);
	fl_set_object_color(obj,FL_MCOL,FL_BLUE);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, SouthEastGravity, SouthEastGravity);
	fl_set_object_callback(obj,DownCB,0);
	
	// up - scrollbar button
	fdui->button_up = obj = fl_add_pixmapbutton(FL_TOUCH_BUTTON,
						    width-30,81,20,20,"");
	fl_set_object_boxtype(obj,FL_UP_BOX);
	fl_set_object_color(obj,FL_MCOL,FL_BLUE);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj,NorthEastGravity, NorthEastGravity);
	fl_set_object_callback(obj,UpCB,0);
	
	// the scrollbar slider
	fdui->scrollbar = obj = fl_add_slider(FL_VERT_SLIDER,width-30,
					      101,20,height-131,"");
	fl_set_object_color(obj,FL_COL1,FL_MCOL);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthEastGravity, SouthEastGravity);
	fl_set_object_callback(obj,ScrollCB,0);

	//
	// TIMERS
	//
	
	// timer_cursor
	fdui->timer_cursor = obj = fl_add_timer(FL_HIDDEN_TIMER,
						0,0,0,0,"Timer");
	fl_set_object_callback(obj,CursorToggleCB,0);
	
	// timer_autosave
	fdui->timer_autosave = obj = fl_add_timer(FL_HIDDEN_TIMER,
						  0,0,0,0,"Timer");
	fl_set_object_callback(obj,AutosaveTimerCB,0);
	
	// timer_update
	fdui->timer_update = obj = fl_add_timer(FL_HIDDEN_TIMER,
						0,0,0,0,"Timer");
	fl_set_object_callback(obj,UpdateTimerCB,0);
	
	fl_end_form();
	return fdui;
}


#ifdef DEBUG_AS_DEFAULT
#define DEBUG_SETTING_RES "1"
#else
#define DEBUG_SETTING_RES "0"
#endif

FL_CMD_OPT cmdopt[] =
{
	{"-width", "*.width", XrmoptionSepArg, "710"},
	{"-height", "*.height", XrmoptionSepArg, "510"},
	{"-dbg", "*.dbg", XrmoptionSepArg, DEBUG_SETTING_RES}
};

static int width;
static int height;

FL_resource res[] =
{
	{"width", "widthClass", FL_INT, &width, "710"},
	{"height", "heightClass", FL_INT, &height, "510"},
	{"dbg", "dbgClass", FL_INT, &lyx_debug_level, DEBUG_SETTING_RES}
};

#undef DEBUG_SETTING_CMD
#undef DEBUG_SETTING_RES
#undef DEBUG_AS_DEFAULT


static
void xforms_init(int *argc, char *argv[], const char* /*nom*/)
{
	set_xforms_defaults();
	
	fl_initialize(argc, argv, "LyX", cmdopt, 3);

 	// put here (after fl_initialize) to avoid segfault. Cannot be done
	// in set_xforms_defaults() (Matthias 140496)
 	fl_setpup_fontstyle(FL_NORMAL_STYLE);
 	fl_setpup_fontsize(FL_MEDIUM_SIZE);
 	fl_setpup_color(FL_MCOL,FL_BLACK);


	fl_get_app_resources(res, 3);

	if (lyx_debug_level & DEBUG_INIT) {
		fprintf(stderr,"Command Line Arguments:\n");
		fprintf(stderr,"-width = %d\n",width);
		fprintf(stderr,"-height = %d\n",height);
		fprintf(stderr,"-dbg = %d\n",lyx_debug_level);
	}
	if (lyx_debug_level & DEBUG_INIT)
		fprintf(stderr,"Debugging INIT.\n");
	if (lyx_debug_level & DEBUG_KEY)
		fprintf(stderr,"Debugging KEY.\n");
	if (lyx_debug_level & DEBUG_TOOLBAR)
		fprintf(stderr,"Debugging TOOLBAR.\n");
	if (lyx_debug_level & DEBUG_LEX_PARSER)
		fprintf(stderr,"Debugging Lex + parser.\n");
	if (lyx_debug_level & DEBUG_LYXRC)
		fprintf(stderr,"Debugging LyXRC.\n");
	
	fd_form_main = create_form_form_main(width,height);
	fl_set_form_atclose(fd_form_main->form_main, AtCloseMainFormCB, NULL);

	fd_form_title = create_form_form_title();
	fd_form_paragraph = create_form_form_paragraph();
	fd_form_search = create_form_form_search();
	fd_form_character = create_form_form_character();
	fd_form_document = create_form_form_document();
	fd_form_quotes = create_form_form_quotes();
	fd_form_preamble = create_form_form_preamble();
	fd_form_table = create_form_form_table();
	fd_form_print = create_form_form_print();
	fd_form_figure = create_form_form_figure();
	fd_form_screen = create_form_form_screen();
	fd_form_toc = create_form_form_toc();
	fd_form_ref = create_form_form_ref();
	fd_latex_options = create_form_LaTeXOptions();

	/* fill-in form initialization code */

	fl_set_pixmapbutton_data(fd_form_main->button_up,up_xpm);          
	fl_set_pixmapbutton_data(fd_form_main->button_down,down_xpm);          
   
	// moved here from init
	/* define the slider bounds */ 
	fl_set_slider_bounds(fd_form_paragraph->slider_spaces_top,0,20);
	fl_set_slider_bounds(fd_form_paragraph->slider_spaces_bottom,0,20);
	fl_set_slider_bounds(fd_form_document->slider_baselinestretch,0.75,2);
	fl_set_slider_bounds(fd_form_document->slider_secnumdepth,-1,5);
	fl_set_slider_bounds(fd_form_document->slider_tocdepth,-1,5);
	fl_set_slider_bounds(fd_form_table->slider_rows,1,50);
	fl_set_slider_bounds(fd_form_table->slider_columns,1,50);
	fl_set_slider_value(fd_form_table->slider_rows, 5);
	fl_set_slider_value(fd_form_table->slider_columns, 5);
	fl_set_slider_precision(fd_form_document->slider_secnumdepth, 0);
	fl_set_slider_precision(fd_form_document->slider_tocdepth, 0);
	fl_set_slider_precision(fd_form_table->slider_rows, 0);
	fl_set_slider_precision(fd_form_table->slider_columns, 0);
   
	fl_set_button(fd_form_figure->radio_postscript, 1);
	fl_set_button(fd_form_figure->radio_latex, 0);
   
	fl_set_goodies_font(FL_NORMAL_STYLE, FL_MEDIUM_SIZE);
   
	int n=0;
	while(1) {
      if (strcmp(tex_babel[n++],"last_item")!=0)
	 fl_addto_choice(fd_form_document->choice_language,tex_babel[n-1]);
      else break;
   }
   
   fl_addto_choice(fd_form_document->choice_fontsize, "10|11|12");

   n=0;
   while(1) {
      if (strcmp(tex_fonts[n++],"last_item")!=0)
	 fl_addto_choice(fd_form_document->choice_fonts,tex_fonts[n-1]);
      else break;
   }
   
   fl_addto_choice(fd_form_document->choice_inputenc, "default|latin1|latin2");

   n=0;
   while(1) {
      if (strcmp(tex_epsfig[n++], "last_item")!=0)
	 fl_addto_choice(fd_form_document->choice_epsfig, tex_epsfig[n-1]);
      else break;
   }
   
   fl_addto_choice(fd_form_document->choice_papersize,
		   " A4 normal Borders | A4 small Borders (only portrait) "
		   "| A4 very small Borders (only portrait) "
		   "| A4 very wide borders (only portrait) | US Letter "
		   "| A5 | B5 | legal | executive ");
   
   fl_addto_choice(fd_form_document->choice_pagestyle,
		   " Plain | Headings | Empty ");


   fl_addto_choice(fd_form_quotes->choice_quotes_language,
		   " German | English | French ");

   fl_addto_choice(fd_form_character->choice_family, 
		   " No change | Roman | Sans Serif | Typewriter ");
   fl_addto_choice(fd_form_character->choice_series, 
		   " No change | Normal | Bold ");
   fl_addto_choice(fd_form_character->choice_shape, 
		   " No change | Up | Italic | Small caps ");
   fl_addto_choice(fd_form_character->choice_size, 
		   " No change | Small | Normal "
		   "| Large | Larger | Largest | Huge | Giant ");
   fl_addto_choice(fd_form_character->choice_bar, 
		   " No change | No bar | Underbar ");
   
   // show the title form at most 15 secs
   fl_set_timer(fd_form_title->timer_title, 15);

}


int main(int argc, char *argv[])
{
	// initializes xforms (defaults frames etc.)
	xforms_init(&argc, argv, "LyX");

        //  assign an icon to main form
        unsigned int w, h;
        Pixmap lyx_p, lyx_mask;
        extern long fl_root;

        lyx_p = fl_create_from_pixmapdata(fl_root, lyx_xpm,
                                         &w, &h, &lyx_mask, 0, 0, 0);

        fl_set_form_icon(fd_form_main->form_main, lyx_p, lyx_mask);

	fl_set_focus_object(fd_form_main->form_main,fd_form_main->work_area);

	// show the main form
	fl_show_form(fd_form_main->form_main,
		     FL_PLACE_CENTER | FL_FREE_SIZE,FL_FULLBORDER,
		     "LyX");
	
	// show the title form
	fl_show_form(fd_form_title->form_title, 
		     FL_PLACE_CENTER, FL_NOBORDER, 
		     "Title");

	// deactivate the menu accelerators
	fl_set_object_shortcut(fd_form_main->menu_file, "", 1);
	fl_set_object_shortcut(fd_form_main->menu_edit, "", 1);
	fl_set_object_shortcut(fd_form_main->menu_layout, "", 1);
	fl_set_object_shortcut(fd_form_main->menu_math, "", 1);
	fl_set_object_shortcut(fd_form_main->menu_insert, "", 1);
	fl_set_object_shortcut(fd_form_main->menu_options, "", 1);
	fl_set_object_shortcut(fd_form_main->menu_buffer, "", 1);
	fl_set_object_shortcut(fd_form_main->menu_help, "", 1);

	// initialization of LyX
	init(argc, argv);
	InitKeyMapper();
	
	XEvent ev;
	
	while(1) {
		if (fl_check_forms() == FL_EVENT){
		  printf("oops, da hats mich rausgehauen \n");
			fl_XNextEvent(&ev);
		}
	}
	return 0;
}


