.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XrmGetFileDatabase 3X11 "Release 6" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XrmGetFileDatabase, XrmPutFileDatabase, XrmGetStringDatabase, XrmLocaleOfDatabase, XrmGetDatabase, XrmSetDatabase, XrmDestroyDatabase \- retrieve and store resource databases
.SH SYNTAX
XrmDatabase XrmGetFileDatabase\^(\^\fIfilename\fP\^)
.br
     char *\fIfilename\fP\^;
.LP
void XrmPutFileDatabase\^(\^\fIdatabase\fP, \fIstored_db\fP\^)
.br
     XrmDatabase \fIdatabase\fP\^;
.br
     char *\fIstored_db\fP\^;
.LP
XrmDatabase XrmGetStringDatabase\^(\^\fIdata\fP\^)
.br
     char *\fIdata\fP\^;
.LP
char *XrmLocaleOfDatabase\^(\^\fIdatabase\fP\^)
.br
      XrmDatabase \fIdatabase\fP\^;
.LP
XrmDatabase XrmGetDatabase\^(\^\fIdisplay\fP\^)
.br
      Display *\fIdisplay\fP\^;
.LP
void XrmSetDatabase\^(\^\fIdisplay\fP\^, \fIdatabase\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      XrmDatabase \fIdatabase\fP\^;
.LP
void XrmDestroyDatabase\^(\^\fIdatabase\fP\^)
.br
      XrmDatabase \fIdatabase\fP\^;
.SH ARGUMENTS
.IP \fIfilename\fP 1i
Specifies the resource database file name.
.IP \fIdatabase\fP 1i
Specifies the database that is to be used.
.IP \fIstored_db\fP 1i
Specifies the file name for the stored database.
.IP \fIdata\fP 1i
Specifies the database contents using a string.
.IP \fIdatabase\fP 1i
Specifies the resource database.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.SH DESCRIPTION
The
.ZN XrmGetFileDatabase
function opens the specified file,
creates a new resource database, and loads it with the specifications
read in from the specified file.
The specified file should contain a sequence of entries in valid ResourceLine
format (see section 15.1); the database that results from reading a file
with incorrect syntax is implementation dependent.
The file is parsed in the current locale, 
and the database is created in the current locale.
If it cannot open the specified file,
.ZN XrmGetFileDatabase
returns NULL.
.LP
The
.ZN XrmPutFileDatabase
function stores a copy of the specified database in the specified file.
Text is written to the file as a sequence of entries in valid
ResourceLine format (see section 15.1).
The file is written in the locale of the database.
Entries containing resource names that are not in the Host Portable Character
Encoding or containing values that are not in the encoding of the database
locale, are written in an implementation dependent manner.
The order in which entries are written is implementation dependent.
Entries with representation types other than ``String'' are ignored.
.LP
The
.ZN XrmGetStringDatabase
function creates a new database and stores the resources specified
in the specified null-terminated string.
.ZN XrmGetStringDatabase
is similar to
.ZN XrmGetFileDatabase
except that it reads the information out of a string instead of out of a file.
The string should contain a sequence of entries in valid ResourceLine
format (see section 15.1) terminated by a null character;
the database that results from using a string
with incorrect syntax is implementation dependent.
The string is parsed in the current locale, 
and the database is created in the current locale.
.LP
If database is NULL,
.ZN XrmDestroyDatabase
returns immediately.
.LP
The
.ZN XrmLocaleOfDatabase
function returns the name of the locale bound to the specified
database, as a null-terminated string.
The returned locale name string is owned by Xlib and should not be
modified or freed by the client.
Xlib is not permitted to free the string until the database is destroyed.
Until the string is freed,
it will not be modified by Xlib.
.LP
The
.ZN XrmGetDatabase
function returns the database associated with the specified display.
It returns NULL if a database has not yet been set.
.LP
The
.ZN XrmSetDatabase
function associates the specified resource database (or NULL)
with the specified display.
The database previously associated with the display (if any) is not destroyed.
A client or toolkit may find this function convenient for retaining a database
once it is constructed.
.SH "FILE SYNTAX"
The syntax of a resource file is a sequence of resource lines
terminated by newline characters or the end of the file.
The syntax of an individual resource line is:
.LP
.\" Start marker code here
.Ds 0
.TA 1.5i 1.75i
.ta 1.5i 1.75i
ResourceLine	=	Comment | IncludeFile | ResourceSpec | <empty line>
Comment	=	"!" {<any character except null or newline>}
IncludeFile	=	"#" WhiteSpace "include" WhiteSpace FileName WhiteSpace
FileName	=	<valid filename for operating system>
ResourceSpec	=	WhiteSpace ResourceName WhiteSpace ":" WhiteSpace Value
ResourceName	=	[Binding] {Component Binding} ComponentName
Binding	=	"\&." | "*"
WhiteSpace	=	{<space> | <horizontal tab>}
Component	=	"?" | ComponentName
ComponentName	=	NameChar {NameChar}
NameChar	=	"a"\-"z" | "A"\-"Z" | "0"\-"9" | "_" | "-"
Value	=	{<any character except null or unescaped newline>}
.De
.\" End marker code here
.LP
Elements separated by vertical bar (|) are alternatives.
Curly braces ({\&.\&.\&.}) indicate zero or more repetitions
of the enclosed elements.
Square brackets ([\&.\&.\&.]) indicate that the enclosed element is optional.
Quotes ("\&.\&.\&.") are used around literal characters.
.LP
IncludeFile lines are interpreted by replacing the line with the
contents of the specified file.
The word ``include'' must be in lowercase.
The file name is interpreted relative to the directory of the file in
which the line occurs (for example, if the file name contains no
directory or contains a relative directory specification).
.LP
If a ResourceName contains a contiguous sequence of two or more Binding
characters, the sequence will be replaced with single ``\&.'' character
if the sequence contains only ``\&.'' characters;
otherwise, the sequence will be replaced with a single ``*'' character.
.LP
A resource database never contains more than one entry for a given
ResourceName.  If a resource file contains multiple lines with the
same ResourceName, the last line in the file is used.
.LP
Any white space characters before or after the name or colon in a ResourceSpec
are ignored.
To allow a Value to begin with white space,
the two-character sequence ``\^\\\^\fIspace\fP'' (backslash followed by space)
is recognized and replaced by a space character,
and the two-character sequence ``\^\\\^\fItab\fP''
(backslash followed by horizontal tab)
is recognized and replaced by a horizontal tab character.
To allow a Value to contain embedded newline characters,
the two-character sequence ``\^\\\^n'' is recognized and replaced by a
newline character.
To allow a Value to be broken across multiple lines in a text file,
the two-character sequence ``\^\\\^\fInewline\fP''
(backslash followed by newline) is
recognized and removed from the value.
To allow a Value to contain arbitrary character codes,
the four-character sequence ``\^\\\^\fInnn\fP'',
where each \fIn\fP is a digit character in the range of ``0''\^\-``7'',
is recognized and replaced with a single byte that contains
the octal value specified by the sequence.
Finally, the two-character sequence ``\^\\\\'' is recognized
and replaced with a single backslash.
.SH "SEE ALSO"
XrmGetResource(3X11),
XrmInitialize(3X11),
XrmPutResource(3X11)
.br
\fI\*(xL\fP
