/*--------------------------------*-C-*---------------------------------*
 * file:	configure.h
 *
 * Compile-time configuration.  For additional compile-time configuration,
 * also see "defaults.h" and "rxvtkeys.h"
 * ----------------------------------------------------------------------
 * Copyright 1995 mj olesen <olesen@me.queensu.ca> Queen's Univ at Kingston
 *
 * You can do what you like with this source code provided you don't make
 * money from it and you include an unaltered copy of this message
 * (including the copyright).  As usual, the author accepts no
 * responsibility for anything, nor does he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _CONFIGURE_H
#define _CONFIGURE_H

/*----------------------------------------------------------------------*
 * #define DEBUG_SCREEN
 * to do self-check for internal screen corruption
 *
 * #define DEBUG_MALLOC
 * to do self-check on out-of-bound memory usage
 *----------------------------------------------------------------------*/
/*#define DEBUG_SCREEN*/
/*#define DEBUG_MALLOC*/

/*----------------------------------------------------------------------*
 * #define PRINT_PIPE
 *
 * to add support for an emulation of an attached vt100 printer
 *----------------------------------------------------------------------*/
/*#define PRINT_PIPE*/

/*----------------------------------------------------------------------*
 * #define MAX_REFRESH_PERIOD <num>
 *
 * limits the number of screenfulls between screen refreshes during
 * hard & fast scrolling (default = 10)
 *
 * #define NO_REFRESH_RESOURCE
 *
 * to avoid using the -refresh option and refreshPeriod resource
 *----------------------------------------------------------------------*/
/*#define MAX_REFRESH_PERIOD	10*/
#define NO_REFRESH_RESOURCE

/*----------------------------------------------------------------------*
 * #define USE_XCOPYAREA
 *
 * to use XCopyArea (in place of re-draws) to speed up rxvt.  I've been
 * told this helps with some graphics adapters like the PC's et4000.
 * OK, it's good on monochrome Sun-3's that I've tried too.
 * - RN
 *
 * NB: using this seems to make rxvt look worse and slower too.  It has the
 * side-effect of destroying the extra information about autowrapped lines
 * (NEW_WRAPTYPE) that is used by the selection mechanism.
 * /mjo
 *----------------------------------------------------------------------*/
/*#define USE_XCOPYAREA*/

/*----------------------------------------------------------------------*
 * #define FAKE_RESOURCES
 *
 * to use a substitute for using XGetDefaults().
 * If all you want to do is put rxvt defaults in ~/.Xdefaults file,
 * use this, and save 60-160KBytes memory!
 *
 * #define REAL_RESOURCES
 * to use XGetDefaults()
 *
 * define neither and blow off the Xdefaults altogether or else use
 *
 * #define NO_RESOURCES
 *----------------------------------------------------------------------*/
#define FAKE_RESOURCES
/*#define REAL_RESOURCES*/
/*#define NO_RESOURCES*/

/*----------------------------------------------------------------------*
 * #define KEYSYM_RESOURCE
 *
 * to utilize the keysym resource which allows you to redefine the strings
 * associated with various KeySyms (0xFF00 - 0xFFFF)
 *
 * Only works with FAKE_RESOURCES.
 *----------------------------------------------------------------------*/
#define KEYSYM_RESOURCE

/*----------------------------------------------------------------------*
 * #define COLOR
 *
 * to get ANSI color in rxvt
 *----------------------------------------------------------------------*/
#define COLOR

/*----------------------------------------------------------------------*
 * #define USE_FAKE_BOLD
 *
 * Simulate bold foreground by writing fatter characters.
 * Also suppress use of BLINK attribute for high intensity background.
 *----------------------------------------------------------------------*/
/*#define USE_FAKE_BOLD*/

/*----------------------------------------------------------------------*
 * #define RXVT_GRAPHICS
 * for Rob Nation's own graphics mode
 *----------------------------------------------------------------------*/
/*#define RXVT_GRAPHICS*/

/*----------------------------------------------------------------------*
 * #define MULTIPLE_CLICKS
 *
 * for double and triple click selection support
 * Integrated by A. Haritsis <ah@doc.ic.ac.uk>
 * based on code by Edward. Der-Hua Liu, Taiwan
 *
 * #define MULTICLICK_TIME <num>
 * delay between multiple click events (default 500)
 *----------------------------------------------------------------------*/
#define MULTIPLE_CLICKS
/*#define MULTICLICK_TIME 500*/

/*----------------------------------------------------------------------*
 * #define REPLACE_SELECTION_NEWLINE
 *
 * to replace occurrences of newline characters with a carriage return
 * character for a requested selection.  Seems to be used for Sun.
 *----------------------------------------------------------------------*/
/*#define REPLACE_SELECTION_NEWLINE*/

/*----------------------------------------------------------------------*
 * #define SCROLLBAR_NOARROWS
 *
 * to only permit the XTerm-style scrollbar (without arrows)
 *
 * #define SCROLLBAR_ARROWS
 *
 * to only permit the native scrollbar with arrows
 *
 * #define SCROLLBAR_NONE
 *
 * to remove the scrollbar entirely
 *----------------------------------------------------------------------*/
#define SCROLLBAR_NOARROWS
/*#define SCROLLBAR_ARROWS*/
/*#define SCROLLBAR_NONE*/

/*----------------------------------------------------------------------*
 * #define NO_SECONDARY_SCREEN
 *
 * to disable use of the secondary screen and thus disable both
 * ESC [ ? 47 h and ESC [ ? 47 l
 *----------------------------------------------------------------------*/
/*#define NO_SECONDARY_SCREEN*/

/*----------------------------------------------------------------------*
 * #define NO_MOUSE_REPORT
 *
 * to disable using the XTerm mouse report protocol
 *----------------------------------------------------------------------*/
/*#define NO_MOUSE_REPORT*/

/*----------------------------------------------------------------------*
 * #define MAPALERT
 *
 * to enable automatic de-iconify when a bell is received
 *
 * #define VISUAL_BELL
 *
 * to enable a visual bell when a bell is received
 *----------------------------------------------------------------------*/
/*#define MAPALERT*/
/*#define VISUAL_BELL*/

/*----------------------------------------------------------------------*
 * #define SECURE_KBD
 * to allow keyboard to be secured (for typing passwords)
 *----------------------------------------------------------------------*/
/*#define SECURE_KBD*/

/*----------------------------------------------------------------------*
 * #define ALWAYS_META_ESCAPE
 *
 * so that Meta (Alt) ALWAYS provides an Escape prefix
 *----------------------------------------------------------------------*/
#define ALWAYS_META_ESCAPE

/*----------------------------------------------------------------------*
 * #define NO_7BIT_MODE
 *
 * to completely disable 7-bit output mode
 *----------------------------------------------------------------------*/
#define NO_7BIT_MODE

/*----------------------------------------------------------------------*
 * #define SINGLE_FONT
 *
 * to disable toggling of multiple fonts
 *----------------------------------------------------------------------*/
/*#define SINGLE_FONT*/

/*----------------------------------------------------------------------*
 * #define GREEK_SUPPORT
 *
 * to include support for the Greek Elot-928 & IBM-437 keyboard
 * by A. Haritsis <ah@doc.ic.ac.uk>
 *
 * Please read instructions in README.greek
 *	- toggle via keysym: Mode_switch
 *	- redefine via X resource: greektoggle_key
 *----------------------------------------------------------------------*/
/*#define GREEK_SUPPORT*/

/*----------------------------------------------------------------------*
 * #define ESCZ_RXVT_ANSWER
 *
 * to have the ESC Z transmit ;2C instead of default ;2c
 *----------------------------------------------------------------------*/
/*#define ESCZ_RXVT_ANSWER */

/*----------------------------------------------------------------------*
 * #define DISPLAY_ENV_AND_ANSWER_IS_IP
 *
 * to have DISPLAY and "ESC [ 7 n" transmit a display with a
 * proper IP number.
 *----------------------------------------------------------------------*/
/*#define DISPLAY_ENV_AND_ANSWER_IS_IP */

/*----------------------------------------------------------------------*
 * #define UTMP_SUPPORT
 *
 * for utmp support to update "/etc/utmp" so that `who` and `w`
 * show rxvt logins.
 *
 * For this to work, /etc/utmp must be world writeable, or rxvt must be
 * setuid root (potential security hole).
 *
 * make rxvt setuid root (Do it at your own risk):
 *	su
 *	chown root.root rxvt
 *	chmod a+s rxvt
 *
 * Also,
 * #define UTMP	"/var/adm/utmp"
 * #define UTMP "/var/run/utmp"
 *
 * define where the utmp file is located if it is not /etc/utmp
 *
 * And
 * #define TTYTAB "/etc/ttys"
 *
 * for BSD-type systems, define where the tty table is located if it
 * is not /etc/ttytab
 *----------------------------------------------------------------------*/
#define UTMP_SUPPORT
#ifdef UTMP_SUPPORT
#ifndef UTMP
  #define UTMP	"/var/run/utmp"
/*# define UTMP	"/var/adm/utmp"*/
#endif
#ifndef TTYTAB
/*# define TTYTAB "/etc/ttys"*/
#endif
#endif

/*----------------------------------------------------------------------*
 * end of user configuration section
 *----------------------------------------------------------------------*/

/* sort out conflicts in user defines */
#if defined (NO_RESOURCES)
#  undef REAL_RESOURCES
#  undef FAKE_RESOURCES
#  undef KEYSYM_RESOURCE
#elif defined (REAL_RESOURCES)
#  undef FAKE_RESOURCES
#  undef KEYSYM_RESOURCE
#elif !defined (FAKE_RESOURCES)
#  define NO_RESOURCES
#  undef KEYSYM_RESOURCE
#endif

#undef SCROLLBAR_ANY
#ifdef SCROLLBAR_NONE
#  undef SCROLLBAR_ARROWS
#  undef SCROLLBAR_NOARROWS
#elif defined (SCROLLBAR_ARROWS) || defined (SCROLLBAR_NOARROWS)
#  if defined (SCROLLBAR_ARROWS) && defined (SCROLLBAR_NOARROWS)
#    undef SCROLLBAR_ARROWS
#    undef SCROLLBAR_NOARROWS
#    define SCROLLBAR_ANY
#  endif
#else
#  define SCROLLBAR_ANY
#endif

/* FREEBSD is definitely also BSD */
#if defined (FREEBSD) && !defined (BSD)
#  define BSD
#endif

/* Allow gcc users to use inline */
#ifdef __GNUC__
#ifndef inline
# define INLINE		__inline__
#else
# define INLINE		inline
#endif
#else
# define INLINE		/*nothing*/
#endif
#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
