/* 
   nscolorwell.m

   Simple application to test NSColorWell class.

   Copyright (C) 1997 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: February 1997
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#import <AppKit/AppKit.h>
#import <Foundation/NSAutoreleasePool.h>

int
main(int argc, char **argv, char** env)
{
  NSApplication *theApp;
  NSWindow *win;
  NSView *v;
  NSColorWell *c;
  NSRect cf = {{40, 30}, {40, 40}};
  NSButton *b;
  NSRect bf = {{11, 91}, {80, 20}};
  NSRect wf0 = {{0, 0}, {150, 150}};
  NSColor *green;
  id pool;

#if LIB_FOUNDATION_LIBRARY
    [NSProcessInfo initializeWithArguments:argv count:argc environment:env];
#endif

  pool = [NSAutoreleasePool new];

#ifndef NX_CURRENT_COMPILER_RELEASE
    initialize_gnustep_backend();
#endif

  theApp = [NSApplication sharedApplication];
  green = [NSColor greenColor];

  win = [[NSWindow alloc] init];
  //[win setBackgroundColor: green];
  v = [win contentView];

  c = [[NSColorWell alloc] initWithFrame: cf];
  [c setColor:green];
  [v addSubview: c];
  b = [[NSButton alloc] initWithFrame: bf];
  [v addSubview: b];

  [win setFrame: wf0 display: YES];
  [win setTitle:@"GNUstep NSColorWells"];
  [win orderFront:nil];

  [theApp run];

  [pool release];

  return 0;
}
