/* 
   testDPS.m

   Show off postscript drawing.

   Copyright (C) 1997 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: March 1997
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#import <Foundation/NSAutoreleasePool.h>
#import <AppKit/AppKit.h>
#include "TestView.h"

//
// my main for the test app
//
int
main(int argc, char **argv, char** env)
{
  NSApplication *theApp;
  NSWindow *w0, *w1;
  NSRect wf0 = {{0, 0}, {500, 500}};
  char out[80];
  NSMenu *m0, *m1, *m2;
  id mc0, mc1, mc2, mc3;
  TestView *v, *v1;
  id pool;

#if LIB_FOUNDATION_LIBRARY
  [NSProcessInfo initializeWithArguments:argv count:argc environment:env];
#endif

#ifdef __MS_WIN32__
  // Initialize ourselves in Obj-C runtime
  init_testDPS();
#endif

  pool = [NSAutoreleasePool new];

#ifndef NX_CURRENT_COMPILER_RELEASE
    initialize_gnustep_backend();
#endif

  theApp = [NSApplication sharedApplication];

  //
  // Windows
  //
  w0 = [[NSWindow alloc] init];
  [w0 setTitle:@"Graphics Testing"];

  v = [[TestView alloc] init];
  [w0 setContentView: v];
  [w0 setFrame:wf0 display:YES];
  w1 = [[NSWindow alloc] init];
#if 0
  [w1 setTitle: @"Second Window"];
  v1 = [[TestView alloc] init];
  [w1 setContentView: v1];
  [w1 setFrame: wf0 display: YES];

  // Main menu
  m0 = [[NSMenu alloc] initWithTitle: @"testDPS"];
  mc0 = [m0 addItemWithTitle: @"Document" action: NULL
	    keyEquivalent: @""];
  mc1 = [m0 addItemWithTitle: @"Edit" action: NULL
	    keyEquivalent: @""];
  mc2 = [m0 addItemWithTitle: @"Windows" action: NULL
	    keyEquivalent: @""];
  mc2 = [m0 addItemWithTitle: @"Hide" action: @selector(hide:)
	    keyEquivalent: @"h"];
  [mc2 setTarget: theApp];
  mc2 = [m0 addItemWithTitle: @"Quit" action: @selector(terminate:)
	    keyEquivalent: @"q"];
  [mc2 setTarget: theApp];

  // Document submenu
  m1 = [[NSMenu alloc] initWithTitle: @"Document"];
  [m1 addItemWithTitle: @"New" action: NULL keyEquivalent: @""];
  [m1 addItemWithTitle: @"Open" action: NULL keyEquivalent: @""];
  [m1 addItemWithTitle: @"Save" action: NULL keyEquivalent: @""];
  [m0 setSubmenu: m1 forItem: mc0];

  // Edit submenu
  m1 = [[NSMenu alloc] initWithTitle: @"Edit"];
  [m1 addItemWithTitle: @"Cut" action: NULL keyEquivalent: @""];
  [m1 addItemWithTitle: @"Copy" action: NULL keyEquivalent: @""];
  [m1 addItemWithTitle: @"Paste" action: NULL keyEquivalent: @""];
  mc3 = [m1 addItemWithTitle: @"Find" action : NULL keyEquivalent: @""];
  [m0 setSubmenu: m1 forItem: mc1];

  // Find submenu
  m2 = [[NSMenu alloc] initWithTitle: @"Find"];
  [m2 addItemWithTitle: @"Find" action: NULL keyEquivalent: @""];
  mc2 = [m2 addItemWithTitle: @"Forward" action: @selector(terminate:)
	    keyEquivalent: @""];
  [mc2 setTarget: theApp];
  [m2 addItemWithTitle: @"Backward" action: NULL keyEquivalent: @""];
  [m1 setSubmenu: m2 forItem: mc3];

  [theApp setMainMenu: m0];
#endif

  [w0 orderFront:nil];
  [theApp run];

  [w0 release];
  //  [w1 release];

  [pool release];
}

