/* This file is part of the KDE libraries
    Copyright (C) 1997 Sven Radej (sven.radej@iname.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
#ifndef _KMENUBAR_H
#define _KMENUBAR_H

#include <qmenubar.h> 
 
class _menuBar : public QMenuBar
 {
   Q_OBJECT
     
 public:
   _menuBar(QWidget *parent=0, const char *name=0);
   ~_menuBar();
 };

/**
 * This is floatable toolbar. It can be set to float, Top, or Bottom
 * of KTopLevelWidget. It can be used without of KTopLevelWidget,
 * but then you should maintain items (toolbars, menubar, statusbar)
 * yourself. Interface is the same as QMenuBar, except that you can't
 * add pixmaps. Signals are not implemented.
 * If you want to add other methods for 100% compatibility with QMenuBar
 * just add those methods, and pass all arguments ot menu bar.
 * see kmenubar.cpp for details. It is extremly simple.
 * @short KDE floatable menubar
 */
class KMenuBar : public QFrame
 {
   Q_OBJECT

 public:

   /**
    * Positions of menubar.
    */
   enum menuPosition{Top, Bottom, Floating};

   /**
    * Constructor
    */
   KMenuBar( QWidget *parent=0, const char *name=0);

   /**
    * Destructor. Embeds menubar back if floating. Delete menubar
    * in your destructor or closeEvent for 100% safety
    */
   ~KMenuBar();

   /**
    * Enable or disable moving. This only disables user moving
    * menubar can be moved wit @ref setMenuBarPos.
    */
   void enableMoving(bool flag = TRUE);

   /**
    * Returns menubar position.
    */
   menuPosition menuBarPos() {return position;};

   /**
    * Enables/disables floating.
    */
   void enableFloating (bool flag = TRUE);

   /**
    * Sets position. Can be used when floating or moving is disabled.
    */
   void setMenuBarPos(menuPosition mpos);

   /**
    * Sets title for floating menu bar. Default is Main widget title.
    */
   void setTitle(const char *_title) {title = _title;};

   /**
    * The rest is standard QMenuBar interface. See Qt docs for
    * details.
    */
   uint count();
   int insertItem(const char *text,
                  const QObject *receiver, const char *member,
                  int accel=0 );
   int insertItem(const char *text, int id=-1, int index=-1 );
   int insertItem(const char *text, QPopupMenu *popup,
                  int id=-1, int index=-1 );

   void insertSeparator(int index=-1 );
   void removeItem(int id);
   void removeItemAt(int index);
   void clear();
   int accel(int id);
   void setAccel(int key, int id );
   const char *text(int id);
   void changeItem(const char *text, int id);
   void setItemChecked(int id , bool flag);
   void setItemEnabled(int id, bool flag);

   int heightForWidth ( int max_width ) const; 

 protected slots:
   void ContextCallback(int index);
   void slotActivated (int id);
   void slotHighlighted (int id);
   
 protected:
   void init();
   void mousePressEvent ( QMouseEvent *m );
   void resizeEvent( QResizeEvent *e );
   void paintEvent(QPaintEvent *);
   void closeEvent (QCloseEvent *e);
   void leaveEvent (QEvent *e);
   bool eventFilter(QObject *, QEvent *);
   
 private:
   bool moving;
   QWidget *Parent;
   int oldX;
   int oldY;
   int oldWFlags;
   const char *title;
   menuPosition position;
   menuPosition lastPosition;
   QPopupMenu *context;
   QMenuBar *menu;
   QFrame *frame;
     
signals:
    /**
     * This signal is connected to KTopLevel::updateRects. It is
     * emited when menu bar changes its position.
     */
    void moved (menuPosition);
    /**
     * This signal is emited when item id is highlighted.
     */
    void highlighted(int id);

    /**
     * This signal is emited when item id is activated.
     */
    void activated(int id);

 private:
   QFrame *handle;
   QPoint pointerOffset;
   QPoint parentOffset;
   int oldMenuFrameStyle;

 };

#endif
