/*
 *              kPPP: A pppd Front End for the KDE project
 *
 * $Id: docking.cpp,v 1.4 1998/02/26 21:56:04 kulow Exp $
 *
 *              Copyright (C) 1997 Bernd Johannes Wuebben
 *                      wuebben@math.cornell.edu
 * 
 * This file was contributed by Harri Porten <porten@tu-harburg.de>
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <qtooltip.h>
#include <qdir.h>
#include <kwm.h>
#include <kapp.h>

#include "docking.h"
#include "main.h"
#include "kpppconfig.h"

extern KApplication *app;
extern XPPPWidget   *p_xppp;

extern bool do_stats();
extern bool init_stats();


DockWidget::DockWidget(const char *name)
  : QWidget(0, name, 0) {

  docked = false;

  QString pixdir = app->kde_datadir() + QString("/kppp/pics/");  
  QString tmp;

#define PMERROR(pm) \
  tmp.sprintf(klocale->translate("Could not load %s !"), pm); \
  QMessageBox::warning(this, klocale->translate("Error"), tmp);

  // load pixmaps
  if (!dock_none_pixmap.load(pixdir + "dock_none.xpm")){
    PMERROR("dock_none.xpm");
  }
  if (!dock_left_pixmap.load(pixdir + "dock_left.xpm")){
    PMERROR("dock_left.xpm");
  }
  if (!dock_right_pixmap.load(pixdir + "dock_right.xpm")){
    PMERROR("dock_right.xpm");
  }
  if (!dock_both_pixmap.load(pixdir + "dock_both.xpm")){
    PMERROR("dock_both.xpm");
  }

  // popup menu for right mouse button
  popup_m = new QPopupMenu();
  toggleID = popup_m->insertItem(klocale->translate("Restore"),
				 this, SLOT(toggle_window_state()));
  popup_m->insertItem(klocale->translate("Details"), this, SLOT(show_stats()));
  popup_m->insertSeparator();
  popup_m->insertItem(klocale->translate("Disconnect"), 
		      this, SLOT(disconnect()));

  statstring = statstring.sprintf("In: %.2f Out %.2f",
				  (float)ibytes/1000,(float)obytes/1000);
  //  QToolTip::add( this, statstring.data() );

  // timer for little modem animation
  clocktimer = new QTimer(this);
  connect(clocktimer, SIGNAL(timeout()), SLOT(timeclick()));

}

DockWidget::~DockWidget() {
  clocktimer->stop();
}

void DockWidget::dock() {

  if (!docked) {

    // prepare panel to accept this widget
    KWM::setDockWindow (this->winId());

    // that's all the space there is
    this->setFixedSize(24, 24);

    // finally dock the widget
    this->show();

    docked = true;
  } 
}

void DockWidget::undock() {

  if (docked) {

    // the widget's window has to be destroyed in order 
    // to undock from the panel. Simply using hide() is
    // not enough (seems to be necessary though).

    this->hide();

    this->destroy(true, true);

    // recreate window for further dockings
    this->create(0, true, false);

    docked = false;
  }
}

const bool DockWidget::isDocked() {

  return docked;

}

void DockWidget::paintEvent (QPaintEvent *e) {

  (void) e;

  paintIcon();

}

void DockWidget::paintIcon () {

  // animate modem lights 

  if((ibytes_last != ibytes) && (obytes_last != obytes)) {
    bitBlt(this, 0, 0, &dock_both_pixmap);    
    ibytes_last = ibytes;
    obytes_last = obytes;
    /*    QToolTip::remove(this);
    statstring = statstring.sprintf("In: %.2f Out %.2f",
				    (float)ibytes/1000,(float)obytes/1000);
    QToolTip::add( this, statstring.data() );*/
    return;
  }

  if(ibytes_last != ibytes) {
    bitBlt(this, 0, 0, &dock_left_pixmap);    
    ibytes_last = ibytes;
    obytes_last = obytes;
    /*    QToolTip::remove(this);
    statstring = statstring.sprintf("In: %.2f Out %.2f",
				    (float)ibytes/1000,(float)obytes/1000);
    QToolTip::add( this, statstring.data() );*/
    return;
  }

  if(obytes_last != obytes) {
    bitBlt(this, 0, 0, &dock_right_pixmap);    
    ibytes_last = ibytes;
    obytes_last = obytes;
    /*    QToolTip::remove(this);
    statstring = statstring.sprintf("In: %.2f Out %.2f",
				    (float)ibytes/1000,(float)obytes/1000);
    QToolTip::add( this, statstring.data() );*/
    return;
  }

  bitBlt(this, 0, 0, &dock_none_pixmap);    
  ibytes_last = ibytes;
  obytes_last = obytes;

}

void DockWidget::timeclick() {

  if(this->isVisible()){
    (void) do_stats();  
    paintIcon();
  }  
}

void DockWidget::take_stats() {

  if (docked) {
    init_stats();
    clocktimer->start(PPP_STATS_INTERVAL);
  }
}

void DockWidget::stop_stats() {

  clocktimer->stop();

}

void DockWidget::mousePressEvent(QMouseEvent *e) {

  // open/close connect-window on right mouse button 
  if ( e->button() == LeftButton ) {
    toggle_window_state();
  }

  // open popup menu on left mouse button
  if ( e->button() == RightButton ) {
    int x = e->x() + this->x();
    int y = e->y() + this->y();

    QString text;
    if(p_xppp->con_win->isVisible())
      text = klocale->translate("Minimize");
    else
      text = klocale->translate("Restore");
    
    popup_m->changeItem(text, toggleID);
    popup_m->popup(QPoint(x, y));
    popup_m->exec();
  }

}

void DockWidget::toggle_window_state() {

  // restore/hide connect-window
  if(p_xppp != 0L)  {
    if (p_xppp->con_win->isVisible())
      p_xppp->con_win->hide();
    else 
      p_xppp->con_win->show();
  }
}

void DockWidget::show_stats() {
 
  // show statistics
  if(p_xppp != 0L) {
    p_xppp->stats->show();
  }
}

void DockWidget::disconnect() {

  // close ppp-connection
  if(p_xppp != 0L) {
    emit p_xppp->disconnect();
  }
}


#include "docking.moc"






