//
// /home/ms/sidplay/qtsidplay/RCS/AudioDialog.cpp,v
//

#include <qmsgbox.h>

#include "GlobalExt.h"
#include "MixerDialog.h"
#include "AudioDialog.h"

#define Inherited AudioDialogData

// These values must be in the same order as in the constructor.
static int frequencyList[] = 
{
	// Hz
	8000, 11025, 16500, 22050, 27500, 32000, 37500, 44100, 48000,
	0
};

AudioDialog::AudioDialog
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Audio Configuration" );
	setFixedSize(width(),height());
	setIcon(*myMainIcon);
	
	presetButtons();
}

AudioDialog::~AudioDialog()
{
}

void AudioDialog::presetButtons()
{
	bit8Btn->setChecked(myEmuConfig.bitsPerSample==SIDEMU_8BIT);
	bit16Btn->setChecked(myEmuConfig.bitsPerSample==SIDEMU_16BIT);
	monoBtn->setChecked(myEmuConfig.channels==SIDEMU_MONO);
	stereoBtn->setChecked(myEmuConfig.channels==SIDEMU_STEREO);
	// Activate startup value.
	int i = 0, foundIndex = 0;
	while (frequencyList[i] != 0)
	{
		if (myEmuConfig.frequency >= frequencyList[i])
		{
			foundIndex = i;
		}
		i++;
	};
	frequencyBox->setCurrentItem(foundIndex);
}

void AudioDialog::setBitsPerSample(int)
{
	if (bit8Btn->isChecked())
		myEmuConfig.bitsPerSample = SIDEMU_8BIT;
	else  // if (bit8Btn->isChecked())
		myEmuConfig.bitsPerSample = SIDEMU_16BIT;
	setAudioConfig();
}

void AudioDialog::setChannels(int)
{
	if (monoBtn->isChecked())
	{
		myEmuConfig.channels = SIDEMU_MONO;
		myEmuConfig.volumeControl = SIDEMU_NONE;
		myEmuConfig.autoPanning = SIDEMU_NONE;
	}
	else  // if (stereoBtn->isChecked())
		myEmuConfig.channels = SIDEMU_STEREO;
	setAudioConfig();
}

void AudioDialog::setFrequency(int)
{
	myEmuConfig.frequency = frequencyList[frequencyBox->currentItem()];
	setAudioConfig();
}

void AudioDialog::setAudioConfig()
{
	// Reset state of configuration.
	extern int playbackState;
	int playbackStateOld = playbackState;
	playbackState = 0;

	// First init audio driver.
	extern bool initAudio();
	bool ret = initAudio();
	if (!ret)
    {  
		QMessageBox error;
		error.setIcon(QMessageBox::Warning);
		error.setText("Cannot init audio device.");
		error.adjustSize();
		error.show();
		// Set system to inoperational state.
		playbackStateOld = 0;
    }

	// Here update the dialog buttons according to the settings the
	// audio driver accepted.
//	presetButtonValues();
	extern MixerDialog* myMixerDlg;
	myMixerDlg->presetButtons();
	myMixerDlg->adjustMixerMode();
	
	// Restore old state.
	playbackState = playbackStateOld;
}
