//
// /home/ms/sidplay/qtsidplay/xsidplay-1.1-beta3/qt/textfile.cpp,v
//

#include "textfile.h"

#if defined(ANSI)
  #define stricmp strcasecmp
#endif


textFile::textFile(const char* fileName)
{
	// Create input file stream object.
	// Make it binary because of compatibility to text files from any
	// known operating system.
	inFile = new ifstream(fileName, ios::in | ios::bin | ios::nocreate | ios::ate);
#if defined(__POWERPC__)
	leftToLoad = (inFileLen = (inFile->seekg(0,ios::end)).offset());
#else
	leftToLoad = (inFileLen = (unsigned long)inFile->tellg());
#endif
	inFile->seekg(0,ios::beg);
	if ((inFile==0) || (!*inFile))
    {
		status = false;
    }
	else
    {
		status = (isGood = true);
		lineBuf[maxLineLen] = 0;
		lineLen = 0;
		lineNum = 0;
		inBuffer = (moreInBuffer = 0);
		nextLine = 0;
    }
}


textFile::~textFile()
{
	if (inFile != 0)
    {
		inFile->close();
		delete inFile;
		inFile = 0;
    }
}


const char* textFile::retLineBuf()
{ 
	return (const char*)lineBuf;
}


const unsigned long textFile::retLineNum()
{
	return (const)lineNum;
}


int textFile::retLineLen()
{
	return lineLen;
}


bool textFile::endOfFile()
{
	return ((leftToLoad == 0) && (moreInBuffer == 0));
}


textFile::operator bool()
{ 
	return status;
}


bool textFile::readNextLine()
{
	// Next line (or just part of ...) also buffered.
	if ((nextLine != 0) && (moreInBuffer != 0))
	{
		// Now move the next line to the beginning of the buffer.
		for (int i = 0; i < (maxLineLen-(int)(nextLine-lineBuf)); i++ )
	    {
			lineBuf[i] = nextLine[i];
	    }
		inBuffer = moreInBuffer;
		loadFromDisk(lineBuf+moreInBuffer,maxLineLen-moreInBuffer);
		zeroDelimiters();
		lineNum++;
		haveParseCopy = false;
		return true;
	}
	// Nothing left in buffer. Fill the buffer by loading from disk.
	else
	{
		inBuffer = (moreInBuffer = 0);
		if (!loadFromDisk(lineBuf,maxLineLen))
	    {
			// No next line. Reset everything.
			lineLen = 0;
			lineBuf[0] = 0;
			nextLine = 0;
			lineNum = 0;
			haveParseCopy = false;
			return false;
	    }
		else
	    {
			zeroDelimiters();
			lineNum++;
			haveParseCopy = false;
			return true;
	    }
	}
}


bool textFile::loadFromDisk(char* buf, unsigned maxLen)
{
	if (isGood)  // is input file stream object created ?
    {
		if (maxLen <= leftToLoad)
		{
			inFile->read(buf,maxLen);
			inBuffer += maxLen;
			leftToLoad -= maxLen;
		}
		else if (leftToLoad > 0)
		{
			inFile->read(buf,leftToLoad);
			inBuffer += leftToLoad;
			leftToLoad = 0;
		}
		else  // leftToLoad == 0
		{
			// inBuffer += 0;
			return false;
		}
#ifdef WB_DEBUG
		cout << "Loaded " << inBuffer << " bytes." << endl;
#endif
		return true;
    }
	else  // ifstream object not created; cannot load from disk
    {
		return false;
    }
}


// Search input line buffer for next newline sequence. Replace newline
// sequence by a string terminating zero. Skip it and save start of next
// line, if available.
bool textFile::zeroDelimiters()
{
	// Unix: LF = 0x0A
	// MS-Windows, MS-DOS: CR,LF = 0x0D,0x0A
	// MacOS: CR = 0x0D
	bool foundEOL = false;  // assume we do not find a delimiter
	char c;
	char* pCurPos = lineBuf;
	char* pDelimiter;
	for (int n = 0; n < inBuffer; n++)
    {
		c = *pCurPos;
		pDelimiter = pCurPos;
		pCurPos++;                             // skip read character
		if (c == 0x0A)
		{
			*pDelimiter = 0;		     // zero overstrike
			lineLen = pDelimiter - lineBuf;
			nextLine = pCurPos;
			// In case we read more than one line. Calc the remainder.
			moreInBuffer = (int) ((lineBuf+inBuffer)-pCurPos);
			foundEOL = true;
			break;                             // LF found
		}
		else if (c == 0x0D)
		{
			*pDelimiter = 0;                   // zero overstrike
			lineLen = pDelimiter - lineBuf;
			nextLine = pCurPos;
			if (*pCurPos == 0x0A)
			{
				*pCurPos = 0;		     // zero overstrike
				pCurPos++;                     // CR,LF found, skip LF
				nextLine = pCurPos;
			}
			// In case we read more than one line. Calc the remainder.
			moreInBuffer = (int) ((lineBuf+inBuffer)-pCurPos);
			foundEOL = true;
			break;                             // CR or CR,LF found
		}
    }
	// Here we decide to accept some unterminated characters at the end of a
	// file as a valid line (the last one).
	if ( !foundEOL && (inBuffer != 0))
    {
		lineLen = inBuffer;
		moreInBuffer = 0;
		nextLine = 0;
    }
	return foundEOL;
}	


bool textFile::isComment()
{
	if ( !haveParseCopy )
    {
		if ( !createParseCopy() )
		{
			return false;
		}
    }
	if ( (parseBuf[0]==';') ||
		(parseBuf[0]=='#') )
    {
		return true;
    }
	else
    {
		return false;
    }
}


bool textFile::isBlank()
{
	if ( !haveParseCopy )
    {
		if ( !createParseCopy() )
		{
			return false;
		}
    }
	if (parseBuf[0]==0)
    {
		return true;
    }
	else
    {
		return false;
    }
}


bool textFile::isKeyword(const char *keyword)
{
	if ( !haveParseCopy )
    {
		createParseCopy();
    }
	if (myStrNcaseCmp(parseBuf,keyword) == 0)
    {
		nextParseBuf = parseBuf+strlen(keyword);
		if (nextParseBuf > (parseBuf+maxLineLen+1))
		{
			nextParseBuf = parseBuf+maxLineLen;
		}
		return true;
    }
	else
    {
		return false;
    }
}


bool textFile::isAgainKeyword(const char *keyword)
{
	if ( !haveParseCopy )
    {
		// 
		return false;
    }
	if (myStrNcaseCmp(nextParseBuf,keyword) == 0)
    {
		return true;
    }
	else
    {
		return false;
    }
}


bool textFile::createParseCopy()
{
	int di = 0;
	for ( int i = 0; i < lineLen; i++ )
    {
		char c = lineBuf[i];
		parseBuf[di] = c;
		if ( !isspace(c) )
		{
			di++;
		}
    }
	parseBuf[di] = 0;
	nextParseBuf = parseBuf;
	return (haveParseCopy=true);
}


const char* textFile::retParseBuf()
{ 
	if ( !haveParseCopy )
    {
		createParseCopy();
    }
	return (const char*)parseBuf;
}


const char* textFile::retCurParseBuf()
{ 
	if ( !haveParseCopy )
    {
		createParseCopy();
    }
	return (const char*)nextParseBuf;
}


// Case-insensitive comparison of two strings up to ``sizeof(s2)'' characters.
int textFile::myStrNcaseCmp( char* s1, const char* s2 )
{
	char tmp = *(s1 +strlen(s2));
	*(s1 +strlen(s2)) = 0;
	int ret = strcasecmp( s1, s2 );
	*(s1 +strlen(s2)) = tmp;
	return ret;
}
