// -*- C++ -*-
/* This file is part of
* ======================================================
* 
*           LyX, The Document Processor
*        
*           Copyright (C) 1995 Matthias Ettrich
*           Copyright (C) 1995-1998 the LyX Team.
*
*======================================================*/

#ifndef _LATEXFEATURES_H
#define _LATEXFEATURES_H


#ifdef __GNUG__
#pragma interface
#endif

class LString;
class BufferParams; 
class LyXTextClass;

/** The packages and commands that a buffer needs. This struct
  contains an entry for each of the latex packages and
  commands that a buffer might need. This struct is supposed to be
  extended as the need arises. Remember to update the validate function
  in buffer.C and paragraph.C when you do so. */
struct LaTeXFeatures {
	///
	LaTeXFeatures(int n) ;
	///
	~LaTeXFeatures() {
		delete[] layout;
	}
	/// The packaes needed by the document
	LString getPackages(BufferParams const &params);
	/// The macros definitions needed by the document
	LString getMacros(BufferParams const &params);
	/// The definitions needed by the document's textclass
	LString getTClassPreamble(BufferParams const &params);

	///
	void showStruct(BufferParams &params);

	//@Man: Packages
	//@{
	///
	bool color;     // color.sty
	///
	bool graphics;  // graphics.sty
	///
	bool setspace;  // setspace.sty
	///
	bool makeidx;   // makeind.sty
	///
	bool verbatim;  // verbatim.sty
	///
	bool longtable; // longtable.sty
	///
	bool algorithm; // algorithm.sty
	///
	bool rotating;  // rotating.sty
	///
	bool amssymb;   // amssymb.sty
	///
	bool latexsym;   // latexsym.sty
	///
	bool pifont;    // pifont.sty
	///
	bool subfigure;	// subfigure.sty
	///
	bool floatflt;	// floatflt.sty
	//@}

	
	//@Man: Commands
	//@{
	///
	bool lyx;
	///
	bool lyxline;
	/// \noun
	bool noun;
	//@}
	
	//@Man: Quotes
	//@{
	///
	bool quotesinglbase;
	///
	bool quotedblbase;
	///
	bool guilsinglleft;
	///
	bool guilsinglright;
	///
	bool guillemotleft;
	///
	bool guillemotright;
	//@}
	
	//@Man: Math mode
	//@{
	///
	bool amsstyle;
	///
	bool boldsymbol;
	///
	bool binom;
	//@}
	
	//@Man: Layouts
	//@{
	bool *layout;
	//@}
	
	//@Man: Special features
	//@{
	bool LyXParagraphIndent;
	///
	bool NeedLyXFootnoteCode;
	///
	bool NeedLyXMinipageIndent;
	//@}
};

#endif
