// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
extern "C" {
#include <stdio.h>
#include <ctype.h>
}
#include "StyleLexer.h"

StyleLexer::StyleLexer()
        : _done( FALSE )
{
}

StyleLexer::~StyleLexer()
{
}

void StyleLexer::data( const char* bytes,
                       int         length )
{
    uint i;
    
    // Copy incoming data.
    for ( i = 0; (int)i < length; i++ ) {
        _leftover += bytes[i];
    }

    while ( _leftover.length() > 0 ) {

        // Trim leading whitespace.
        while ( isspace( _leftover[0] ) ) {
            _leftover.remove( 0, 1 );
        }

        QString _tok;
        if ( isdigit( _leftover[0] ) ) {
            _tok += _leftover[0];
            int i;
            for ( i = 1; ( i < int( _leftover.length() ) ) && isdigit( _leftover[i] ); i++ ) {
                _tok += _leftover[i];
            }
            if ( ( i == int( _leftover.length() ) ) && ( !_done ) ) {
                // Cannot find end of token (yet).
                return;
            }
            _leftover.remove( 0, _tok.length() );
            emit token( Integer, _tok );
        } else if ( isalpha( _leftover[0] ) ) {
            // String token.
            for ( i = 1; ( i < _leftover.length() ) && ( isalnum( _leftover[i] ) || ( _leftover[i] == '-' ) ); i++ );
            if ( i == _leftover.length() ) {
                return;
            }
            _tok = _leftover.left( i );
            _leftover.remove( 0, i );
            emit token( Identifier, _tok );
        } else if ( _leftover[0] == '{' ) {
            emit token( OpenBrace, "{" );
            _leftover.remove( 0, 1 );
        } else if ( _leftover[0] == '}' ) {
            emit token( CloseBrace, "}" );
            _leftover.remove( 0, 1 );
        } else if ( _leftover[0] == ':' ) {
            emit token( Colon, ":" );
            _leftover.remove( 0, 1 );
        } else if ( _leftover[0] == ',' ) {
            emit token( Comma, "," );
            _leftover.remove( 0, 1 );
        } else if ( _leftover[0] == '(' ) {
            emit token( OpenParen, "(" );
            _leftover.remove( 0, 1 );
        } else if ( _leftover[0] == ')' ) {
            emit token( CloseParen, ')' );
            _leftover.remove( 0, 1 );
        } else if ( _leftover[0] == '=' ) {
            emit token( EqualSign, '=' );
            _leftover.remove( 0, 1 );
        }
    }

    if ( _done ) {
        emit done();
        delete this;
    }
}

void StyleLexer::endOfData()
{
    _done = TRUE;
    data( 0, 0 );
}
