#include "config.h"
#if HAVE_SUN_PARTITION

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <asm/types.h>
#include "byteorder.h"

#include "fdisk.h"

int parse_sun_partition(char *device, int fd)
{
    int i, csum;
    unsigned short *ush;
    struct sun_disklabel {
	__u8  info[128];   /* Informative text string */
        __u8 spare0[14];
        struct sun_info {
	    __u8 spare1;
	    __u8 id;
	    __u8 spare2;
	    __u8 flags;
        } infos[8];
        __u8 spare1[246]; /* Boot information etc. */
	__u16 rspeed;     /* Disk rotational speed */
	__u16 pcylcount;  /* Physical cylinder count */
	__u16 sparecyl;   /* extra sects per cylinder */
	__u8  spare2[4];   /* More magic... */
	__u16 ilfact;     /* Interleave factor */
	__u16 ncyl;       /* Data cylinder count */
	__u16 nacyl;      /* Alt. cylinder count */
	__u16 ntrks;      /* Tracks per cylinder */
	__u16 nsect;      /* Sectors per track */
	__u8  spare3[4];   /* Even more magic... */
	struct sun_partition {
	    __u32 start_cylinder;
	    __u32 num_sectors;
	} partitions[8];
	__u16 magic;      /* Magic number */
	__u16 csum;       /* Label xor'd checksum */
    } * label;		
    struct sun_partition *p;
    unsigned long spc;
#define SUN_LABEL_MAGIC          0xDABE
    unsigned char data[512];

    if (!sread( fd, 0, data ))
	return -1;
    label = (struct sun_disklabel *) data;
    p = label->partitions;
    if (__be16_to_cpu(label->magic) != SUN_LABEL_MAGIC)
	return 0;
    /* Look at the checksum */
    ush = ((unsigned short *) (label+1)) - 1;
    for(csum = 0; ush >= ((unsigned short *) label);)
	csum ^= *ush--;
    if(csum)
	return 0;
    /* All Sun disks have 8 partition entries */
    spc = __be16_to_cpu(label->ntrks) * __be16_to_cpu(label->nsect);
    for(i=0; i < 8; i++, p++) {
	if (__be32_to_cpu(p->num_sectors))
	    fdisk_add_partition(device, i+1,
				PTYPE_PREFIX_SUN | label->infos[i].id,
				__be32_to_cpu(p->num_sectors)/2);
    }
    return 1;
}

#endif /* HAVE_SUN_PARTITION */
