
/*  A Bison parser, made from loadkeys.y
 by  GNU Bison version 1.25
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	EOL	258
#define	NUMBER	259
#define	LITERAL	260
#define	CHARSET	261
#define	KEYMAPS	262
#define	KEYCODE	263
#define	EQUALS	264
#define	PLAIN	265
#define	SHIFT	266
#define	CONTROL	267
#define	ALT	268
#define	ALTGR	269
#define	SHIFTL	270
#define	SHIFTR	271
#define	CTRLL	272
#define	CTRLR	273
#define	COMMA	274
#define	DASH	275
#define	STRING	276
#define	STRLITERAL	277
#define	COMPOSE	278
#define	TO	279
#define	CCHAR	280
#define	ERROR	281
#define	PLUS	282
#define	UNUMBER	283
#define	ALT_IS_META	284

#line 57 "loadkeys.y"

#include <errno.h>
#include <stdio.h>
#include <getopt.h>
#include <string.h>
#include <fcntl.h>
#include <linux/kd.h>
#include <linux/keyboard.h>
#include <sys/ioctl.h>
#include <ctype.h>
#include "paths.h"

#ifndef KT_LETTER
#define KT_LETTER KT_LATIN
#endif

/* name to use in error messages */
char *progname;

/* What keymaps are we defining? */
char defining[MAX_NR_KEYMAPS];
char keymaps_line_seen = 0;
int max_keymap = 0;		/* from here on, defining[] is false */
int alt_is_meta = 0;

/* the kernel structures we want to set or print */
u_short *key_map[MAX_NR_KEYMAPS];
char *func_table[MAX_NR_FUNC];
struct kbdiacr accent_table[MAX_DIACR];
unsigned int accent_table_size = 0;

char key_is_constant[NR_KEYS];
char *keymap_was_set[MAX_NR_KEYMAPS];
char func_buf[4096];		/* should be allocated dynamically */
char *fp = func_buf;

#define U(x) ((x) ^ 0xf000)

#undef ECHO
#include "analyze.c"

#define VERSION "0.94"

static void addmap(int map, int explicit);
static void addkey(int index, int table, int keycode);
static void addfunc(struct kbsentry kbs_buf);
static void compose(int diacr, int base, int res);
static void do_constant(void);
static void loadkeys(void);
static void writebinmap(void);
static void mktable(void);
extern int set_charset(char *charset);
extern int getfd(void);
int key_buf[MAX_NR_KEYMAPS];
int mod;
int unicode_used;
#ifndef YYSTYPE
#define YYSTYPE int
#endif
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		74
#define	YYFLAG		-32768
#define	YYNTBASE	30

#define YYTRANSLATE(x) ((unsigned)(x) <= 284 ? yytranslate[x] : 47)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     4,     6,     8,    10,    12,    14,    16,    18,
    20,    24,    27,    31,    35,    37,    41,    43,    49,    56,
    57,    65,    72,    75,    77,    79,    81,    83,    85,    87,
    89,    91,    93,    99,   100,   103,   105,   107,   109,   112,
   114
};

static const short yyrhs[] = {    -1,
    30,    31,     0,     3,     0,    32,     0,    33,     0,    34,
     0,    43,     0,    39,     0,    37,     0,    38,     0,     6,
    22,     3,     0,    29,     3,     0,     7,    35,     3,     0,
    35,    19,    36,     0,    36,     0,     4,    20,     4,     0,
     4,     0,    21,     5,     9,    22,     3,     0,    23,    25,
    25,    24,    25,     3,     0,     0,    40,    41,     8,     4,
     9,    46,     3,     0,    10,     8,     4,     9,    46,     3,
     0,    41,    42,     0,    42,     0,    11,     0,    12,     0,
    13,     0,    14,     0,    15,     0,    16,     0,    17,     0,
    18,     0,     8,     4,     9,    44,     3,     0,     0,    45,
    44,     0,    46,     0,     4,     0,    28,     0,    27,     4,
     0,     5,     0,    27,     5,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   116,   117,   119,   120,   121,   122,   123,   124,   125,   126,
   128,   133,   138,   143,   144,   146,   152,   157,   169,   174,
   175,   179,   184,   185,   187,   188,   189,   190,   191,   192,
   193,   194,   196,   222,   223,   225,   235,   237,   239,   241,
   243
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","EOL","NUMBER",
"LITERAL","CHARSET","KEYMAPS","KEYCODE","EQUALS","PLAIN","SHIFT","CONTROL","ALT",
"ALTGR","SHIFTL","SHIFTR","CTRLL","CTRLR","COMMA","DASH","STRING","STRLITERAL",
"COMPOSE","TO","CCHAR","ERROR","PLUS","UNUMBER","ALT_IS_META","keytable","line",
"charsetline","altismetaline","keymapline","range","range0","strline","compline",
"singleline","@1","modifiers","modifier","fullline","rvalue0","rvalue1","rvalue", NULL
};
#endif

static const short yyr1[] = {     0,
    30,    30,    31,    31,    31,    31,    31,    31,    31,    31,
    32,    33,    34,    35,    35,    36,    36,    37,    38,    40,
    39,    39,    41,    41,    42,    42,    42,    42,    42,    42,
    42,    42,    43,    44,    44,    45,    46,    46,    46,    46,
    46
};

static const short yyr2[] = {     0,
     0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
     3,     2,     3,     3,     1,     3,     1,     5,     6,     0,
     7,     6,     2,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     5,     0,     2,     1,     1,     1,     2,     1,
     2
};

static const short yydefact[] = {     1,
    20,     3,     0,     0,     0,     0,     0,     0,     0,     2,
     4,     5,     6,     9,    10,     8,     0,     7,     0,    17,
     0,    15,     0,     0,     0,     0,    12,    25,    26,    27,
    28,    29,    30,    31,    32,     0,    24,    11,     0,    13,
     0,    34,     0,     0,     0,     0,    23,    16,    14,    37,
    40,     0,    38,     0,    34,    36,     0,     0,     0,     0,
    39,    41,    33,    35,     0,    18,     0,     0,    22,    19,
     0,    21,     0,     0
};

static const short yydefgoto[] = {     1,
    10,    11,    12,    13,    21,    22,    14,    15,    16,    17,
    36,    37,    18,    54,    55,    56
};

static const short yypact[] = {-32768,
     0,-32768,   -13,     9,    10,    11,    12,   -10,    15,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,    27,-32768,    23,     2,
     1,-32768,    37,    24,    38,    25,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,    19,-32768,-32768,    44,-32768,
     9,    -3,    40,    29,    28,    49,-32768,-32768,-32768,-32768,
-32768,     7,-32768,    51,    -3,-32768,    -3,    52,    31,    48,
-32768,-32768,-32768,-32768,    55,-32768,    56,    -3,-32768,-32768,
    57,-32768,    61,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,-32768,-32768,    21,-32768,-32768,-32768,-32768,
-32768,    30,-32768,     8,-32768,   -52
};


#define	YYLAST		66


static const short yytable[] = {    73,
    50,    51,     2,    40,    65,     3,     4,     5,    19,     6,
    61,    62,    20,    23,    26,    71,    25,    27,    24,    41,
     7,    39,     8,    52,    53,    38,    46,    43,     9,    28,
    29,    30,    31,    32,    33,    34,    35,    28,    29,    30,
    31,    32,    33,    34,    35,    42,    44,    48,    57,    45,
    58,    59,    60,    63,    66,    67,    68,    69,    70,    72,
    74,    49,    64,     0,     0,    47
};

static const short yycheck[] = {     0,
     4,     5,     3,     3,    57,     6,     7,     8,    22,    10,
     4,     5,     4,     4,    25,    68,     5,     3,     8,    19,
    21,    20,    23,    27,    28,     3,     8,     4,    29,    11,
    12,    13,    14,    15,    16,    17,    18,    11,    12,    13,
    14,    15,    16,    17,    18,     9,     9,     4,     9,    25,
    22,    24,     4,     3,     3,    25,     9,     3,     3,     3,
     0,    41,    55,    -1,    -1,    36
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/misc/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 196 "/usr/share/misc/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 11:
#line 129 "loadkeys.y"
{
			    set_charset(kbs_buf.kb_string);
			;
    break;}
case 12:
#line 134 "loadkeys.y"
{
			    alt_is_meta = 1;
			;
    break;}
case 13:
#line 139 "loadkeys.y"
{
			    keymaps_line_seen = 1;
			;
    break;}
case 16:
#line 147 "loadkeys.y"
{
			    int i;
			    for (i = yyvsp[-2]; i<= yyvsp[0]; i++)
			      addmap(i,1);
			;
    break;}
case 17:
#line 153 "loadkeys.y"
{
			    addmap(yyvsp[0],1);
			;
    break;}
case 18:
#line 158 "loadkeys.y"
{
			    if (KTYP(yyvsp[-3]) != KT_FN) {
				fprintf(stderr, "%s: '%s' is not a function key symbol\n",
					progname,
					syms[KTYP(yyvsp[-3])].table[KVAL(yyvsp[-3])]);
				exit(1);
			    }
			    kbs_buf.kb_func = KVAL(yyvsp[-3]);
			    addfunc(kbs_buf);
			;
    break;}
case 19:
#line 170 "loadkeys.y"
{
			    compose(yyvsp[-4], yyvsp[-3], yyvsp[-1]);
			;
    break;}
case 20:
#line 174 "loadkeys.y"
{ mod = 0; ;
    break;}
case 21:
#line 176 "loadkeys.y"
{
			    addkey(yyvsp[-3], mod, yyvsp[-1]);
			;
    break;}
case 22:
#line 180 "loadkeys.y"
{
			    addkey(yyvsp[-2], 0, yyvsp[0]);
			;
    break;}
case 25:
#line 187 "loadkeys.y"
{ mod |= (1 << KG_SHIFT);	;
    break;}
case 26:
#line 188 "loadkeys.y"
{ mod |= (1 << KG_CTRL);	;
    break;}
case 27:
#line 189 "loadkeys.y"
{ mod |= (1 << KG_ALT);		;
    break;}
case 28:
#line 190 "loadkeys.y"
{ mod |= (1 << KG_ALTGR);	;
    break;}
case 29:
#line 191 "loadkeys.y"
{ mod |= (1 << KG_SHIFTL);	;
    break;}
case 30:
#line 192 "loadkeys.y"
{ mod |= (1 << KG_SHIFTR);	;
    break;}
case 31:
#line 193 "loadkeys.y"
{ mod |= (1 << KG_CTRLL);	;
    break;}
case 32:
#line 194 "loadkeys.y"
{ mod |= (1 << KG_CTRLR);	;
    break;}
case 33:
#line 197 "loadkeys.y"
{
	    int i, j;

	    if (keymaps_line_seen) {
		i = 0;
		for (j = 0; j < max_keymap; j++)
		  if (defining[j]) {
		      if (rvalct != 1 || i == 0)
			addkey(yyvsp[-3], j, (i < rvalct) ? key_buf[i] : K_HOLE);
		      i++;
		  }
		if (i < rvalct) {
		    fprintf(stderr, "%s: too many (%d) entries on one line\n",
			    progname, rvalct);
		    exit(1);
		}
	    } else
	      for (i = 0; i < rvalct; i++)
		addkey(yyvsp[-3], i, key_buf[i]);

	    if (rvalct == 1)
	      key_is_constant[yyvsp[-3]] = 1;
	;
    break;}
case 36:
#line 226 "loadkeys.y"
{
			    if (rvalct >= MAX_NR_KEYMAPS) {
				fprintf(stderr, "%s: too many keydefinitions on one line\n",
					progname);
				exit(1);
			    }
			    key_buf[rvalct++] = yyvsp[0];
			;
    break;}
case 37:
#line 236 "loadkeys.y"
{yyval=yyvsp[0];;
    break;}
case 38:
#line 238 "loadkeys.y"
{yyval=(yyvsp[0] ^ 0xf000); unicode_used=1;;
    break;}
case 39:
#line 240 "loadkeys.y"
{yyval=K(KT_LETTER, KVAL(yyvsp[0]));;
    break;}
case 40:
#line 242 "loadkeys.y"
{yyval=yyvsp[0];;
    break;}
case 41:
#line 244 "loadkeys.y"
{yyval=K(KT_LETTER, KVAL(yyvsp[0]));;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 498 "/usr/share/misc/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 246 "loadkeys.y"
			

void
usage(void) {
	fprintf(stderr, "\
loadkeys version " VERSION "\

Usage: loadkeys [option...] [mapfile...]

valid options are:

        -c --clearcompose clear kernel compose table
	-d --default	  load \"" DEFMAP "\"
	-h --help	  display this help text
        -m --mktable      output a \"defkeymap.c\" to stdout
	-s --clearstrings clear kernel string table
        -v --verbose      report the changes
");
	exit(1);
}

char **args;
int optb = 0;
int optd = 0;
int optm = 0;
int opts = 0;
int verbose = 0;
int nocompose = 0;

int
main(unsigned int argc, char *argv[]) {
	const char *short_opts = "bcdhmsv";
	const struct option long_opts[] = {
		{ "binmap",    no_argument, NULL, 'b' },
		{ "clearcompose", no_argument, NULL, 'c' },
	        { "default",    no_argument, NULL, 'd' },
		{ "help",	no_argument, NULL, 'h' },
		{ "mktable",    no_argument, NULL, 'm' },
		{ "clearstrings", no_argument, NULL, 's' },
		{ "verbose",    no_argument, NULL, 'v' },
		{ NULL, 0, NULL, 0 }
	};
	int c;

	progname = argv[0];

	while ((c = getopt_long(argc, argv,
		short_opts, long_opts, NULL)) != -1) {
		switch (c) {
		        case 'b':
		                optb = 1;
				break;
		        case 'c':
		                nocompose = 1;
				break;
		        case 'd':
		    		optd = 1;
				break;
		        case 'm':
		                optm = 1;
				break;
			case 's':
				opts = 1;
				break;
			case 'v':
				verbose = 1;
				break;
			case 'h':
			case '?':
				usage();
		}
	}

	args = argv + optind - 1;
	unicode_used = 0;
	yywrap();	/* set up the first input file, if any */
	if (yyparse()) {
		fprintf(stderr, "syntax error in map file\n");
		if(!optm)
		  fprintf(stderr, "key bindings not changed\n");
		exit(1);
	}
	do_constant();
	if(optm)
	        mktable();
	else if(optb)
		writebinmap();
	else
	        loadkeys();
	exit(0);
}

extern char pathname[];

int
yyerror(char *s) {
	fprintf(stderr, "%s:%d: %s\n",
		pathname, line_nr, s);
	return(0);
}

char *dirpath[] = { "", DATADIR "/" KEYMAPDIR "/", KERNDIR "/", 0 };
char *suffixes[] = { "", ".map", 0 };
extern FILE *findfile(char *fnam, char **dirpath, char **suffixes);

#undef yywrap
int
yywrap(void) {
	FILE *f;
	static int first_file = 1; /* ugly kludge flag */

	line_nr = 1;
	if (optd) {
	        /* first read default map */
	        optd = 0;
	        if((f = findfile(DEFMAP, dirpath, suffixes)) == NULL) {
		    fprintf(stderr, "Cannot find %s\n", DEFMAP);
		    exit(1);
		}
		goto gotf;
	}
	if (*args)
		args++;
	if (!*args)
		return 1;
	if (!strcmp(*args, "-")) {
		f = stdin;
		strcpy(pathname, "<stdin>");
	} else if ((f = findfile(*args, dirpath, suffixes)) == NULL) {
		fprintf(stderr, "cannot open file %s\n", *args);
		exit(1);
	}
	/*
		Can't use yyrestart if this is called before entering yyparse()
		I think assigning directly to yyin isn't necessarily safe in
		other situations, hence the flag.
	*/
      gotf:
	fprintf(stderr, "Loading %s\n", pathname);
	if (first_file) {
		yyin = f;
		first_file = 0;
	} else
		yyrestart(f);
	return 0;
}

static void
addmap(int i, int explicit) {
	if (i < 0 || i >= MAX_NR_KEYMAPS) {
	    fprintf(stderr, "%s: addmap called with bad index %d\n",
		    progname, i);
	    exit(1);
	}
	if (!defining[i]) {
	    if (keymaps_line_seen && !explicit) {
		fprintf(stderr, "%s: adding map %d violates explicit keymaps line\n",
			progname, i);
		exit(1);
	    }
	    defining[i] = 1;
	    if (max_keymap <= i)
	      max_keymap = i+1;
	}
}

static void
addkey(int index, int table, int keycode) {
	int i;

	if (keycode == -1)
		return;
        if (index < 0 || index >= NR_KEYS) {
	        fprintf(stderr, "%s: addkey called with bad index %d\n",
			progname, index);
		exit(1);
	}
        if (table < 0 || table >= MAX_NR_KEYMAPS) {
	        fprintf(stderr, "%s: addkey called with bad table %d\n",
			progname, table);
		exit(1);
	}
	if (!defining[table])
	  addmap(table, 0);
	if (!key_map[table]) {
	        key_map[table] = (u_short *) malloc(NR_KEYS * sizeof(u_short));
		if (!key_map[table]) {
		    fprintf(stderr, "%s: Out of memory.\n", progname);
		    exit(1);
		}
		for (i = 0; i < NR_KEYS; i++)
		  (key_map[table])[i] = K_HOLE;
	}
	if (!keymap_was_set[table]) {
	        keymap_was_set[table] = (char *) malloc(NR_KEYS);
		if (!keymap_was_set[table]) {
		    fprintf(stderr, "%s: Out of memory.\n", progname);
		    exit(1);
		}
		for (i = 0; i < NR_KEYS; i++)
		  (keymap_was_set[table])[i] = 0;
	}

	if (alt_is_meta && keycode == K_HOLE && (keymap_was_set[table])[index])
		return;

	(key_map[table])[index] = keycode;
	(keymap_was_set[table])[index] = 1;

	if (alt_is_meta) {
	     int alttable = table | (1 << KG_ALT);
	     int type = KTYP(keycode);
	     int val = KVAL(keycode);
	     char *p;
	     if (alttable != table && defining[alttable] &&
		 (type == KT_LATIN || type == KT_LETTER) && val < 128)
		  addkey(index, alttable, K(KT_META, val));
	}
}

static void
addfunc(struct kbsentry kbs) {
        int sh, i;
	char *p, *q, *r;

        if (kbs.kb_func >= MAX_NR_FUNC) {
	        fprintf(stderr, "%s: addfunc called with bad func %d\n",
			progname, kbs.kb_func);
		exit(1);
	}
	if ((q = func_table[kbs.kb_func])) { /* throw out old previous def */
	        sh = strlen(q) + 1;
		p = q + sh;
		while (p < fp)
		        *q++ = *p++;
		fp -= sh;
	}
	p = func_buf;                        /* find place for new def */
	for (i = 0; i < kbs.kb_func; i++)
	        if (func_table[i]) {
		        p = func_table[i];
			while(*p++);
		}
	func_table[kbs.kb_func] = p;
        sh = strlen(kbs.kb_string) + 1;
	if (fp + sh > func_buf + sizeof(func_buf)) {
	        fprintf(stderr, "%s: addfunc: func_buf overflow\n", progname);
		exit(1);
	}
	q = fp;
	fp += sh;
	r = fp;
	while (q > p)
	        *--r = *--q;
	strcpy(p, kbs.kb_string);
	for (i++; i < MAX_NR_FUNC; i++)
	        if (func_table[i])
		        func_table[i] += sh;
}

static void
compose(int diacr, int base, int res) {
        struct kbdiacr *p;
        if (accent_table_size == MAX_DIACR) {
	        fprintf(stderr, "compose table overflow\n");
		exit(1);
	}
	p = &accent_table[accent_table_size++];
	p->diacr = diacr;
	p->base = base;
	p->result = res;
}

static int
defkeys(int fd) {
	struct kbentry ke;
	int ct = 0;
	int i,j,fail;
	int oldm;

	if (unicode_used) {
	     /* Switch keyboard mode for a moment -
		do not complain about errors.
		Do not attempt a reset if the change failed. */
	     if (ioctl(fd, KDGKBMODE, &oldm)
	        || (oldm != K_UNICODE && ioctl(fd, KDSKBMODE, K_UNICODE)))
		  oldm = K_UNICODE;
	}

	for(i=0; i<MAX_NR_KEYMAPS; i++) {
	    if (key_map[i]) {
		for(j=0; j<NR_KEYS; j++) {
		    if ((keymap_was_set[i])[j]) {
			ke.kb_index = j;
			ke.kb_table = i;
			ke.kb_value = (key_map[i])[j];

			fail = ioctl(fd, KDSKBENT, (unsigned long)&ke);
			if (fail) {
			    if (errno == EPERM) {
				fprintf(stderr, "Keymap %d: Permission denied\n", i);
				j = NR_KEYS;
				continue;
			    }
			    perror("KDSKBENT");
			} else
			  ct++;
			if(verbose)
			  printf("keycode %d, table %d = %d%s\n", j, i, (key_map[i])[j],
				 fail ? "    FAILED" : "");
			else if (fail)
			  fprintf(stderr, "failed to bind key %d to value %d\n",
				  j, (key_map[i])[j]);
		    }
		}
	    } else if (keymaps_line_seen && !defining[i]) {
		/* deallocate keymap */
		ke.kb_index = 0;
		ke.kb_table = i;
		ke.kb_value = K_NOSUCHMAP;
#if 0
		if (verbose)
		  printf("deallocate keymap %d\n", i);
#endif
		if(ioctl(fd, KDSKBENT, (unsigned long)&ke)) {
		    if (errno != EINVAL) {
			perror("KDSKBENT");
			fprintf(stderr,
				"%s: could not deallocate keymap %d\n",
				progname, i);
			exit(1);
		    }
		    /* probably an old kernel */
		    /* clear keymap by hand */
		    for (j = 0; j < NR_KEYS; j++) {
			ke.kb_index = j;
			ke.kb_table = i;
			ke.kb_value = K_HOLE;
			if(ioctl(fd, KDSKBENT, (unsigned long)&ke)) {
			    if (errno == EINVAL && i >= 16)
			      break; /* old kernel */
			    perror("KDSKBENT");
			    fprintf(stderr,
				    "%s: cannot deallocate or clear keymap\n",
				    progname);
			    exit(1);
			}
		    }
		}
	    }
	}

	if(unicode_used && oldm != K_UNICODE) {
	     if (ioctl(fd, KDSKBMODE, oldm)) {
		  fprintf(stderr, "%s: failed to restore keyboard mode\n",
			  progname);
	     }
	     fprintf(stderr, "%s: warning: this map uses Unicode symbols\n"
		             "    (perhaps you want to do `kbd_mode -u'?)\n",
		     progname);
	}
	return ct;
}

static char *
ostr(char *s) {
	int lth = strlen(s);
	char *ns0 = malloc(4*lth + 1);
	char *ns = ns0;

	if (!ns0) {
	  fprintf(stderr, "out of memory?\n");
	  return "";
	}
	while(*s) {
	  switch(*s) {
	  case '\n':
	    *ns++ = '\\';
	    *ns++ = 'n';
	    break;
	  case '\033':
	    *ns++ = '\\';
	    *ns++ = '0';
	    *ns++ = '3';
	    *ns++ = '3';
	    break;
	  default:
	    *ns++ = *s;
	  }
	  s++;
	}
	*ns = 0;
	return ns0;
}

static int
deffuncs(int fd){
        int i, ct = 0;
	char *p;

        for (i = 0; i < MAX_NR_FUNC; i++) {
	    kbs_buf.kb_func = i;
	    if ((p = func_table[i])) {
		strcpy(kbs_buf.kb_string, p);
		if (ioctl(fd, KDSKBSENT, (unsigned long)&kbs_buf))
		  fprintf(stderr, "failed to bind string '%s' to function %s\n",
			  ostr(kbs_buf.kb_string), syms[KT_FN].table[kbs_buf.kb_func]);
		else
		  ct++;
	    } else if (opts) {
		kbs_buf.kb_string[0] = 0;
		if (ioctl(fd, KDSKBSENT, (unsigned long)&kbs_buf))
		  fprintf(stderr, "failed to clear string %s\n",
			  syms[KT_FN].table[kbs_buf.kb_func]);
		else
		  ct++;
	    }
	  }
	return ct;
}

static int
defdiacs(int fd){
        struct kbdiacrs kd;
	int i;

	kd.kb_cnt = accent_table_size;
	if (kd.kb_cnt > MAX_DIACR) {
	    kd.kb_cnt = MAX_DIACR;
	    fprintf(stderr, "too many compose definitions\n");
	}
	for (i = 0; i < kd.kb_cnt; i++)
	    kd.kbdiacr[i] = accent_table[i];

	if(ioctl(fd, KDSKBDIACR, (unsigned long) &kd)) {
	    fprintf(stderr, "KDSKBDIACR failed\n");
	    perror("");
	    exit(1);
	}
	return kd.kb_cnt;
}

static void
do_constant (void) {
	int i, j, r0 = 0;

	if (keymaps_line_seen)
	    while (r0 < max_keymap && !defining[r0])
	      r0++;

	for (i=0; i<NR_KEYS; i++)
	  if (key_is_constant[i]) {
	      u_short key;
	      int typ, val;
	      if (!key_map[r0]) {
		  fprintf(stderr, "%s: impossible error in do_constant\n", progname);
		  exit(1);
	      }
	      key = (key_map[r0])[i];
	      typ = KTYP(key);
	      val = KVAL(key);
	      if (typ != KT_LATIN && typ != KT_LETTER) {
		  for (j=r0+1; j<max_keymap; j++)
		    if(defining[j] && (!(keymap_was_set[j]) || !(keymap_was_set[j])[i]))
		      addkey(i, j, key);
	      } else if ((val >= 'a' && val <= 'z') || (val >= 'A' && val <= 'Z')) {
		  u_short defs[16];
		  defs[0] = K(KT_LETTER, val);
		  defs[1] = K(KT_LETTER, val ^ 32);
		  defs[2] = defs[0];
		  defs[3] = defs[1];
		  for(j=4; j<8; j++)
		    defs[j] = K(KT_LATIN, val & ~96);
		  for(j=8; j<16; j++)
		    defs[j] = K(KT_META, KVAL(defs[j-8]));
		  for(j=0; j<max_keymap; j++) {
		      if (!defining[j])
			continue;
		      if (j > 0 && keymap_was_set[j] && (keymap_was_set[j])[i])
			continue;
		      addkey(i, j, defs[j%16]);
		  }
	      }
	  }
}

static void
loadkeys (void) {
        int fd;
        int keyct, funcct, diacct;

	fd = getfd();
	keyct = defkeys(fd);
	funcct = deffuncs(fd);
	if (accent_table_size > 0 || nocompose)
	  diacct = defdiacs(fd);
	if (verbose) {
	        printf("\nChanged %d key%s and %d string%s.\n",
		       keyct, (keyct == 1) ? "" : "s",
		       funcct, (funcct == 1) ? "" : "s");
		if (accent_table_size > 0 || nocompose)
		  printf("Loaded %d compose definition%s.\n",
			 diacct, (diacct == 1) ? "" : "s");
		else
		  printf("(No change in compose definitions.)\n");
	}
}

static void
writebinmap(void) {
	int i;
	char flags[MAX_NR_KEYMAPS],magic[]="bkeymap";

	memset(flags, 0, sizeof(flags));
	for(i=0; i<MAX_NR_KEYMAPS; i++) {
	    if (key_map[i]) flags[i]=1;
	}
	write(1,magic,7);
	write(1,flags,sizeof(flags));
	for(i=0; i<MAX_NR_KEYMAPS; i++) {
	    if (key_map[i])
		write(1,key_map[i],NR_KEYS * sizeof(u_short));
	}
}

/*
 * mktable.c
 *
 */
static char *modifiers[8] = {
    "shift", "altgr", "ctrl", "alt", "shl", "shr", "ctl", "ctr"
};

static char *mk_mapname(char mod) {
    static char buf[60];
    int i;

    if (!mod)
      return "plain";
    buf[0] = 0;
    for (i=0; i<8; i++)
      if (mod & (1<<i)) {
	  if (buf[0])
	    strcat(buf, "_");
	  strcat(buf, modifiers[i]);
      }
    return buf;
}


static void
outchar (unsigned char c, int comma) {
        printf("'");
        printf((c == '\'' || c == '\\') ? "\\%c" : isgraph(c) ? "%c"
	       : "\\%03o", c);
	printf(comma ? "', " : "'");
}

static void
mktable () {
	int i, imax, j;

	struct kbsentry kbs;
	u_char *p;
	int maxfunc;
	unsigned int keymap_count = 0;

	printf(
"/* Do not edit this file! It was automatically generated by   */\n");
	printf(
"/*    loadkeys --mktable defkeymap.map > defkeymap.c          */\n\n");
	printf("#include <linux/types.h>\n");
	printf("#include <linux/keyboard.h>\n");
	printf("#include <linux/kd.h>\n\n");

	for (i = 0; i < MAX_NR_KEYMAPS; i++)
	  if (key_map[i]) {
	      keymap_count++;
	      if (i)
		   printf("static ");
	      printf("u_short %s_map[NR_KEYS] = {", mk_mapname(i));
	      for (j = 0; j < NR_KEYS; j++) {
		  if (!(j % 8))
		    printf("\n");
		  printf("\t0x%04x,", U((key_map[i])[j]));
	      }
	      printf("\n};\n\n");
	  }

	for (imax = MAX_NR_KEYMAPS-1; imax > 0; imax--)
	  if (key_map[imax])
	    break;
	printf("ushort *key_maps[MAX_NR_KEYMAPS] = {");
	for (i = 0; i <= imax; i++) {
	    printf((i%4) ? " " : "\n\t");
	    if (key_map[i])
	      printf("%s_map,", mk_mapname(i));
	    else
	      printf("0,");
	}
	if (imax < MAX_NR_KEYMAPS-1)
	  printf("\t0");
	printf("\n};\n\nunsigned int keymap_count = %d;\n\n", keymap_count);

	printf("\
/*
 * Philosophy: most people do not define more strings, but they who do
 * often want quite a lot of string space. So, we statically allocate
 * the default and allocate dynamically in chunks of 512 bytes.
 */

");
	for (maxfunc = MAX_NR_FUNC; maxfunc; maxfunc--)
	  if(func_table[maxfunc-1])
	    break;

	printf("char func_buf[] = {\n");
	for (i = 0; i < maxfunc; i++) {
	    p = func_table[i];
	    if (p) {
		printf("\t");
		for ( ; *p; p++)
		        outchar(*p, 1);
		printf("0, \n");
	    }
	}
	if (!maxfunc)
	  printf("\t0\n");
	printf("};\n\n");

	printf("\
char *funcbufptr = func_buf;
int funcbufsize = sizeof(func_buf);
int funcbufleft = 0;          /* space left */

");

	printf("char *func_table[MAX_NR_FUNC] = {\n");
	for (i = 0; i < maxfunc; i++) {
	    if (func_table[i])
	      printf("\tfunc_buf + %d,\n", func_table[i] - func_buf);
	    else
	      printf("\t0,\n");
	}
	if (maxfunc < MAX_NR_FUNC)
	  printf("\t0,\n");
	printf("};\n");

	printf("\nstruct kbdiacr accent_table[MAX_DIACR] = {\n");
	for (i = 0; i < accent_table_size; i++) {
	        printf("\t{");
	        outchar(accent_table[i].diacr, 1);
		outchar(accent_table[i].base, 1);
		outchar(accent_table[i].result, 0);
		printf("},");
		if(i%2) printf("\n");
	}
	if(i%2) printf("\n");
	printf("};\n\n");
	printf("unsigned int accent_table_size = %d;\n",
	       accent_table_size);

	exit(0);
}


