#ifndef NLINDEX_H
#define NLINDEX_H

#include "nodelist.h"

#define INDEX "index"

#ifdef HAS_NDBM_H
#include <ndbm.h>
extern DBM *nldb;
#endif
extern int openstatus;

#if defined(USE_DBZ)
struct _zoneentry
{
  off_t beg, end;
  unsigned short zone;
};

struct _zonelist
{
  struct _zoneentry *entryvector;
  int entries, size;
};
#endif

extern struct _nodelist
{
  char *domain;
  FILE *fp;
#if defined(USE_DBZ)
  struct _zonelist zonelist;
#endif
} *nodevector;

struct _ixentry {
	unsigned short zone;
	unsigned short net;
	unsigned short node;
	unsigned short point;
};

struct _loc {
	off_t off;
	unsigned short nlnum;
	unsigned short hub;
#if defined(USE_DBZ)
	unsigned short net;
	unsigned short node;
#endif
};

extern struct _pkey {
	char *key;
	unsigned char type;
	unsigned char pflag;
} pkey[];

extern struct _fkey fkey[];

extern int initnl(void);

#endif
