/*
 * Copyright (c) 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: */


#include "IluJava_JMon.h"


#ifndef WIN32
/* **************** Using ONI with system monitors on Solaris ************* */

static ILUJAVA_JMON_PTR _ilujava_mon_freelist = 0;
static ILUJAVA_JMON_PTR _ilujava_mon_mon = 0;

ILUJAVA_JMON_PTR ilujava_mon_allocate() 
{
    ILUJAVA_JMON_PTR m = 0; 
    if (_ilujava_mon_freelist) {
        /* _ilujava_mon_mon is valid because this is
         * entered only if there is/was a monitor on the free list.
         * If the free list is used, that monitor must have 
         * been created previously.
         */
        ILUJAVA_JMON_PTR meta = _ilujava_mon_mon;
        ILUJAVA_MON_ENTER(meta);
        m = _ilujava_mon_freelist;
        if (m) {
            _ilujava_mon_freelist = *(ILUJAVA_JMON_PTR*) m;
            *(ILUJAVA_JMON_PTR*) m = 0;
        }
        ILUJAVA_MON_EXIT(meta);
    }
    if (m) return m;
    m = (ILUJAVA_JMON_PTR) java_sysMalloc(ILUJAVA_MON_SIZEOF());
    memset((char *)m, 0, ILUJAVA_MON_SIZEOF());
    ILUJAVA_MON_INIT(m);
    if (_ilujava_mon_mon == 0) {
        /* Race condition if first calls to this are concurrent.
         * No problem because ilu doesn't fork before some monitors 
         * have been created. 
         */
        _ilujava_mon_mon = m;
        m = ilujava_mon_allocate();
    }
    return m;
}


void ilujava_mon_destroyDeallocate(ILUJAVA_JMON_PTR m)
{
    /* 
     * Since we are not using java objects for the monitors
     * we don't have to worry about bad effects from finalization
     *
     * Basicly because I don't reliably understand how to destroy monitors
     * (do they need to be locked or not?) we simply put them onto a free list
     * and re-use them.
     *
     * Rely on ilu that it never destroys a monitor while in use
     */
    ILUJAVA_JMON_PTR meta = _ilujava_mon_mon;
    ILUJAVA_MON_ENTER(meta);
    ( * (ILUJAVA_JMON_PTR*) m) = _ilujava_mon_freelist;
    _ilujava_mon_freelist = m;
    ILUJAVA_MON_EXIT(meta);
}


/* **************** END Using ONI with system monitors on Solaris ************* */



#else

/* we're on WIN32 */



#ifdef RNI
/* **************** we're using Microsoft's Raw Native Interface **************** */

ILUJAVA_JMON_PTR ilujava_mon_allocate() 
{
    /* Create an instance of a java Object, and get a strong reference on it */
	HObject* p_newObject;
	HObject** pp_newObject;
	p_newObject = execute_java_constructor(EE(), "java/lang/Object", NULL, "()");
	pp_newObject = GCNewHandle(p_newObject);
	return pp_newObject;
}


void ilujava_mon_destroyDeallocate(ILUJAVA_JMON_PTR m)
{
    /* remove the strong reference to the java object */
	GCFreeHandle(m);
}


/* **************** END we're using Microsoft's Raw Native Interface ************ */

#else

/* **************** assume using ONI with java monitors on Win32 **************** */

static ILUJAVA_JMON_PTR _ilujava_mon_freelist = 0;
static ILUJAVA_JMON_PTR _ilujava_mon_mon = 0;

ILUJAVA_JMON_PTR ilujava_mon_allocate() 
{
    /* Rely on the java implementation to use a hash
     * to allocate the real lock.  By allocating a new
     * object we make sure that we are using an unique
     * key used for the hash table.
     *
     * Monitors are not initialized; the java objects used
     * as monitors are neither...
     *
     * We are not using java objects however to make sure
     * our objects won't get garbage collected.
     *
     */
    ILUJAVA_JMON_PTR m = 0; 
    if (_ilujava_mon_freelist) {
        /* _ilujava_mon_mon is valid because this is
         * entered only if there is/was a monitor on the free list.
         * If the free list is used, that monitor must have 
         * been created previously.
         */
        ILUJAVA_JMON_PTR meta = _ilujava_mon_mon;
        ILUJAVA_MON_ENTER(meta);
        m = _ilujava_mon_freelist;
        if (m) {
            _ilujava_mon_freelist = *(ILUJAVA_JMON_PTR*) m;
            *(ILUJAVA_JMON_PTR*) m = 0;
        }
        ILUJAVA_MON_EXIT(meta);
    }
    if (m) return m;
    m = (ILUJAVA_JMON_PTR) ilu_malloc(_ILUJAVA_MONSZ);
    memset((char*) m, 0, _ILUJAVA_MONSZ);
    if (_ilujava_mon_mon == 0) {
        /* Race condition if first calls to this are concurrent.
         * No problem because ilu doesn't fork before some monitors 
         * have been created. 
         */
        _ilujava_mon_mon = m;
        m = ilujava_mon_allocate();
    }
    return m;
}


void ilujava_mon_destroyDeallocate(ILUJAVA_JMON_PTR m)
{
    /* 
     * Since we are not using java objects for the monitors
     * we don't have to worry about bad effects from finalization
     *
     * Basicly because I don't reliably understand how to destroy monitors
     * (do they need to be locked or not?) we simply put them onto a free list
     * and re-use them.
     *
     * Rely on ilu that it never destroys a monitor while in use
     */
    ILUJAVA_JMON_PTR meta = _ilujava_mon_mon;
    ILUJAVA_MON_ENTER(meta);
    ( * (ILUJAVA_JMON_PTR*) m) = _ilujava_mon_freelist;
    _ilujava_mon_freelist = m;
    ILUJAVA_MON_EXIT(meta);
}


/* **************** END assume using ONI with java monitors on Win32 ************ */

#endif

#endif /* we're on WIN32 */

