.TH omniidl 1 "17.05.95" "Olivetti Research Ltd"
.SH NAME
omniidl \- omniORB idl compiler
.SH SYNOPSIS
.B omniidl
[ options ]* file [file]*
.SH DESCRIPTION
The omniidl command invokes the omniORB idl compiler. It takes CORBA IDL
definitions from the input file(s) and produces C++ stubs. For each input
file, three stub files are produced: a header, a client stub and a server
stub. Together they provide the basis to implement CORBA objects with
interfaces defined in the IDL definitions. By default, the three files are
named by appending suffix
.B .hh
,
.B C.cc
and
.B S.cc
to the base name of the input respectively. These suffixes can be changed
by command line options (see below).

This idl compiler produces C++ stubs in conformance to the specification
defined in `Orbix IDL to C++ Mapping'. The omniORB runtime is used to
perform remote invocations. At the moment, the IDL primitive types: 
.B float
,
.B double
are not supported by the runtime. By default, the compiler will generate an
error message and abort if it encounters any of these types in the input
file. Support for these types can be enabled by command line options (see
below).

The input files are processed by the CPP preprocessor before they are
parsed by the compiler.

.SH OPTIONS
.TP 15
.B \-A
Generate support for use of IDL type any. This new option replaces -a.
.TP
.B \-B
enables support for BOAImpl approach
.TP
.BI \-D name[=value]
defines name for preprocessor
.TP
.BI \-E
runs preprocessor only, prints on stdout
.TP
.BI \-I dir
includes dir in search path for preprocessor
.TP
.BI \-U name
undefines name for preprocessor
.TP
.BI \-V
prints version information and exits
.TP
.BI \-a
enables support for
.B any
.TP
.BI \-c suffix
specifies non-default suffix for client stub file
.TP
.BI \-f
enables support for
.B float
and
.B double
.TP
.BI \-h suffix
specifies non-default suffix for header file
.TP
.BI \-s suffix
specifies non-default suffix for server stub file
.TP
.BI \-S
do not suppress sequence\<string\> stub code
.TP
.BI \-u
prints the usage message and exits
.TP
.BI \-v
traces compilation stages
.TP
.BI \-w
suppresses IDL compiler warning messages

 
.SH SEE ALSO

Orbix IDL to C++ Mapping, Release 1.3 Nov 1994

omniORB- Distributed Object Computing for ATMos, Damian Gilmurray, Olivetti
Research Ltd

.SH KNOWN BUGS

Nested structure or union definition is not supported.

.nf
For example, 
   struct a {
     long foo1;
     struct b {
        long foo2;
     } foo3;
   };

The solution is to remove the nesting:

    struct b {
      long foo2;
    };
    struct a {
      long foo1;
      b foo3;
    };
.fi

The compiler would not generate any declaration for a type foo that is not
defined in the main file, i.e. the type is defined in an included file.
This rule also applies to sequence<foo>. Normally, this is not a problem
because the header file produced from the main file will contain a line to
include the header of the included file, hence including all the types
defined in the latter. However, a problem will arise if sequence<foo> is
not used in the included file but used in the main file because no
declaration will be generated for sequence<foo>. The work around is to
add a typedef statement for sequence<foo> in the included file.

Although omniidl and the Orbix idl compiler are both purported to conform
to the same C++ mapping specification, there is a discrepancy in
the code generated by omniidl and the Orbix idl. These are largely due to
bugs in the current version of Orbix idl (version number is 1.3) and may
disappear in future releases of Orbix.

The following IDL statments:
.nf
    // IDL
    typedef long FRED;
    typedef sequence<FRED,10> FredSeq1;
    typedef sequence<long,10> FredSeq2;
.fi

are mapped by omniidl to:
.nf
    // C++
    typedef long FRED;
    typedef _IDL_SEQUENCE_long _IDL_SEQUENCE_FredSeq1;
    typedef _IDL_SEQUENCE_long _IDL_SEQUENCE_FredSeq2;
.fi

Notice that _IDL_SEQUENCE_FredSeq1 and _IDL_SEQUENCE_FredSeq2 are type
equivalent. This code generation rule is required by the C++ mapping
specification.

Orbix idl produces separate declarations for _IDL_SEQUENCE_FredSeq1 and
_IDL_SEQUENCE_FredSeq2 and the two types are not type equivalent.


.SH ACKNOWLEDGEMENT
The compiler front end is based on the source code donated by SunSoft,
Inc., Mountain View, California, to OMG. The release is identified by the
version number 1.3.

.SH AUTHOR
Sai-Lai Lo, Olivetti Research Ltd
