#!/bin/csh -f
#-- Part of SmallEiffel -- Read DISCLAIMER file -- Copyright (C) 
#-- Dominique COLNET and Suzanne COLLIN -- colnet@loria.fr
#--
#
# To INSTALL SmallEiffel on UNIX like platforms (including LINUX).
#
# If you have the gcc compiler, set the environment variable
# "SmallEiffel" to the appropriate value and simply
# run this INSTALL file (That's all if you have gcc :-).
#
# If you don't have gcc, you must procede manually doing the
# following :
#  - edit and run each SmallEiffel/bin_c/*.make file. Each call
#    to gcc must be changed by a call to your favorite C compiler.
#  - move each executable file in the SmallEiffel/bin directory.
#
# That's all. Good luck :-)
#
# Here the script to run if you have gcc :
if (!($?SmallEiffel)) then
	echo "Environment Variable 'SmallEiffel' not set."
	exit 1
endif
if (! -d $SmallEiffel) then
	echo ${SmallEiffel} "not found."
	exit 1
endif
cd ${SmallEiffel}/bin_c
foreach fmake (*.make)
	set cmd=$fmake:r
	if (!(-f ${cmd})) then
		echo Running ${fmake}
		set verbose=1
		source ${fmake}
	endif
	mv -f ../bin/${cmd} ../bin/${cmd}.old >& /dev/null
	mv -f ${cmd} ../bin/${cmd}
	/bin/rm -f ../bin/${cmd}.old
	unset verbose
end
/bin/rm -f *.o >& /dev/null
echo Setting system name.
echo "UNIX" >! ${SmallEiffel}/sys/system.se
echo Writing default ${SmallEiffel}/sys/loadpath.UNIX
/bin/rm -f ${SmallEiffel}/sys/loadpath.UNIX
echo    "./"                       >  ${SmallEiffel}/sys/loadpath.UNIX
echo    "${SmallEiffel}/lib_std/"  >> ${SmallEiffel}/sys/loadpath.UNIX
echo    "${SmallEiffel}/lib_rand/" >> ${SmallEiffel}/sys/loadpath.UNIX
echo    "${SmallEiffel}/lib_show/" >> ${SmallEiffel}/sys/loadpath.UNIX
echo -n "${SmallEiffel}/lib_se/"   >> ${SmallEiffel}/sys/loadpath.UNIX
echo Done.
