@echo off
rem Written with the help of Nigel BREE

rem C compiler and options:
set CC=gcc
set CC_OPTIONS=-ansi -O6

rem Object file suffix:
set OBJ=.o

rem Compiler option to set executable file name
set EXE_NAME=-o

rem The CC and CC_OPTIONS settings used in the install are not written to the
rem settings files sys/compiler.Windows and sys/linker.Windows by default.
rem If you want to use an alternative compiler, edit those files by hand.

rem If you want to use Borland C++, try using the following options
rem settings. Borland C++ 5.0 has a loop strength reduction bug that
rem means you must either use -O-v or use the Intel back end when
rem compiling some SmallEiffel code. The warnings we disable are for
rem variables and parameters not actually used, and for functions which
rem do not return a value.

rem Under Borland C++, when linking an executable the -e option is used
rem instead of -o; furthermore, there can be no space between the option
rem and the argument.

rem Borland with traditional back end.
rem set CC=bcc32
rem set CC_OPTIONS=-5 -w-aus -w-par -w-rvl -O2 -O-v
rem set OBJ=.obj
rem set EXE_NAME=-e

rem Borland with Intel Reference Compiler back end.
rem set CC=bcc32i
rem set CC_OPTIONS=-5 -w-aus -w-par -w-rvl -O2
rem set OBJ=.obj
rem set EXE_NAME=-e

cls
echo INSTALL SmallEiffel script for Windows NT/95
echo.

rem Under Windows 95 we cannot test for existence of directories in batch
rem files and standard utilities support different switches than NT. As a
rem result we follow a different sequence of operations for Win95 than NT.
rem Under Win95 we can use "deltree" instead of "del /f/q" to erase read-
rem only files, but there is no equivalent to "cd /d" and we need to take
rem steps to see if using it will work.

rem Compiling the split versions of compile_to_c should be easily done with
rem a FOR statement which matches compile_to_c?.c and compile_to_c??.c as
rem patterns. However, the Windows 95 command interpreter has a defect where
rem filename patterns in FOR statements are matched only against the short-
rem format 8.3 filenames, making it useless for this purpose. Even worse,
rem the 8.3 filenames are all upper-case, which causes gratuitous changes
rem of the case of results. Instead, we have to manually generate the indexes.

rem Note also that under Win95, the command processor only treats the first
rem 8 characters of any label as significant in a batch file.

set CLEAN=del /f /q
if exist . goto winnt_clean
set CLEAN=deltree /y
:winnt_clean

if "%SmallEiffel%~"=="~" goto help_smalleiffel
if not exist . goto win95_install

echo System appears to be NT rather than Windows 95

if not exist %SmallEiffel% goto help_exist
cd /d %SmallEiffel%
if errorlevel 1 goto help_cd
if not exist bin mkdir bin
if not exist bin goto help_mkdir_bin

cd bin
echo "dummy" > dummy
del /f /s /q .
cd ..

goto install_common

rem ----------------------------- Windows 95 section
:win95_install

if not exist %SmallEiffel%\READ_ME goto help_exist

rem What we do now is try and change to the smalleiffel directory, and then
rem we try and test for the presences of various files (/not/ directories)
rem from our distribution to see that we actually got where we needed. If
rem not, appeal to the user. Thanks to the test above we expect that the
rem SmallEiffel environment variable is set properly.

cd %SmallEiffel%
if not exist bin_c\compile.c goto help_drive

echo System appears to be Windows 95 rather than NT

deltree /y bin >nul:
mkdir bin

rem ------------------------------- Common section

:install_common

cd sys
%CLEAN% system.se >nul:
if exist system.se goto help_del_system

rem Note that there is no space before the ">" symbol, which is quite
rem important since otherwise "echo" will write the preceding space to
rem the file and confuse the code which reads the generated files.

echo Windows>system.se

%CLEAN% loadpath.Windows >nul:
echo .\> loadpath.Windows
echo %SmallEiffel%\lib_std\>> loadpath.Windows
echo %SmallEiffel%\lib_rand\>> loadpath.Windows
echo %SmallEiffel%\lib_show\>> loadpath.Windows
echo %SmallEiffel%\lib_se\>> loadpath.Windows
rem  Don't know how to avoid last CR with echo :-(

cd ..\bin_c
echo C compiling clean ...
%CLEAN% clean.exe >nul:
%CC% %EXE_NAME%clean.exe %CC_OPTIONS% clean.c
if not exist clean.exe goto clean_help_cc

echo C compiling finder ...
%CLEAN% finder.exe >nul:
%CC% %EXE_NAME%finder.exe %CC_OPTIONS% finder.c
if not exist finder.exe goto finder_help_cc

echo C compiling compile ...
%CLEAN% compile.exe >nul:
%CC% %EXE_NAME%compile.exe %CC_OPTIONS% compile.c
if not exist compile.exe goto compile_help_cc

echo C compiling compile_to_c ...
%CLEAN% compile_to_c.exe >nul:
for %%i in (1 2 3 4 5 6 7 8 9 10) do %CC% %CC_OPTIONS% -c compile_to_c%%i.c
for %%i in (11 12 13 14 15 16 17 18 19 20) do %CC% %CC_OPTIONS% -c compile_to_c%%i.c
for %%i in (21 22 23 24 25 26 27 28 29 30) do %CC% %CC_OPTIONS% -c compile_to_c%%i.c
for %%i in (31 32 33 34 35 36 37 38 39 40) do %CC% %CC_OPTIONS% -c compile_to_c%%i.c
for %%i in (41 42 43 44 45 46 47 48 49) do %CC% %CC_OPTIONS% -c compile_to_c%%i.c
for %%i in (50 51 52 53 54) do %CC% %CC_OPTIONS% -c compile_to_c%%i.c

echo Linking compile_to_c ...
%CC% %EXE_NAME%compile_to_c %CC_OPTIONS% compile_to_c*%OBJ% -lm
if not exist compile_to_c.exe goto compile_to_c_help_cc
%CLEAN% *%OBJ% >nul:

echo C compiling compile_to_jvm...
%CLEAN% compile_to_jvm.exe >nul:
for %%i in (1 2 3 4 5 6 7 8 9 10) do %CC% %CC_OPTIONS% -c compile_to_jvm%%i.c
for %%i in (11 12 13 14 15 16 17 18 19 20) do %CC% %CC_OPTIONS% -c compile_to_jvm%%i.c
for %%i in (21 22 23 24 25 26 27 28 29 30) do %CC% %CC_OPTIONS% -c compile_to_jvm%%i.c
for %%i in (31 32 33 34 35 36 37 38 39 40) do %CC% %CC_OPTIONS% -c compile_to_jvm%%i.c
for %%i in (41 42 43 44 45 46 47 48 49 50) do %CC% %CC_OPTIONS% -c compile_to_jvm%%i.c
for %%i in (51) do %CC% %CC_OPTIONS% -c compile_to_jvm%%i.c

echo Linking compile_to_jvm ...
%CC% %EXE_NAME%compile_to_jvm %CC_OPTIONS% compile_to_jvm*%OBJ% -lm  
if not exist compile_to_jvm.exe goto compile_to_jvm_help_cc
%CLEAN% *%OBJ% >nul: 

echo C compiling pretty...
%CLEAN% pretty.exe >nul:
for %%i in (1 2 3 4 5 6 7 8 9 10) do %CC% %CC_OPTIONS% -c pretty%%i.c
for %%i in (11 12 13 14 15 16 17 18 19 20) do %CC% %CC_OPTIONS% -c pretty%%i.c
for %%i in (21 22 23 24 25 26 27 28 29 30) do %CC% %CC_OPTIONS% -c pretty%%i.c
for %%i in (31 32 33 34 35 36) do %CC% %CC_OPTIONS% -c pretty%%i.c

echo Linking pretty ...
%CC% %EXE_NAME%pretty %CC_OPTIONS% pretty*%OBJ% -lm
if not exist pretty.exe goto pretty_help_cc
%CLEAN% *%OBJ% >nul:

echo C compiling short...
%CLEAN% short.exe >nul:
for %%i in (1 2 3 4 5 6 7 8 9 10) do %CC% %CC_OPTIONS% -c short%%i.c
for %%i in (11 12 13 14 15 16 17 18 19 20) do %CC% %CC_OPTIONS% -c short%%i.c
for %%i in (21 22 23 24 25 26 27 28 29 30) do %CC% %CC_OPTIONS% -c short%%i.c
for %%i in (31 32 33 34 35 36 37 38) do %CC% %CC_OPTIONS% -c short%%i.c

echo Linking short ...
%CC% %EXE_NAME%short %CC_OPTIONS% short*%OBJ% -lm
if not exist short.exe goto short_help_cc
%CLEAN% *%OBJ% >nul:

%CLEAN% %SmallEiffel%\bin\*.exe >nul:
%CLEAN% %SmallEiffel%\bin_c\*%OBJ% >nul:
move %SmallEiffel%\bin_c\*.exe %SmallEiffel%\bin >nul:

rem We don't rename the help files, since .hlp works
cd %SmallEiffel%

goto end_success


rem --------------------------------- help section 
:help_smalleiffel
echo You must set environment variable "SmallEiffel" to
echo the directory in which you want to install SmallEiffel.
goto end_failure

:help_exist
echo Directory "%SmallEiffel%" does not exist.
goto help_smalleiffel
goto end_failure

:help_cd
echo Cannot access directory "%SmallEiffel%".
goto help_smalleiffel
goto end_failure

:help_mkdir_bin
echo Cannot create directory "%SmallEiffel%\bin".
goto end_failure

:help_del_system
echo Cannot remove file "%SmallEiffel%\sys\system.se".
goto end_failure

:clean_help_cc
echo Unable to C compile clean.c to clean.exe.
echo C compiler: %CC%  Options: %CC_OPTIONS%
goto end_failure

:pretty_help_cc
echo Unable to C compile pretty.c to pretty.exe.
echo C compiler: %CC%  Options: %CC_OPTIONS%
goto end_failure

:short_help_cc
echo Unable to C compile short.c to short.exe.
echo C compiler: %CC%  Options: %CC_OPTIONS%
goto end_failure

:finder_help_cc
echo Unable to C compile finder.c to finder.exe.
echo C compiler: %CC%  Options: %CC_OPTIONS%
goto end_failure

:compile_help_cc
echo Unable to C compile compile.c to compile.exe.
echo C compiler: %CC%  Options: %CC_OPTIONS%
goto end_failure

:compile_to_c_help_cc
echo Unable to C compile compile_to_cXX.c to compile.exe.
echo C compiler: %CC%  Options: %CC_OPTIONS%
goto end_failure

:compile_to_jvm_help_cc
echo Unable to C compile compile_to_jvmXX.c to compile.exe.
echo C compiler: %CC%  Options: %CC_OPTIONS%
goto end_failure

:compile_help_cc
echo Unable to C compile prettyXX.c to compile.exe.
echo C compiler: %CC%  Options: %CC_OPTIONS%
goto end_failure

:help_drive
echo Unable to change to the SmallEiffel directory, possibly
echo because it is on a different drive. Please make the current
echo drive the one for "%SmallEiffel%".
goto end_failure

:end_success
echo SmallEiffel Install succeeded.
goto end

:end_failure
echo SmallEiffel Install failed.
goto end

:end
pause
