#include "header.h"

Line::Line() : Glyph() {
        black = new Color(0.0f, 0.0f, 0.0f);
        thin = new Brush(1.0);
        Resource::ref(black);
        Resource::ref(thin);
        linetype = 'd';
}

Line::~Line() {
        Resource::unref(black);
        Resource::unref(thin);
}

void Line::set_linetype(char type) {
        linetype = type;
}

void Line::request(Requisition &req) const {
        Requirement rx(500.0,300.0,200.0,0.0);
        Requirement ry(500.0,300.0,200.0,0.0);
        req.require(Dimension_X,rx);
        req.require(Dimension_Y,ry);
}

void Line::allocate(Canvas *c,const Allocation &a,
                                     Extension &ext) {
        ext.set(c, a);
}

void Line::draw(Canvas *c,const Allocation &a) const {

        Coord x1 = a.left();
        Coord y1 = a.bottom();
        Coord x2 = a.right();
        Coord y2 = a.top();

        c->new_path();
        switch(linetype) {
        case 'd':
        	c->move_to(x1,y1);
        	c->line_to(x2,y2);
        	break;
        case 'h':
        	c->move_to(x1,(y1+y2)/2);
        	c->line_to(x2,(y1+y2)/2);
        	break;
        case 'v':
        	c->move_to((x1+x2)/2,y1);
        	c->line_to((x1+x2)/2,y2);
        	break;
        }
        c->close_path();
        c->stroke(black, thin);
}
