/*
 * Copyright (c) 1993-1997 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* ehelp.c : English help for the editor */

#include <config.h>

extern const char MainHelp[]=
   "The default keymap is described below:\n"
   "\n"
   "            Keys to move\n"
   "Up               - line up\n"
   "Down             - line down\n"
   "Left             - character left\n"
   "Right            - character right\n"
   "Home             - to begin of line\n"
   "End              - to end of line\n"
   "PgUp             - page up\n"
   "PgDn             - page down\n"
   "~Left            - word left\n"
   "~Right           - word right\n"
   "~Home | ^G+B     - to begin of file\n"
   "~End  | ^G+E     - to end of file\n"
   "F8    | ^G+G     - move to line number\n"
   "~F8   | ^G+O     - move to offset\n"
   "\n"
   "            Keys to delete\n"
   "Del | ^D         - delete char right\n"
   "BackSp | ^H      - delete char left\n"
   "^Y               - delete line\n"
   "^K               - delete to EOL\n"
   "^W               - delete word\n"
   "^U               - undelete\n"
   "\n"
   "                 Files\n"
   "F2               - save current file\n"
   "F3               - load another file\n"
   "~F3              - load previous file\n"
   "~F2              - save as...\n"
   "F9               - make\n"
   "~F9              - shell\n"
   "^F9              - run\n"
   "~^F9             - compile\n"
   "\n"
   "                Blocks\n"
   "F5 | F4+B        - set block begin\n"
   "F6 | F4+E        - set block end\n"
   "F4+H             - hide/display block\n"
   "F4+C | F11       - copy block\n"
   "F4+D             - delete block\n"
   "F4+M | F12       - move block\n"
   "F4+W             - write block\n"
   "F4+R             - read block\n"
   "F4+I             - indent block\n"
   "F4+U             - unindent block\n"
   "F4+T             - change block type\n"
   "F4+^B | ^F5      - find block begin\n"
   "F4+^E | ^F6      - find block end\n"
   "~F5              - mark line\n"
   "~F6              - mark to eol\n"
   "F4+P             - to upper case\n"
   "F4+L             - to lower case\n"
   "F4+X             - exchange cases\n"
   "F4+| | M-|       - pipe block through a\n"
   "                   command\n"
   "F4+>             - insert a prefix\n"
   "F4+Y             - insert block from\n"
   "                   buffer. Can be used\n"
   "                   to yank block from\n"
   "                   previous file\n"
   "\n"
   "           Search & Replace\n"
   "F7 | ^F          - search forwards\n"
   "~^F7 | ^B        - search backwards\n"
   "~F7 | ^C         - cont. search/replace\n"
   "^F7 | ^R         - start replace\n"
   "Ctrl-]           - find matching bracket\n"
   "\n"
   "          Exit from the editor\n"
   "^X               - ask to save, then exit\n"
   "\n"
   "             Editor control\n"
   "^O               - start setting options\n"
   "^A+H             - switch HEX mode\n"
   "^A+T             - switch TEXT mode\n"
   "^A+A             - switch autoindent\n"
   "^A+I             - switch insert\n"
   "^A+R             - switch RUS/LAT\n"
   "\n"
   "                Options\n"
   "^O               - start setting options\n"
   "  Enter          - use the setup\n"
   "  F2             - save to current opt file\n"
   "  ~F2            - save to working directory\n"
   "  ^X             - restore old setup\n"
   "  Space          - change item\n"
   "  F1             - help\n"
   "\n"
   " F10 | ^N  - enter main menu\n"
   "\n"
   "                Others\n"
   "^P               - put control character\n"
   "^E               - insert char with a code\n"
   "^L               - refresh screen\n"
   "^V               - copy char below\n"
   "^T               - copy char above\n"
   "~F4              - format functions\n"
   "^F1              - run 'help' program\n"
   "M-/              - comment line (C, C++)\n"
   "\n"
   "                 Note\n"
   "   Some of ^key, ~key and any M-key\n"
   "combinations can be typed as ESC+key\n"
;

extern const char OptionsHelp[]=
   "   Use arrows to navigate, space to\n"
   "change current option. You can also\n"
   "edit the strings and the numbers.\n"
   "\n"
   "   Enter    - use the options within\n"
   "              the current editing\n"
   "              session\n"
   "   Shift-F2 - save the options in\n"
   "              the current directory\n"
   "   F2       - update current options\n"
   "              file\n"
   "   ^X       - quit, do not use the new\n"
   "              options.\n"
   "\n"
   "1. Insert. In this mode characters\n"
   "will be inserted before the character\n"
   "on the cursor and the cursor will be\n"
   "moved one position right.\n"
   "2. Autoindent. In this mode on\n"
   "pressing Enter a new line will be\n"
   "inserted and the cursor will be placed\n"
   "with the margin of the previous\n"
   "line.\n"
   "3. Save Positions. In this mode after\n"
   "loading a file cursor will be placed\n"
   "on its latest position in this file\n"
   "even if you had exited from the\n"
   "editor. Positions are saved in file\n"
   "'$HOME/.le/history'.\n"
   "4. Save History. In this mode you can\n"
   "choose a file name with arrows\n"
   "even if you had exited from the\n"
   "editor. History is saved in file\n"
   "'$HOME/.le/history'.\n"
   "5. Make Backup. This option enables\n"
   "creating backup files with a suffix\n"
   "given below. These are created in current\n"
   "or in specified directory.\n"
   "6. No Regular Expressions. This\n"
   "option disables using regular\n"
   "expressions in search and replace.\n"
   "You will be able not to type '\\' before\n"
   "special characters.\n"
   "7. Latin. In this mode latin letters\n"
   "will be typed.\n"
   "8. Russian. In this mode russian\n"
   "letters will be typed. (works only on\n"
   "certain terminals)\n"
   "9. Graphic. In this mode graphic\n"
   "characters from extended ASCII will be\n"
   "typed. That is, bit 8 will be set.\n"
   "10. Exact. This mode will do for both\n"
   "text and binary files. Strings are\n"
   "right limited, that is you have to\n"
   "type a space to get right from EOL.\n"
   "11. Text. This mode is only for text\n"
   "files. Strings are not right limited.\n"
   "12. Hex. This is hexadesimal mode for\n"
   "binary files.\n"
   "13. Use colors. When set, LE tries to\n"
   "use colors if possible.\n"
   "14. Syntax highlight. When set, syntax\n"
   "constructs will be highlighted, if there\n"
   "is support for current file type. If it\n"
   "works too slow, turn it off.\n"
   "15. Use tabs. Prefer tab inserting.\n"
   "16. BackSp unindents. Specifies if\n"
   "backspace key should move to previous tab\n"
   "stop.\n"
   "17. Lazy page scroll. Specifies PageUp/Down\n"
   "keys behaviour. If set, PageUp moves to\n"
   "page top first, and on second press it\n"
   "moves page up.\n"
   "18. Tab size. Sets size of tab character.\n"
   "19. IndentSize. Sets virtual tab stops.\n"
   "20. Vertical scroll. Specifies how many lines\n"
   "text should be scrolled when cursor moves\n"
   "outside of screen.\n"
   "21. Horizontal scroll. Same for horizontal\n"
   "scrolling.\n"
   "22. Backup suffix specifies the suffix for\n"
   "backup files (simple version control). In\n"
   "This field `%d' can be used, it will be\n"
   "replaced with a version number, the older\n"
   "the greater.\n"
   "23. Backup number specifies the maximum\n"
   "number of backup files for each file.\n"
   "24. Backup path specifies a directory for\n"
   "backup files to be placed into. Default -\n"
   "current directory.\n"
;

extern const char BlockHelp[]=
   "Press:\n"
   "   B   to mark begin of block\n"
   "   E   to mark end of block\n"
   "   C   to copy block\n"
   "   M   to move block\n"
   "   D   to delete block\n"
   "   W   to write block to a file\n"
   "   R   to read block from a file\n"
   "   I   to indent block\n"
   "   U   to unindent block\n"
   "   T   to change block type\n"
   "   L   to convert block or characters\n"
   "to end of line to lower case\n"
   "   P   to convert to upper case\n"
   "   X   to exchange upper/lower cases\n"
   "   H   to hide or unhide block\n"
   "or any other key to leave block\n"
   "functions\n"
   "   |   to pipe the block through a\n"
   "specified UNIX command (such as sed)\n"
   "   >   to insert prefix on the left\n"
   "       side of block\n"
   "   Y   to yank an old block\n"
;

extern const char CalcHelp[]=
   "   This is a postfix calculator. For\n"
   "example, to calculate 2*2 you must\n"
   "type '2 2 *', when it is done stack\n"
   "will contain 4. Now to add 2 you may\n"
   "type '2 +', stack will contain 6, etc.\n"
   "Here are operations of the calculator:\n"
   "  + - * /  simplest arithmetics\n"
   "  %        take remainder of Y/X\n"
   "  sq       square X\n"
   "  sqr      take square root of X\n"
   "  **       rise X to power Y\n"
   "  ln       take natural logarithm\n"
   "  lg       take log10\n"
   "  pi,e     load constants\n"
   "  exp      take exponent of X\n"
   "  del      delete number\n"
   "  clr      clear the stack\n"
   "  xy       swap X and Y\n"
   "  neg      take -X\n"
   "  rev      take 1/X\n"
   "  cp       copy X\n"
   "  sin,cos\n"
;

extern const char FramesHelp[]=
   "   The editor is in frame-drawing\n"
   "mode now. You can use the following\n"
   "control keys:\n"
   "\n"
   "Cursor arrows - draw line\n"
   "Tab           - switch between single,\n"
   "                double and no line mode\n"
   "Any other key - leave the mode\n"
   "\n"
   "You can select graphic character set\n"
   "when modifying terminal options.\n"
   "Note: on some terminals there is no\n"
   "double lines.\n"
;
