#include "phalanx.h"

long T1, T2;

long Time = 600*100;
long Otim = 600*100;


long ptime(void)
{
	if( Flag.easy ) return Nodes;
	else
	if( Flag.cpu ) return clock()*100/CLOCKS_PER_SEC;
	else
	{
		struct timeval t;
		gettimeofday( &t, NULL );
		return t.tv_sec*100 + t.tv_usec/10000;
	}
}



void l_level( int moves, int minutes, int increment )
{
	printf(
	 "level: %i moves in %i minutes, increment %i seconds\n",
	 moves, minutes, increment );
	if( Flag.easy )
	{
		if( moves == 0 ) moves = 80;
		Flag.level = fixedtime;
		Flag.centiseconds =
			(increment+minutes*60/moves)
			* (150-Flag.easy);
		if( Flag.post )
		printf( "setting avg time to %i cs\n", Flag.centiseconds );
	}
	else
	{
		Flag.level = timecontrol;
		Flag.moves = moves;
		Flag.centiseconds = minutes*6000;
		Flag.increment = increment;
	}
}



void l_startsearch(void)
{
	int moves;
	T1 = ptime();

	switch( Flag.level )
	{
	case timecontrol:
		if( Flag.moves > 0 ) moves = 2*Flag.moves;
		else
		{
			moves = Counter +
			        (G[Counter].mtrl+G[Counter].xmtrl)/800;
			if( Counter < 120 )
				moves += 60 - Counter/4;
			else	moves += 30;
		}

		if( Flag.increment == 0 ) T2 = 0;
		else
		if( Time/Flag.increment >= 1600 )
			T2 = Flag.increment * 60;
		else
		if( Time/Flag.increment <= 400 )
			T2 = Flag.increment * 10;
		else
			T2 = Flag.increment * (Time/Flag.increment/8-20)/3;

		if( Flag.post && T2 )
		printf( "    -> increment adds %g s to soft time limit\n",
			((float)T2) / (float)100 );

		T2 += Time / ( moves - Counter%moves + 4 );

		if( Flag.ponder ) T2 += T2/8;

		if( Flag.post )
		printf( "    -> soft time limit %g s\n",
			((float)T2) / (float)100 );

		/*** Now, set up the hard limit ***/
		Flag.centiseconds = Time - 500; /* 5 seconds to flag! move! */
		if( Flag.increment < 10 )
			Flag.centiseconds -= 10*Time/(20-Flag.increment);
		if( Flag.centiseconds < 10 ) Flag.centiseconds = 10;

		if( Flag.post )
		printf( "    -> hard time limit %g s\n",
			((float)Flag.centiseconds) / (float)100 );

	break;
	case averagetime:
		T2 = Flag.centiseconds/3;
	break;
	default: break;
	}

	if( T2 < 1 ) T2 = 1;
}



int l_iterate(void)
{
	if( Flag.level == fixeddepth )
	{
		return ( Depth < Flag.depth );
	}
	else
	if( Flag.level == averagetime || Flag.level == timecontrol )
	{
		long t = ptime();
		switch( EasyMove )
		{
			case 1:  return ( t <= T1 + T2/3 );
			case 2:  return ( t <= T1 + T2/6 );
			default: return ( t <= T1 + T2 );
		}
	}
	else
	return 1;
}

