/*
 * Programm XBLAST V2.5.8 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * April 27th 1997
 * started August 1993
 *
 * File: image.c
 * names of all image data
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define _IMAGE_C

#include "include.h"
#include "mytypes.h"
#include "image.h"

/* background pixmaps */
NormalImageData title_data   = { "title" };
NormalImageData text_bg_data = { "text_bg" };
NormalImageData text_fg_data = { "text_fg" };

/* score board leds */
NormalImageData score_led_data[2] = {
  {"led_off" },
  {"led_on" },
};
/* score board tiles */
NormalImageData score_tile_data[] = {
  { "tile_void" },
  { "text_left" },
  { "text_middle" },
  { "text_right" },
};
/* score player stats */
NormalImageData score_player_data[] = {
  { "player_dead" },
  { "player_sick" },
  { "player" },
};

/* score board tiles */
NormalImageData score_bitmap_data[] = {
  { "tile_void" },
  { "text_left" },
  { "text_middle" },
  { "text_right" },
  { "player_1_dead" },
  { "player_2_dead" },
  { "player_3_dead" },
  { "player_4_dead" },
  { "player_5_dead" },
  { "player_6_dead" },
  { "player_1_sick" },
  { "player_2_sick" },
  { "player_3_sick" },
  { "player_4_sick" },
  { "player_5_sick" },
  { "player_6_sick" },
  { "player_1" },
  { "player_2" },
  { "player_3" },
  { "player_4" },
  { "player_5" },
  { "player_6" },
};

/* bomb bitmaps */
MaskedImageData bomb_bitmap_data[MAX_BOMBS] = {
  { "bomb1_mask", "bomb1", },
  { "bomb2_mask", "bomb2", },
};
/* bomb images */
NormalImageData bomb_image_data[MAX_BOMBS][MAX_BOMB_ANIME] = {
  { 
    { "bomb_0" }, { "bomb_1" }, { "bomb_2" }, { "bomb_3" }, 
    { "bomb_4" }, { "bomb_5" }, { "bomb_6" }, { "bomb_7" },
    { "bomb_8" }, { "bomb_9" }, { "bomb_10"}, { "bomb_11"}, 
    { "bomb_12"}, { "bomb_13"}, { "bomb_14"}, { "bomb_15"} 
  },  
  {
    { "mini_0" }, { "mini_1" }, { "mini_2" }, { "mini_3" }, 
    { "mini_4" }, { "mini_5" }, { "mini_6" }, { "mini_7" },
    { "mini_8" }, { "mini_9" }, { "mini_10"}, { "mini_11"}, 
    { "mini_12"}, { "mini_13"}, { "mini_14"}, { "mini_15"} 
  },
};

/* explosions image */
MaskedImageData expl_data[MAX_EXPLOSION] = {
  { "expl00_mask", "expl00", },
  { "expl01_mask", "expl01", },
  { "expl02_mask", "expl02", },
  { "expl03_mask", "expl03", },
  { "expl04_mask", "expl04", },
  { "expl05_mask", "expl05", },
  { "expl06_mask", "expl06", },
  { "expl07_mask", "expl07", },
  { "expl08_mask", "expl08", },
  { "expl09_mask", "expl09", },
  { "expl0a_mask", "expl0a", },
  { "expl0b_mask", "expl0b", },
  { "expl0c_mask", "expl0c", },
  { "expl0d_mask", "expl0d", },
  { "expl0e_mask", "expl0e", },
  { "expl0f_mask", "expl0f", },
};

/*
 * animation index to bitmap index table
 */
int sprite_bitmap_table[MAX_ANIME] = {
  0,  /* SpriteStopDown */ 
  0,  /* SpriteWalkDown0 */
  1,  /* SpriteWalkDown1 */
  0,  /* SpriteWalkDown2 */
  2,  /* SpriteWalkDown3 */
  3,  /* SpriteStopUp */
  3,  /* SpriteWalkUp0 */
  4,  /* SpriteWalkUp1 */
  3,  /* SpriteWalkUp2 */
  5,  /* SpriteWalkUp3 */
  6,  /* SpriteStopRight */
  6,  /* SpriteWalkRight0 */
  7,  /* SpriteWalkRight1 */
  6,  /* SpriteWalkRight2 */
  8,  /* SpriteWalkRight3 */
  9,  /* SpriteStopLeft */
  9,  /* SpriteWalkLeft0 */
  10, /* SpriteWalkLeft1 */
  9,  /* SpriteWalkLeft2 */
  11, /* SpriteWalkLeft3 */
  12, /* SpriteDeadDown */
  12, /* SpriteDeadLeft */
  12, /* SpriteDeadUp */
  12, /* SpriteDeadRight */
  13, /* SpriteDamagedDown */
  13, /* SpriteDamagedLeft */
  13, /* SpriteDamagedUp */
  13, /* SpriteDamagedRight */
  14, /* SpriteLooser */
  14, /* SpriteLooser1 */
  14, /* SpriteLooser2 */
  15, /* SpriteWinner */
  15, /* SpriteWinner2 */
  15, /* SpriteWinner3 */
  16, /* SpriteBigWinner */
};

/*
 * offset datas for bitmaps
 */
BMRectangle sprite_bitmap_size[MAX_ANIME_BITS] = {
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  { BASE_X, (5*BASE_Y/2), 6*BASE_X, 69*BASE_Y/6 },
  {      0, (5*BASE_Y/2), 8*BASE_X, 69*BASE_Y/6 }, /* winner bitmap */
  { -3*BASE_X, -3*BASE_Y,14*BASE_X, 24*BASE_Y   }, /* big winner bitmap */
};

/*
 * offset datas for image
 */
BMRectangle sprite_image_size[MAX_ANIME] = {
  /* down */
  { 0, 3*BASE_Y, 8*BASE_X, 13*BASE_Y}, 
  { 0, 3*BASE_Y, 8*BASE_X, 13*BASE_Y}, 
  { 0, 3*BASE_Y, 8*BASE_X, 13*BASE_Y}, 
  { 0, 3*BASE_Y, 8*BASE_X, 13*BASE_Y}, 
  { 0, 3*BASE_Y, 8*BASE_X, 13*BASE_Y}, 
  /* up */
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y}, 
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y}, 
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y}, 
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y}, 
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y}, 
  /* right */
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y}, 
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y}, 
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y}, 
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y}, 
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y}, 
  /* left */
  { 0, 4*BASE_Y, 8*BASE_X, 12*BASE_Y}, 
  { 0, 4*BASE_Y, 8*BASE_X, 12*BASE_Y}, 
  { 0, 4*BASE_Y, 8*BASE_X, 12*BASE_Y}, 
  { 0, 4*BASE_Y, 8*BASE_X, 12*BASE_Y}, 
  { 0, 4*BASE_Y, 8*BASE_X, 12*BASE_Y}, 
  /* skeleton */
  { 0, 5*BASE_Y, 8*BASE_X, 10*BASE_Y },
  { 0, 5*BASE_Y, 8*BASE_X, 11*BASE_Y },
  { 0, 5*BASE_Y, 8*BASE_X,  9*BASE_Y },
  { 0, 5*BASE_Y, 8*BASE_X, 11*BASE_Y },
  /* damaged */
  { 0,        (4-1)*BASE_Y, 8*BASE_X, 12*BASE_Y },
  { 1*BASE_X,     6*BASE_Y, 8*BASE_X, 10*BASE_Y },
  { 0,        (7+1)*BASE_Y, 8*BASE_X,  8*BASE_Y },
  {-1*BASE_X,     6*BASE_Y, 8*BASE_X, 10*BASE_Y },
  /* looser */
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y },
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y },
  { 0, 4*BASE_Y, 8*BASE_X, 11*BASE_Y },
  /* winner */
  { 0, 2*BASE_Y, 8*BASE_X, 13*BASE_Y },
  { 0, 3*BASE_Y, 8*BASE_X, 12*BASE_Y },
  { 0, 3*BASE_Y, 8*BASE_X, 12*BASE_Y },
  /* big winner */ 
  { -4*BASE_X, (-8 + 6)*BASE_Y, 16*BASE_X, 24*BASE_Y },
};

PlayerImageData sprite_bitmap[MAX_ANIME_BITS] = 
{
  { TRUE, "pl_mask_1", 
    { "pl_1_1",  "pl_2_1",  "pl_3_1",  "pl_4_1",  "pl_5_1",  "pl_6_1"} },
  { FALSE, "pl_mask_2", 
    { "pl_1_2",  "pl_2_2",  "pl_3_2",  "pl_4_2",  "pl_5_2",  "pl_6_2"} },
  { FALSE, "pl_mask_3", 
    { "pl_1_3",  "pl_2_3",  "pl_3_3",  "pl_4_3",  "pl_5_3",  "pl_6_3"} },
  { FALSE, "pl_mask_4", 
    { "pl_1_4",  "pl_2_4",  "pl_3_4",  "pl_4_4",  "pl_5_4",  "pl_6_4"} },
  { FALSE, "pl_mask_5", 
    { "pl_1_5",  "pl_2_5",  "pl_3_5",  "pl_4_5",  "pl_5_5",  "pl_6_5"} },
  { FALSE, "pl_mask_6", 
    { "pl_1_6",  "pl_2_6",  "pl_3_6",  "pl_4_6",  "pl_5_6",  "pl_6_6"} },
  { FALSE, "pl_mask_7", 
    { "pl_1_7",  "pl_2_7",  "pl_3_7",  "pl_4_7",  "pl_5_7",  "pl_6_7"} },
  { FALSE, "pl_mask_8", 
    { "pl_1_8",  "pl_2_8",  "pl_3_8",  "pl_4_8",  "pl_5_8",  "pl_6_8"} },
  { FALSE, "pl_mask_9", 
    { "pl_1_9",  "pl_2_9",  "pl_3_9",  "pl_4_9",  "pl_5_9",  "pl_6_9"} },
  { FALSE, "pl_mask_10",
    { "pl_1_10", "pl_2_10", "pl_3_10", "pl_4_10", "pl_5_10", "pl_6_10"} },
  { FALSE, "pl_mask_11",
    { "pl_1_11", "pl_2_11", "pl_3_11", "pl_4_11", "pl_5_11", "pl_6_11"} },
  { FALSE, "pl_mask_12",
    { "pl_1_12", "pl_2_12", "pl_3_12", "pl_4_12", "pl_5_12", "pl_6_12"} },
  { FALSE, "pl_mask_13",
    { "pl_1_13", "pl_2_13", "pl_3_13", "pl_4_13", "pl_5_13", "pl_6_13"} },
  { FALSE,  "pl_mask_14",
    { "pl_1_14", "pl_2_14", "pl_3_14", "pl_4_14", "pl_5_14", "pl_6_14"} },
  { TRUE,  "pl_mask_15",
    { "pl_1_15", "pl_2_15", "pl_3_15", "pl_4_15", "pl_5_15", "pl_6_15"} },
  { TRUE, "win_mask",  
    {  "win_1",  "win_2",   "win_3",   "win_4",   "win_5",   "win_6"} },
  { FALSE, "big_mask",  
    {  "big_1",  "big_2",   "big_3",   "big_4",   "big_5",   "big_6"} },
};

ExtendedImageData sprite_image[MAX_ANIME] = {
  /* looking down */
  { TRUE,  TRUE,  "pl_D_S", },
  { TRUE,  FALSE, "pl_D_0", },
  { TRUE,  FALSE, "pl_D_1", },
  { TRUE,  FALSE, "pl_D_2", },
  { TRUE,  FALSE, "pl_D_3", },
  /* looking up */
  { TRUE,  FALSE, "pl_U_S", },
  { TRUE,  FALSE, "pl_U_0", },
  { TRUE,  FALSE, "pl_U_1", },
  { TRUE,  FALSE, "pl_U_2", },
  { TRUE,  FALSE, "pl_U_3", },
  /* looking right */
  { TRUE,  FALSE, "pl_R_S", },
  { TRUE,  FALSE, "pl_R_0", },
  { TRUE,  FALSE, "pl_R_1", },
  { TRUE,  FALSE, "pl_R_2", },
  { TRUE,  FALSE, "pl_R_3", },
  /* looking left */
  { TRUE,  FALSE, "pl_L_S", },
  { TRUE,  FALSE, "pl_L_0", },
  { TRUE,  FALSE, "pl_L_1", },
  { TRUE,  FALSE, "pl_L_2", },
  { TRUE,  FALSE, "pl_L_3", },
  /* skeleton */
  { FALSE, FALSE, "skel_D", },
  { FALSE, FALSE, "skel_L", },
  { FALSE, FALSE, "skel_U", },
  { FALSE, FALSE, "skel_R", },
  /* damaged player */
  { TRUE,  FALSE, "pl_DD", },
  { TRUE,  FALSE, "pl_DL", },
  { TRUE,  FALSE, "pl_DU", },
  { TRUE,  FALSE, "pl_DR", },
  /* loosing player */
  { TRUE,  TRUE,  "pl_L", },
  { TRUE,  TRUE,  "pl_L1", },
  { TRUE,  TRUE,  "pl_L2", },
  /* winning player */
  { TRUE,  TRUE,  "pl_W", },
  { TRUE,  TRUE,  "pl_W2", },
  { TRUE,  TRUE,  "pl_W3", },
  /* big winning player */
  { TRUE,  FALSE, "pl_B", },
};

#ifdef BITMAP_NEW
ExtendedImageData sprite_bitmap_new[MAX_ANIME] = {
  /* looking down */
  { TRUE,  TRUE,  "pl_%sD_S", },
  { TRUE,  FALSE, "pl_%sD_0", },
  { TRUE,  FALSE, "pl_%sD_1", },
  { TRUE,  FALSE, "pl_%sD_2", },
  { TRUE,  FALSE, "pl_%sD_3", },
  /* looking up */
  { TRUE,  FALSE, "pl_%sU_S", },
  { TRUE,  FALSE, "pl_%sU_0", },
  { TRUE,  FALSE, "pl_%sU_1", },
  { TRUE,  FALSE, "pl_%sU_2", },
  { TRUE,  FALSE, "pl_%sU_3", },
  /* looking right */
  { TRUE,  FALSE, "pl_%sR_S", },
  { TRUE,  FALSE, "pl_%sR_0", },
  { TRUE,  FALSE, "pl_%sR_1", },
  { TRUE,  FALSE, "pl_%sR_2", },
  { TRUE,  FALSE, "pl_%sR_3", },
  /* looking left */
  { TRUE,  FALSE, "pl_%sL_S", },
  { TRUE,  FALSE, "pl_%sL_0", },
  { TRUE,  FALSE, "pl_%sL_1", },
  { TRUE,  FALSE, "pl_%sL_2", },
  { TRUE,  FALSE, "pl_%sL_3", },
  /* skeleton */
  { FALSE, FALSE, "skel_%sD", },
  { FALSE, FALSE, "skel_%sL", },
  { FALSE, FALSE, "skel_%sU", },
  { FALSE, FALSE, "skel_%sR", },
  /* damaged player */
  { TRUE,  FALSE, "pl_%sDD", },
  { TRUE,  FALSE, "pl_%sDL", },
  { TRUE,  FALSE, "pl_%sDU", },
  { TRUE,  FALSE, "pl_%sDR", },
  /* loosing player */
  { TRUE,  TRUE,  "pl_%sL", },
  { TRUE,  TRUE,  "pl_%sL1", },
  { TRUE,  TRUE,  "pl_%sL2", },
  /* winning player */
  { TRUE,  TRUE,  "pl_%sW", },
  { TRUE,  TRUE,  "pl_%sW2", },
  { TRUE,  TRUE,  "pl_%sW3", },
  /* big winning player */
  { TRUE,  FALSE, "pl_%sB", },
};
#endif

/*
 * end of file image.c
 */

