/* Zgv v2.7 - GIF, JPEG and PBM/PGM/PPM viewer, for VGA PCs running Linux.
 * Copyright (C) 1993-1995 Russell Marks. See README for license details.
 *
 * readpcx.c - PCX decoder. This is a quick hack so I can use/index a
 *		clip-art CD directly. :-)
 */

/* XXX this could be leaking memory, needs to be checked */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "zgv.h"

struct pcxhed
  {
  byte manuf,ver,encod,bpp;		/* 0 - 3 gen format */
  byte x1lo,x1hi,y1lo,y1hi;		/* 4 - 11 size */
  byte x2lo,x2hi,y2lo,y2hi;
  byte unused1[4];			/* 12 - 15 scrn size */
  byte pal16[48];			/* 16 - 63 4-bit palette */
  byte reserved;			/* 64 reserved */
  byte nplanes;				/* 65 num of bitplanes */
  byte bytelinelo,bytelinehi;		/* 66 - 67 bytes per line */
  byte unused2[60];			/* 68 - 127 unused */
  };  /* palette info is after image data */


/* for aborted_file_pcx_cleanup() */
static unsigned char *work_bmap,*work_pal;
static FILE *work_in;


/* prototypes */
void dispbyte(unsigned char *ptr,int *xp,int *yp,int c,int w,int h,
              int is_mono,int byteline,int pmask);



int read_pcx_file(char *filename,hffunc howfarfunc,unsigned char **bmap,
                  unsigned char **pal,int *output_type,PICINFO *pp)
{
FILE *in;
int w,h,bytepp,x,y,yy,byteline,plane,pmask;
unsigned char *ptr;
struct pcxhed header;
int count,waste;
long bytemax,bytesdone;
byte inbyte,inbyte2;
int is_mono=0;

*bmap=NULL;
*pal=NULL;

if((in=fopen(filename,"rb"))==NULL)
  return(_PICERR_NOFILE);

fread(&header,1,sizeof(struct pcxhed),in);
if(header.manuf!=10 || header.encod!=1 || (header.bpp!=8 && header.bpp!=1))
  return(_PICERR_UNSUPPORTED);

if(header.bpp==1) is_mono=1;
if(header.nplanes>1) is_mono=2;
bytepp=1;
if((*pal=malloc(768))==NULL)
  return(_PICERR_NOMEM);

w=(header.x2lo+256*header.x2hi)-(header.x1lo+256*header.x1hi)+1;
h=(header.y2lo+256*header.y2hi)-(header.y1lo+256*header.y1hi)+1;
byteline=header.bytelinelo+256*header.bytelinehi;

if(w==0 || h==0)
  return(_PICERR_CORRUPT);

x=0; y=0;
bytemax=w*h;
if(is_mono)
  bytemax=(1<<30);	/* we use a 'y<h' test instead for mono files */

/* the normal +2 lines in case we ever do 24-bit, for dithering */
if((*bmap=malloc(w*(h+2)*bytepp))==NULL)
  return(_PICERR_NOMEM);

/* need this if more than one bitplane */
memset(*bmap,0,w*h*bytepp);

bytesdone=0;
ptr=*bmap;

/* save stuff in case of abort */
work_in=in; work_bmap=ptr; work_pal=*pal;

/* start reading image */
for(yy=0;yy<h;yy++)
  {
  if(howfarfunc!=NULL) howfarfunc(y,h);
  
  for(plane=0,pmask=1;plane<header.nplanes;plane++,pmask<<=1)
    {
    y=yy;
    x=0;
    while(y==yy)
      {
      inbyte=fgetc(in);
      if(inbyte<192)
        {
        dispbyte(ptr,&x,&y,inbyte,w,h,is_mono,byteline,pmask);
        bytesdone++;
        }
      else
        {
        inbyte2=fgetc(in);
        inbyte&=63;
        for(count=0;count<inbyte;count++)
          dispbyte(ptr,&x,&y,inbyte2,w,h,is_mono,byteline,pmask);
        bytesdone+=inbyte;
        }
      }
    }
  }

if(is_mono)
  {
  /* mono or 4-bit */
  if(is_mono>1)
    {
    /* 4-bit, palette is embedded in header */
    ptr=*pal;
    for(x=0;x<16;x++)
      {
      ptr[  0]=header.pal16[x*3  ];
      ptr[256]=header.pal16[x*3+1];
      ptr[512]=header.pal16[x*3+2];
      ptr++;
      }
    }
  else
    {
    ptr=*pal;
    ptr[0]=ptr[256]=ptr[512]=0;
    ptr[1]=ptr[257]=ptr[513]=255;
    }
  }
else
  {
  /* 8-bit */
  waste=fgetc(in);                    /* ditch splitter byte */
  /* palette already allocated */
  ptr=*pal;
  for(x=0;x<256;x++)
    {
    ptr[0]  =fgetc(in);
    ptr[256]=fgetc(in);
    ptr[512]=fgetc(in);
    ptr++;
    }
  }

pp->width=w;
pp->height=h;
pp->numcols=(is_mono?(1<<header.nplanes):256);

*output_type=bytepp;

fclose(in);
return(_PIC_OK);  
}


void dispbyte(unsigned char *ptr,int *xp,int *yp,int c,int w,int h,
              int is_mono,int byteline,int pmask)
{
if(is_mono)
  {
  /* mono or 4-bit */
  int f;
  unsigned char *dstptr;
  
  if((*yp)>=h) return;
  
  dstptr=ptr+(*yp)*w+*xp;
  w=byteline*8;
  
  for(f=0;f<8;f++)
    {
    *dstptr++|=(c&(0x80>>(f&7)))?pmask:0;
    (*xp)++; if(*xp>=w) { (*xp)=0,(*yp)++; return; }
    if((*yp)>=h) return;
    }
  }
else
  {
  /* 8-bit */
  *(ptr+(*yp)*w+*xp)=c;
  (*xp)++; if(*xp>=w) (*xp)=0,(*yp)++;
  }
}


void aborted_file_pcx_cleanup()
{
free(work_bmap);
free(work_pal);
fclose(work_in);
}
